/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.openapi;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.ValidationReport;
import io.github.cdimascio.openapi.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B<\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012-\u0010\u0005\u001a)\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004J'\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0082\u0002R5\u0010\u0005\u001a)\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lio/github/cdimascio/openapi/Validator;", "T", "", "swaggerJsonPath", "", "errorHandler", "Lkotlin/Function2;", "Lorg/springframework/http/HttpStatus;", "Lkotlin/ParameterName;", "name", "status", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "swaggerValidator", "Lcom/atlassian/oai/validator/OpenApiInteractionValidator;", "kotlin.jvm.PlatformType", "createSimpleRequestBuilder", "Lcom/atlassian/oai/validator/model/SimpleRequest$Builder;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "key", "validate", "Lreactor/core/publisher/Mono;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "body", "validateAndAwait", "(Lorg/springframework/web/reactive/function/server/ServerRequest;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "contains", "", "Lkotlin/text/Regex;", "text", "", "openapi-spring-webflux-validator"})
public final class Validator<T> {
    @NotNull
    private final Function2<HttpStatus, List<String>, T> errorHandler;
    private final OpenApiInteractionValidator swaggerValidator;

    public Validator(@NotNull String swaggerJsonPath, @NotNull Function2<? super HttpStatus, ? super List<String>, ? extends T> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)swaggerJsonPath, (String)"swaggerJsonPath");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        this.errorHandler = errorHandler;
        this.swaggerValidator = OpenApiInteractionValidator.createFor((String)swaggerJsonPath).build();
    }

    private final boolean contains(Regex $this$contains, CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return $this$contains.matches(text);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Mono<ServerResponse> validate(@NotNull ServerRequest request, @Nullable String body) {
        Mono mono;
        String it;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SimpleRequest.Builder builder = this.createSimpleRequestBuilder(request);
        String string = body;
        if (string != null) {
            it = string;
            boolean bl = false;
            builder.withBody(body);
        }
        SimpleRequest simpleRequest = builder.build();
        it = this.swaggerValidator.validateRequest((Request)simpleRequest);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"swaggerValidator.validateRequest(simpleRequest)");
        String report = it;
        if (report.hasErrors()) {
            void $this$mapTo$iv$iv;
            String bl = ((ValidationReport.Message)report.getMessages().get(0)).getKey();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"report.messages[0].key");
            HttpStatus status = this.status(bl);
            List list = report.getMessages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"report.messages");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ValidationReport.Message message = (ValidationReport.Message)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getMessage());
            }
            List messages = (List)destination$iv$iv;
            Object error = this.errorHandler.invoke((Object)status, (Object)messages);
            BodyInserter e = BodyInserters.fromValue((Object)error);
            mono = ServerResponse.status((HttpStatus)status).body(e);
        } else {
            mono = null;
        }
        return mono;
    }

    public static /* synthetic */ Mono validate$default(Validator validator, ServerRequest serverRequest, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return validator.validate(serverRequest, string);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object validateAndAwait(@NotNull ServerRequest var1_1, @Nullable String var2_2, @NotNull Continuation<? super ServerResponse> var3_3) {
        block10: {
            if (!(var3_3 instanceof validateAndAwait.1)) ** GOTO lbl-1000
            var20_4 = var3_3;
            if ((var20_4.label & -2147483648) != 0) {
                var20_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    /* synthetic */ Object result;
                    final /* synthetic */ Validator<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.validateAndAwait(null, null, (Continuation<ServerResponse>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    builder = this.createSimpleRequestBuilder((ServerRequest)request);
                    if (body != null) {
                        $i$a$-let-Validator$validateAndAwait$2 = false;
                        builder.withBody((String)body);
                    }
                    simpleRequest = builder.build();
                    var7_11 = this.swaggerValidator.validateRequest((Request)simpleRequest);
                    Intrinsics.checkNotNullExpressionValue((Object)var7_11, (String)"swaggerValidator.validateRequest(simpleRequest)");
                    report = var7_11;
                    if (!report.hasErrors()) break;
                    $i$a$-let-Validator$validateAndAwait$2 = ((ValidationReport.Message)report.getMessages().get(0)).getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$a$-let-Validator$validateAndAwait$2, (String)"report.messages[0].key");
                    status = this.status($i$a$-let-Validator$validateAndAwait$2);
                    var9_13 = report.getMessages();
                    Intrinsics.checkNotNullExpressionValue((Object)var9_13, (String)"report.messages");
                    $this$map$iv = var9_13;
                    $i$f$map = false;
                    var11_16 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var16_21 = (ValidationReport.Message)item$iv$iv;
                        var18_23 = destination$iv$iv;
                        $i$a$-map-Validator$validateAndAwait$messages$1 = false;
                        var18_23.add(it.getMessage());
                    }
                    messages = (List)destination$iv$iv;
                    error = this.errorHandler.invoke((Object)status, (Object)messages);
                    var10_15 = ServerResponse.status((HttpStatus)status);
                    Intrinsics.checkNotNullExpressionValue((Object)var10_15, (String)"status(status)");
                    v0 = error;
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                    }
                    $continuation.label = 1;
                    v1 = ServerResponseExtensionsKt.bodyValueAndAwait((ServerResponse.BodyBuilder)var10_15, (Object)v0, (Continuation)$continuation);
                    if (v1 == var21_6) {
                        return var21_6;
                    }
                    ** GOTO lbl55
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    v2 = (ServerResponse)v1;
                    break block10;
                }
            }
            v2 = null;
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object validateAndAwait$default(Validator validator, ServerRequest serverRequest, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return validator.validateAndAwait(serverRequest, string, (Continuation<ServerResponse>)continuation);
    }

    private final HttpStatus status(String key) {
        String string = key;
        return this.contains(new Regex("validation.request.contentType.notAllowed"), string) ? HttpStatus.UNSUPPORTED_MEDIA_TYPE : (this.contains(new Regex("validation.request.contentType.invalid"), string) ? HttpStatus.UNSUPPORTED_MEDIA_TYPE : (this.contains(new Regex("validation.request.path.missing"), string) ? HttpStatus.NOT_FOUND : (this.contains(new Regex("validation.request.accept.invalid"), string) ? HttpStatus.NOT_ACCEPTABLE : (this.contains(new Regex("validation.request.operation.notAllowed"), string) ? HttpStatus.METHOD_NOT_ALLOWED : HttpStatus.BAD_REQUEST))));
    }

    private final SimpleRequest.Builder createSimpleRequestBuilder(ServerRequest request) {
        Object it;
        String string = request.methodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.methodName()");
        Request.Method method = Request.Method.valueOf((String)string);
        SimpleRequest.Builder requestBuilder = new SimpleRequest.Builder(method, request.path());
        Set set = request.headers().asHttpHeaders().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"request.headers().asHttpHeaders().keys");
        Iterable headerNames = set;
        Iterable $this$forEach$iv = request.queryParams().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Map.Entry)element$iv;
            boolean bl = false;
            requestBuilder.withQueryParam((String)it.getKey(), (List)it.getValue());
        }
        $this$forEach$iv = headerNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            requestBuilder.withHeader((String)it, request.headers().header((String)it));
        }
        return requestBuilder;
    }
}

