/**
 * <h1>CDK CFN Guard Validator Plugin</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Installing</h2>
 * <p>
 * <h3>TypeScript/JavaScript</h3>
 * <p>
 * <blockquote><pre>
 * npm install &#64;cdklabs/cdk-validator-cfnguard
 * </pre></blockquote>
 * <p>
 * <h3>Python</h3>
 * <p>
 * <blockquote><pre>
 * pip install cdklabs.cdk-validator-cfnguard
 * </pre></blockquote>
 * <p>
 * <h3>Java</h3>
 * <p>
 * <blockquote><pre>
 * // add this to your pom.xml
 * &lt;dependency&gt;
 *     &lt;groupId&gt;io.github.cdklabs&lt;/groupId&gt;
 *     &lt;artifactId&gt;cdk-validator-cfnguard&lt;/artifactId&gt;
 *     &lt;version&gt;0.0.0&lt;/version&gt; // replace with version
 * &lt;/dependency&gt;
 * </pre></blockquote>
 * <p>
 * <h3>.NET</h3>
 * <p>
 * <blockquote><pre>
 * dotnet add package Cdklabs.CdkValidatorCfnGuard --version X.X.X
 * </pre></blockquote>
 * <p>
 * <h2>Usage</h2>
 * <p>
 * To use this plugin in your CDK application add it to the CDK App.
 * <p>
 * <blockquote><pre>
 * App.Builder.create()
 *         .policyValidationBeta1(List.of(
 *             new CfnGuardValidator()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default the <code>CfnGuardValidator</code> plugin comes with the <a href="https://docs.aws.amazon.com/controltower/latest/userguide/proactive-controls.html">Control Tower
 * proactive
 * controls</a>
 * enabled. In order to disable these rules you can use the
 * <code>controlTowerRulesEnabled: false</code> property.
 * <p>
 * <blockquote><pre>
 * CfnGuardValidator.Builder.create()
 *         .controlTowerRulesEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * It is also possible to disable individual rules.
 * <p>
 * <blockquote><pre>
 * CfnGuardValidator.Builder.create()
 *         .disabledRules(List.of("ct-s3-pr-1"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Additional rules</h3>
 * <p>
 * To provide additional rules to the plugin, provide a list of local
 * file or directory paths.
 * <p>
 * <blockquote><pre>
 * CfnGuardValidator.Builder.create()
 *         .rules(List.of("path/to/local-rules-directory", "path/to/s3/local-rules/my-rule.guard"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If the path provided is a directory then the directory must only
 * contain guard rule files, and all rules within the directory will be used.
 * <p>
 * <h2>Using the bundled Control Tower proactive controls in CDK</h2>
 * <p>
 * The bundled Control Tower proactive controls use CloudFormation Guard
 * policies that are also used in managed controls from the Control Tower
 * service. You can use these CDK bundled controls without having a Control
 * Tower environment in AWS, but there are many benefits to using the two together.
 * <p>
 * When you enable Control Tower proactive controls in your Control Tower environment,
 * the controls can stop the deployment of non-compliant resources deployed via
 * CloudFormation. For more information about managed proactive controls and how they work,
 * see the <a href="https://docs.aws.amazon.com/controltower/latest/userguide/proactive-controls.html">Control Tower documentation</a>.
 * <p>
 * These CDK bundled controls and managed Control Tower proactive controls are best used together.
 * In this scenario you can configure this validation plugin with the same proactive controls that
 * are active in your Control Tower cloud environment. You can then quickly gain confidence
 * that your CDK application will pass the Control Tower controls by running cdk synth locally
 * or in a pipeline as described above.
 * <p>
 * Regardless of whether you or your organization use Control Tower, however, you should
 * understand the following things about these bundled controls when run locally using this plugin:
 * <p>
 * <ol>
 * <li>These CloudFormation guard policies accept a limited subset of CloudFormation syntax
 * for the properties they evaluate. For instance, a property called EncryptionEnabled may
 * pass if it is specified with the literal value true, but it may fail if it is specified with
 * a reference to a CloudFormation stack parameter instead. Similarly, if a rule checks for a string
 * value, it may fail for Fn::Join objects. If you discover that a rule can be bypassed with a
 * particular configuration of a resource, please file an issue.</li>
 * <li>Some rules may check references to other resources, but this reference checking is limited.
 * For instance, a rule may require that an access logging bucket is specified for each S3 bucket.
 * In this case, the rule can check whether you have passed a reference to a bucket in the same
 * template, but it cannot verify that a hardcoded bucket name like "examplebucket" actually refers
 * to a real bucket or a bucket you own.</li>
 * </ol>
 * <p>
 * You can add a layer of security protection by enabling the same proactive controls in your Control Tower
 * cloud environment. There are different considerations for using these controls since they operate in a
 * different way. For more information, see the <a href="https://docs.aws.amazon.com/controltower/latest/userguide/proactive-controls.html">Control Tower proactive controls documentation</a>.
 * <p>
 * If you do not yet have a Control Tower environment, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/what-is-control-tower.html">What is AWS Control Tower?</a>.
 * <p>
 * <h3>Bundled Rules</h3>
 * <p>
 * | Control Tower rule ID | Control Tower docs link | Description |
 * | --------------------- | ----------------------- | ---------------- |
 * | CT.IAM.PR.2 | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/iam-rules.html#ct-iam-pr-2-description">docs</a> | This control checks whether AWS Identity and Access Management (IAM) customer managed policies do not include "Effect": "Allow" with "Action": "<em>" over "Resource": "</em>"." |
 * | CT.EC2.PR.5 | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/ec2-rules.html#ct-ec2-pr-5-description">docs</a> | This control checks whether the Amazon EC2 network ACL inbound entry allows unrestricted incoming traffic (0.0.0.0/0 or ::/0) for SSH or RDP. |
 * | CT.EC2.PR.7 | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/ec2-rules.html#ct-ec2-pr-7-description">docs</a> | This control checks whether your standalone Amazon EC2 EBS volumes and new Amazon EBS volumes created through EC2 instance Block Device Mappings are encrypted at rest. |
 * | CT.RDS.PR.16 | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/rds-rules.html#ct-rds-pr-16-description">docs</a> | This control checks whether the storage encryption is configured on Amazon Relational Database Service (RDS) database (DB) clusters that are not being restored from an existing cluster. |
 * | CT.S3.PR.1  | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/s3-rules.html#ct-s3-pr-1-description">docs</a> | This control checks whether your Amazon Simple Storage Service (Amazon S3) bucket has a bucket-level Block Public Access (BPA) configuration. |
 * | CT.S3.PR.2  | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/s3-rules.html#ct-s3-pr-2-description">docs</a> | This control checks whether server access logging is enabled for your Amazon S3 bucket. |
 * | CT.S3.PR.7  | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/s3-rules.html#ct-s3-pr-7-description">docs</a> | This control checks whether default server-side encryption is enabled on your Amazon S3 bucket. |
 * | CT.S3.PR.8  | <a href="https://docs.aws.amazon.com/controltower/latest/userguide/s3-rules.html#ct-s3-pr-8-description">docs</a> | This control checks whether Amazon S3 bucket policies require requests to use Secure Socket Layer (SSL). |
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package io.github.cdklabs.cdkvalidatorcfnguard;
