package io.github.cdklabs.projen.awscdk;

/**
 * (experimental) Generates a pre-bundled AWS Lambda function construct from handler code.
 * <p>
 * To use this, create an AWS Lambda handler file under your source tree with
 * the <code>.lambda.ts</code> extension and add a <code>LambdaFunction</code> component to your
 * typescript project pointing to this entrypoint.
 * <p>
 * This will add a task to your "compile" step which will use <code>esbuild</code> to
 * bundle the handler code into the build directory. It will also generate a
 * file <code>src/foo-function.ts</code> with a custom AWS construct called <code>FooFunction</code>
 * which extends <code>&#64;aws-cdk/aws-lambda.Function</code> which is bound to the bundled
 * handle through an asset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * new LambdaFunction(myProject, {
 *   srcdir: myProject.srcdir,
 *   entrypoint: 'src/foo.lambda.ts',
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.612Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.awscdk.LambdaFunction")
public class LambdaFunction extends io.github.cdklabs.projen.Component {

    protected LambdaFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Defines a pre-bundled AWS Lambda function construct from handler code.
     * <p>
     * @param project The project to use. This parameter is required.
     * @param options Options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LambdaFunction(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.awscdk.LambdaFunctionOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.awscdk.LambdaFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.awscdk.LambdaFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project The project to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private final io.github.cdklabs.projen.awscdk.LambdaFunctionOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
            this.options = new io.github.cdklabs.projen.awscdk.LambdaFunctionOptions.Builder();
        }

        /**
         * (experimental) Bundling options for this AWS Lambda function.
         * <p>
         * If not specified the default bundling options specified for the project
         * <code>Bundler</code> instance will be used.
         * <p>
         * Default: - defaults
         * <p>
         * @return {@code this}
         * @param bundlingOptions Bundling options for this AWS Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundlingOptions(final io.github.cdklabs.projen.javascript.BundlingOptions bundlingOptions) {
            this.options.bundlingOptions(bundlingOptions);
            return this;
        }

        /**
         * (experimental) The node.js version to target.
         * <p>
         * Default: Runtime.NODEJS_14_X
         * <p>
         * @return {@code this}
         * @param runtime The node.js version to target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(final io.github.cdklabs.projen.awscdk.LambdaRuntime runtime) {
            this.options.runtime(runtime);
            return this;
        }

        /**
         * (experimental) AWS CDK dependency manager.
         * <p>
         * @return {@code this}
         * @param cdkDeps AWS CDK dependency manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkDeps(final io.github.cdklabs.projen.awscdk.AwsCdkDeps cdkDeps) {
            this.options.cdkDeps(cdkDeps);
            return this;
        }

        /**
         * (experimental) A path from the project root directory to a TypeScript file which contains the AWS Lambda handler entrypoint (exports a `handler` function).
         * <p>
         * This is relative to the root directory of the project.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated from non-compiling source. May contain errors.
         * "src/subdir/foo.lambda.ts"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param entrypoint A path from the project root directory to a TypeScript file which contains the AWS Lambda handler entrypoint (exports a `handler` function). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypoint(final java.lang.String entrypoint) {
            this.options.entrypoint(entrypoint);
            return this;
        }

        /**
         * (experimental) The name of the generated TypeScript source file.
         * <p>
         * This file should also be
         * under the source tree.
         * <p>
         * Default: - The name of the entrypoint file, with the `-function.ts` suffix
         * instead of `.lambda.ts`.
         * <p>
         * @return {@code this}
         * @param constructFile The name of the generated TypeScript source file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder constructFile(final java.lang.String constructFile) {
            this.options.constructFile(constructFile);
            return this;
        }

        /**
         * (experimental) The name of the generated `lambda.Function` subclass.
         * <p>
         * Default: - A pascal cased version of the name of the entrypoint file, with
         * the extension `Function` (e.g. `ResizeImageFunction`).
         * <p>
         * @return {@code this}
         * @param constructName The name of the generated `lambda.Function` subclass. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder constructName(final java.lang.String constructName) {
            this.options.constructName(constructName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.awscdk.LambdaFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.awscdk.LambdaFunction build() {
            return new io.github.cdklabs.projen.awscdk.LambdaFunction(
                this.project,
                this.options.build()
            );
        }
    }
}
