package io.github.cdklabs.projen.cdktf;

/**
 * (experimental) CDKTF construct library project.
 * <p>
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Terraform (CDKTF), with a friendly workflow and
 * automatic publishing to the construct catalog.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.cdktf.ConstructLibraryCdktf")
public class ConstructLibraryCdktf extends io.github.cdklabs.projen.cdk.ConstructLibrary {

    protected ConstructLibraryCdktf(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConstructLibraryCdktf(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ConstructLibraryCdktf(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.cdktf.ConstructLibraryCdktfOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.cdktf.ConstructLibraryCdktf}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.cdktf.ConstructLibraryCdktf> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final io.github.cdklabs.projen.cdktf.ConstructLibraryCdktfOptions.Builder options;

        private Builder() {
            this.options = new io.github.cdklabs.projen.cdktf.ConstructLibraryCdktfOptions.Builder();
        }

        /**
         * (experimental) This is the name of your project.
         * <p>
         * Default: $BASEDIR
         * <p>
         * @return {@code this}
         * @param name This is the name of your project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * (experimental) Configure logging options such as verbosity.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param logging Configure logging options such as verbosity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(final io.github.cdklabs.projen.LoggerOptions logging) {
            this.options.logging(logging);
            return this;
        }

        /**
         * (experimental) The root directory of the project.
         * <p>
         * Relative to this directory, all files are synthesized.
         * <p>
         * If this project has a parent, this directory is relative to the parent
         * directory and it cannot be the same as the parent or any of it's other
         * sub-projects.
         * <p>
         * Default: "."
         * <p>
         * @return {@code this}
         * @param outdir The root directory of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outdir(final java.lang.String outdir) {
            this.options.outdir(outdir);
            return this;
        }

        /**
         * (experimental) The parent project, if this project is part of a bigger project.
         * <p>
         * @return {@code this}
         * @param parent The parent project, if this project is part of a bigger project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parent(final io.github.cdklabs.projen.Project parent) {
            this.options.parent(parent);
            return this;
        }

        /**
         * (experimental) The shell command to use in order to run the projen CLI.
         * <p>
         * Can be used to customize in special environments.
         * <p>
         * Default: "npx projen"
         * <p>
         * @return {@code this}
         * @param projenCommand The shell command to use in order to run the projen CLI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenCommand(final java.lang.String projenCommand) {
            this.options.projenCommand(projenCommand);
            return this;
        }

        /**
         * (experimental) Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param projenrcJson Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJson(final java.lang.Boolean projenrcJson) {
            this.options.projenrcJson(projenrcJson);
            return this;
        }

        /**
         * (experimental) Options for .projenrc.json.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param projenrcJsonOptions Options for .projenrc.json. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJsonOptions(final io.github.cdklabs.projen.ProjenrcOptions projenrcJsonOptions) {
            this.options.projenrcJsonOptions(projenrcJsonOptions);
            return this;
        }

        /**
         * (experimental) Enable and configure the 'auto approve' workflow.
         * <p>
         * Default: - auto approve is disabled
         * <p>
         * @return {@code this}
         * @param autoApproveOptions Enable and configure the 'auto approve' workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoApproveOptions(final io.github.cdklabs.projen.github.AutoApproveOptions autoApproveOptions) {
            this.options.autoApproveOptions(autoApproveOptions);
            return this;
        }

        /**
         * (experimental) Configure options for automatic merging on GitHub.
         * <p>
         * Has no effect if
         * <code>github.mergify</code> is set to false.
         * <p>
         * Default: - see defaults in `AutoMergeOptions`
         * <p>
         * @return {@code this}
         * @param autoMergeOptions Configure options for automatic merging on GitHub. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoMergeOptions(final io.github.cdklabs.projen.github.AutoMergeOptions autoMergeOptions) {
            this.options.autoMergeOptions(autoMergeOptions);
            return this;
        }

        /**
         * (experimental) Add a `clobber` task which resets the repo to origin.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param clobber Add a `clobber` task which resets the repo to origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clobber(final java.lang.Boolean clobber) {
            this.options.clobber(clobber);
            return this;
        }

        /**
         * (experimental) Add a VSCode development environment (used for GitHub Codespaces).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param devContainer Add a VSCode development environment (used for GitHub Codespaces). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder devContainer(final java.lang.Boolean devContainer) {
            this.options.devContainer(devContainer);
            return this;
        }

        /**
         * (experimental) Enable GitHub integration.
         * <p>
         * Enabled by default for root projects. Disabled for non-root projects.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param github Enable GitHub integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder github(final java.lang.Boolean github) {
            this.options.github(github);
            return this;
        }

        /**
         * (experimental) Options for GitHub integration.
         * <p>
         * Default: - see GitHubOptions
         * <p>
         * @return {@code this}
         * @param githubOptions Options for GitHub integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder githubOptions(final io.github.cdklabs.projen.github.GitHubOptions githubOptions) {
            this.options.githubOptions(githubOptions);
            return this;
        }

        /**
         * (experimental) Add a Gitpod development environment.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param gitpod Add a Gitpod development environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitpod(final java.lang.Boolean gitpod) {
            this.options.gitpod(gitpod);
            return this;
        }

        /**
         * (deprecated) Whether mergify should be enabled on this repository or not.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated use `githubOptions.mergify` instead
         * @param mergify Whether mergify should be enabled on this repository or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder mergify(final java.lang.Boolean mergify) {
            this.options.mergify(mergify);
            return this;
        }

        /**
         * (deprecated) Options for mergify.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @deprecated use `githubOptions.mergifyOptions` instead
         * @param mergifyOptions Options for mergify. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder mergifyOptions(final io.github.cdklabs.projen.github.MergifyOptions mergifyOptions) {
            this.options.mergifyOptions(mergifyOptions);
            return this;
        }

        /**
         * (deprecated) Which type of project this is (library/app).
         * <p>
         * Default: ProjectType.UNKNOWN
         * <p>
         * @return {@code this}
         * @deprecated no longer supported at the base project level
         * @param projectType Which type of project this is (library/app). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder projectType(final io.github.cdklabs.projen.ProjectType projectType) {
            this.options.projectType(projectType);
            return this;
        }

        /**
         * (experimental) The README setup.
         * <p>
         * Default: - { filename: 'README.md', contents: '# replace this' }
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated from non-compiling source. May contain errors.
         * "{ filename: 'readme.md', contents: '# title' }"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param readme The README setup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readme(final io.github.cdklabs.projen.SampleReadmeProps readme) {
            this.options.readme(readme);
            return this;
        }

        /**
         * (experimental) Auto-close of stale issues and pull request.
         * <p>
         * See <code>staleOptions</code> for options.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stale Auto-close of stale issues and pull request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stale(final java.lang.Boolean stale) {
            this.options.stale(stale);
            return this;
        }

        /**
         * (experimental) Auto-close stale issues and pull requests.
         * <p>
         * To disable set <code>stale</code> to <code>false</code>.
         * <p>
         * Default: - see defaults in `StaleOptions`
         * <p>
         * @return {@code this}
         * @param staleOptions Auto-close stale issues and pull requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder staleOptions(final io.github.cdklabs.projen.github.StaleOptions staleOptions) {
            this.options.staleOptions(staleOptions);
            return this;
        }

        /**
         * (experimental) Enable VSCode integration.
         * <p>
         * Enabled by default for root projects. Disabled for non-root projects.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param vscode Enable VSCode integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vscode(final java.lang.Boolean vscode) {
            this.options.vscode(vscode);
            return this;
        }

        /**
         * (experimental) Allow the project to include `peerDependencies` and `bundledDependencies`.
         * <p>
         * This is normally only allowed for libraries. For apps, there's no meaning
         * for specifying these.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowLibraryDependencies Allow the project to include `peerDependencies` and `bundledDependencies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowLibraryDependencies(final java.lang.Boolean allowLibraryDependencies) {
            this.options.allowLibraryDependencies(allowLibraryDependencies);
            return this;
        }

        /**
         * (experimental) Author's e-mail.
         * <p>
         * @return {@code this}
         * @param authorEmail Author's e-mail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorEmail(final java.lang.String authorEmail) {
            this.options.authorEmail(authorEmail);
            return this;
        }

        /**
         * (experimental) Author's name.
         * <p>
         * @return {@code this}
         * @param authorName Author's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorName(final java.lang.String authorName) {
            this.options.authorName(authorName);
            return this;
        }

        /**
         * (experimental) Author's Organization.
         * <p>
         * @return {@code this}
         * @param authorOrganization Author's Organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorOrganization(final java.lang.Boolean authorOrganization) {
            this.options.authorOrganization(authorOrganization);
            return this;
        }

        /**
         * (experimental) Author's URL / Website.
         * <p>
         * @return {@code this}
         * @param authorUrl Author's URL / Website. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorUrl(final java.lang.String authorUrl) {
            this.options.authorUrl(authorUrl);
            return this;
        }

        /**
         * (experimental) Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoDetectBin Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoDetectBin(final java.lang.Boolean autoDetectBin) {
            this.options.autoDetectBin(autoDetectBin);
            return this;
        }

        /**
         * (experimental) Binary programs vended with your module.
         * <p>
         * You can use this option to add/customize how binaries are represented in
         * your <code>package.json</code>, but unless <code>autoDetectBin</code> is <code>false</code>, every
         * executable file under <code>bin</code> will automatically be added to this section.
         * <p>
         * @return {@code this}
         * @param bin Binary programs vended with your module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bin(final java.util.Map<java.lang.String, java.lang.String> bin) {
            this.options.bin(bin);
            return this;
        }

        /**
         * (experimental) List of dependencies to bundle into this module.
         * <p>
         * These modules will be
         * added both to the <code>dependencies</code> section and <code>bundledDependencies</code> section of
         * your <code>package.json</code>.
         * <p>
         * The recommendation is to only specify the module name here (e.g.
         * <code>express</code>). This will behave similar to <code>yarn add</code> or <code>npm install</code> in the
         * sense that it will add the module as a dependency to your <code>package.json</code>
         * file with the latest version (<code>^</code>). You can specify semver requirements in
         * the same syntax passed to <code>npm i</code> or <code>yarn add</code> (e.g. <code>express&#64;^2</code>) and
         * this will be what you <code>package.json</code> will eventually include.
         * <p>
         * @return {@code this}
         * @param bundledDeps List of dependencies to bundle into this module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundledDeps(final java.util.List<java.lang.String> bundledDeps) {
            this.options.bundledDeps(bundledDeps);
            return this;
        }

        /**
         * (experimental) Options for publishing npm package to AWS CodeArtifact.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param codeArtifactOptions Options for publishing npm package to AWS CodeArtifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeArtifactOptions(final io.github.cdklabs.projen.javascript.CodeArtifactOptions codeArtifactOptions) {
            this.options.codeArtifactOptions(codeArtifactOptions);
            return this;
        }

        /**
         * (experimental) Runtime dependencies of this module.
         * <p>
         * The recommendation is to only specify the module name here (e.g.
         * <code>express</code>). This will behave similar to <code>yarn add</code> or <code>npm install</code> in the
         * sense that it will add the module as a dependency to your <code>package.json</code>
         * file with the latest version (<code>^</code>). You can specify semver requirements in
         * the same syntax passed to <code>npm i</code> or <code>yarn add</code> (e.g. <code>express&#64;^2</code>) and
         * this will be what you <code>package.json</code> will eventually include.
         * <p>
         * Default: []
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated from non-compiling source. May contain errors.
         * [ 'express', 'lodash', 'foo&#64;^2' ]
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param deps Runtime dependencies of this module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deps(final java.util.List<java.lang.String> deps) {
            this.options.deps(deps);
            return this;
        }

        /**
         * (experimental) The description is just a string that helps people understand the purpose of the package.
         * <p>
         * It can be used when searching for packages in a package manager as well.
         * See https://classic.yarnpkg.com/en/docs/package-json/#toc-description
         * <p>
         * @return {@code this}
         * @param description The description is just a string that helps people understand the purpose of the package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.options.description(description);
            return this;
        }

        /**
         * (experimental) Build dependencies for this module.
         * <p>
         * These dependencies will only be
         * available in your build environment but will not be fetched when this
         * module is consumed.
         * <p>
         * The recommendation is to only specify the module name here (e.g.
         * <code>express</code>). This will behave similar to <code>yarn add</code> or <code>npm install</code> in the
         * sense that it will add the module as a dependency to your <code>package.json</code>
         * file with the latest version (<code>^</code>). You can specify semver requirements in
         * the same syntax passed to <code>npm i</code> or <code>yarn add</code> (e.g. <code>express&#64;^2</code>) and
         * this will be what you <code>package.json</code> will eventually include.
         * <p>
         * Default: []
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated from non-compiling source. May contain errors.
         * [ 'typescript', '&#64;types/express' ]
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param devDeps Build dependencies for this module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder devDeps(final java.util.List<java.lang.String> devDeps) {
            this.options.devDeps(devDeps);
            return this;
        }

        /**
         * (experimental) Module entrypoint (`main` in `package.json`).
         * <p>
         * Set to an empty string to not include <code>main</code> in your package.json
         * <p>
         * Default: "lib/index.js"
         * <p>
         * @return {@code this}
         * @param entrypoint Module entrypoint (`main` in `package.json`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypoint(final java.lang.String entrypoint) {
            this.options.entrypoint(entrypoint);
            return this;
        }

        /**
         * (experimental) Package's Homepage / Website.
         * <p>
         * @return {@code this}
         * @param homepage Package's Homepage / Website. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder homepage(final java.lang.String homepage) {
            this.options.homepage(homepage);
            return this;
        }

        /**
         * (experimental) Keywords to include in `package.json`.
         * <p>
         * @return {@code this}
         * @param keywords Keywords to include in `package.json`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keywords(final java.util.List<java.lang.String> keywords) {
            this.options.keywords(keywords);
            return this;
        }

        /**
         * (experimental) License's SPDX identifier.
         * <p>
         * See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
         * Use the <code>licensed</code> option if you want to no license to be specified.
         * <p>
         * Default: "Apache-2.0"
         * <p>
         * @return {@code this}
         * @param license License's SPDX identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder license(final java.lang.String license) {
            this.options.license(license);
            return this;
        }

        /**
         * (experimental) Indicates if a license should be added.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param licensed Indicates if a license should be added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder licensed(final java.lang.Boolean licensed) {
            this.options.licensed(licensed);
            return this;
        }

        /**
         * (experimental) Minimum node.js version to require via `engines` (inclusive).
         * <p>
         * Default: - no max
         * <p>
         * @return {@code this}
         * @param maxNodeVersion Minimum node.js version to require via `engines` (inclusive). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxNodeVersion(final java.lang.String maxNodeVersion) {
            this.options.maxNodeVersion(maxNodeVersion);
            return this;
        }

        /**
         * (experimental) Minimum Node.js version to require via package.json `engines` (inclusive).
         * <p>
         * Default: - no "engines" specified
         * <p>
         * @return {@code this}
         * @param minNodeVersion Minimum Node.js version to require via package.json `engines` (inclusive). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minNodeVersion(final java.lang.String minNodeVersion) {
            this.options.minNodeVersion(minNodeVersion);
            return this;
        }

        /**
         * (experimental) Access level of the npm package.
         * <p>
         * Default: - for scoped packages (e.g. `foo@bar`), the default is
         * `NpmAccess.RESTRICTED`, for non-scoped packages, the default is
         * `NpmAccess.PUBLIC`.
         * <p>
         * @return {@code this}
         * @param npmAccess Access level of the npm package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmAccess(final io.github.cdklabs.projen.javascript.NpmAccess npmAccess) {
            this.options.npmAccess(npmAccess);
            return this;
        }

        /**
         * (deprecated) The host name of the npm registry to publish to.
         * <p>
         * Cannot be set together with <code>npmRegistryUrl</code>.
         * <p>
         * @return {@code this}
         * @deprecated use `npmRegistryUrl` instead
         * @param npmRegistry The host name of the npm registry to publish to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder npmRegistry(final java.lang.String npmRegistry) {
            this.options.npmRegistry(npmRegistry);
            return this;
        }

        /**
         * (experimental) The base URL of the npm package registry.
         * <p>
         * Must be a URL (e.g. start with "https://" or "http://")
         * <p>
         * Default: "https://registry.npmjs.org"
         * <p>
         * @return {@code this}
         * @param npmRegistryUrl The base URL of the npm package registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmRegistryUrl(final java.lang.String npmRegistryUrl) {
            this.options.npmRegistryUrl(npmRegistryUrl);
            return this;
        }

        /**
         * (experimental) GitHub secret which contains the NPM token to use when publishing packages.
         * <p>
         * Default: "NPM_TOKEN"
         * <p>
         * @return {@code this}
         * @param npmTokenSecret GitHub secret which contains the NPM token to use when publishing packages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmTokenSecret(final java.lang.String npmTokenSecret) {
            this.options.npmTokenSecret(npmTokenSecret);
            return this;
        }

        /**
         * (experimental) The Node Package Manager used to execute scripts.
         * <p>
         * Default: NodePackageManager.YARN
         * <p>
         * @return {@code this}
         * @param packageManager The Node Package Manager used to execute scripts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder packageManager(final io.github.cdklabs.projen.javascript.NodePackageManager packageManager) {
            this.options.packageManager(packageManager);
            return this;
        }

        /**
         * (experimental) The "name" in package.json.
         * <p>
         * Default: - defaults to project name
         * <p>
         * @return {@code this}
         * @param packageName The "name" in package.json. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder packageName(final java.lang.String packageName) {
            this.options.packageName(packageName);
            return this;
        }

        /**
         * (experimental) Options for `peerDeps`.
         * <p>
         * @return {@code this}
         * @param peerDependencyOptions Options for `peerDeps`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder peerDependencyOptions(final io.github.cdklabs.projen.javascript.PeerDependencyOptions peerDependencyOptions) {
            this.options.peerDependencyOptions(peerDependencyOptions);
            return this;
        }

        /**
         * (experimental) Peer dependencies for this module.
         * <p>
         * Dependencies listed here are required to
         * be installed (and satisfied) by the <em>consumer</em> of this library. Using peer
         * dependencies allows you to ensure that only a single module of a certain
         * library exists in the <code>node_modules</code> tree of your consumers.
         * <p>
         * Note that prior to npm&#64;7, peer dependencies are <em>not</em> automatically
         * installed, which means that adding peer dependencies to a library will be a
         * breaking change for your customers.
         * <p>
         * Unless <code>peerDependencyOptions.pinnedDevDependency</code> is disabled (it is
         * enabled by default), projen will automatically add a dev dependency with a
         * pinned version for each peer dependency. This will ensure that you build &amp;
         * test your module against the lowest peer version required.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param peerDeps Peer dependencies for this module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder peerDeps(final java.util.List<java.lang.String> peerDeps) {
            this.options.peerDeps(peerDeps);
            return this;
        }

        /**
         * (experimental) The repository is the location where the actual code for your package lives.
         * <p>
         * See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository
         * <p>
         * @return {@code this}
         * @param repository The repository is the location where the actual code for your package lives. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(final java.lang.String repository) {
            this.options.repository(repository);
            return this;
        }

        /**
         * (experimental) If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.
         * <p>
         * @return {@code this}
         * @param repositoryDirectory If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryDirectory(final java.lang.String repositoryDirectory) {
            this.options.repositoryDirectory(repositoryDirectory);
            return this;
        }

        /**
         * (experimental) npm scripts to include.
         * <p>
         * If a script has the same name as a standard script,
         * the standard script will be overwritten.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param scripts npm scripts to include. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scripts(final java.util.Map<java.lang.String, java.lang.String> scripts) {
            this.options.scripts(scripts);
            return this;
        }

        /**
         * (experimental) Package's Stability.
         * <p>
         * @return {@code this}
         * @param stability Package's Stability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stability(final java.lang.String stability) {
            this.options.stability(stability);
            return this;
        }

        /**
         * (experimental) Checks that after build there are no modified files on git.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param antitamper Checks that after build there are no modified files on git. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder antitamper(final java.lang.Boolean antitamper) {
            this.options.antitamper(antitamper);
            return this;
        }

        /**
         * (experimental) A directory which will contain artifacts to be published to npm.
         * <p>
         * Default: "dist"
         * <p>
         * @return {@code this}
         * @param artifactsDirectory A directory which will contain artifacts to be published to npm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactsDirectory(final java.lang.String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        /**
         * (experimental) Version requirement of `jsii-release` which is used to publish modules to npm.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param jsiiReleaseVersion Version requirement of `jsii-release` which is used to publish modules to npm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jsiiReleaseVersion(final java.lang.String jsiiReleaseVersion) {
            this.options.jsiiReleaseVersion(jsiiReleaseVersion);
            return this;
        }

        /**
         * (experimental) Major version to release from the default branch.
         * <p>
         * If this is specified, we bump the latest version of this major version line.
         * If not specified, we bump the global latest version.
         * <p>
         * Default: - Major version is not enforced.
         * <p>
         * @return {@code this}
         * @param majorVersion Major version to release from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(final java.lang.Number majorVersion) {
            this.options.majorVersion(majorVersion);
            return this;
        }

        /**
         * (experimental) The npmDistTag to use when publishing from the default branch.
         * <p>
         * To set the npm dist-tag for release branches, set the <code>npmDistTag</code> property
         * for each branch.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param npmDistTag The npmDistTag to use when publishing from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmDistTag(final java.lang.String npmDistTag) {
            this.options.npmDistTag(npmDistTag);
            return this;
        }

        /**
         * (experimental) Steps to execute after build as part of the release workflow.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param postBuildSteps Steps to execute after build as part of the release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder postBuildSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        /**
         * (experimental) Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
         * <p>
         * Default: - normal semantic versions
         * <p>
         * @return {@code this}
         * @param prerelease Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prerelease(final java.lang.String prerelease) {
            this.options.prerelease(prerelease);
            return this;
        }

        /**
         * (experimental) Define publishing tasks that can be executed manually as well as workflows.
         * <p>
         * Normally, publishing only happens within automated workflows. Enable this
         * in order to create a publishing task for each publishing activity.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publishTasks Define publishing tasks that can be executed manually as well as workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTasks(final java.lang.Boolean publishTasks) {
            this.options.publishTasks(publishTasks);
            return this;
        }

        /**
         * (experimental) Defines additional release branches.
         * <p>
         * A workflow will be created for each
         * release branch which will publish releases from commits in this branch.
         * Each release branch <em>must</em> be assigned a major version number which is used
         * to enforce that versions published from that branch always use that major
         * version. If multiple branches are used, the <code>majorVersion</code> field must also
         * be provided for the default branch.
         * <p>
         * Default: - no additional branches are used for release. you can use
         * `addBranch()` to add additional branches.
         * <p>
         * @return {@code this}
         * @param releaseBranches Defines additional release branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseBranches(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.release.BranchOptions> releaseBranches) {
            this.options.releaseBranches(releaseBranches);
            return this;
        }

        /**
         * (deprecated) Automatically release new versions every commit to one of branches in `releaseBranches`.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.continuous()` instead
         * @param releaseEveryCommit Automatically release new versions every commit to one of branches in `releaseBranches`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseEveryCommit(final java.lang.Boolean releaseEveryCommit) {
            this.options.releaseEveryCommit(releaseEveryCommit);
            return this;
        }

        /**
         * (experimental) Create a github issue on every failed publishing task.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param releaseFailureIssue Create a github issue on every failed publishing task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssue(final java.lang.Boolean releaseFailureIssue) {
            this.options.releaseFailureIssue(releaseFailureIssue);
            return this;
        }

        /**
         * (experimental) The label to apply to issues indicating publish failures.
         * <p>
         * Only applies if <code>releaseFailureIssue</code> is true.
         * <p>
         * Default: "failed-release"
         * <p>
         * @return {@code this}
         * @param releaseFailureIssueLabel The label to apply to issues indicating publish failures. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssueLabel(final java.lang.String releaseFailureIssueLabel) {
            this.options.releaseFailureIssueLabel(releaseFailureIssueLabel);
            return this;
        }

        /**
         * (deprecated) CRON schedule to trigger new releases.
         * <p>
         * Default: - no scheduled releases
         * <p>
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.scheduled()` instead
         * @param releaseSchedule CRON schedule to trigger new releases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseSchedule(final java.lang.String releaseSchedule) {
            this.options.releaseSchedule(releaseSchedule);
            return this;
        }

        /**
         * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
         * <p>
         * Note: this prefix is used to detect the latest tagged version
         * when bumping, so if you change this on a project with an existing version
         * history, you may need to manually tag your latest release
         * with the new prefix.
         * <p>
         * Default: - no prefix
         * <p>
         * @return {@code this}
         * @param releaseTagPrefix Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagPrefix(final java.lang.String releaseTagPrefix) {
            this.options.releaseTagPrefix(releaseTagPrefix);
            return this;
        }

        /**
         * (experimental) The release trigger to use.
         * <p>
         * Default: - Continuous releases (`ReleaseTrigger.continuous()`)
         * <p>
         * @return {@code this}
         * @param releaseTrigger The release trigger to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTrigger(final io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger) {
            this.options.releaseTrigger(releaseTrigger);
            return this;
        }

        /**
         * (experimental) The name of the default release workflow.
         * <p>
         * Default: "Release"
         * <p>
         * @return {@code this}
         * @param releaseWorkflowName The name of the default release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowName(final java.lang.String releaseWorkflowName) {
            this.options.releaseWorkflowName(releaseWorkflowName);
            return this;
        }

        /**
         * (experimental) A set of workflow steps to execute in order to setup the workflow container.
         * <p>
         * @return {@code this}
         * @param releaseWorkflowSetupSteps A set of workflow steps to execute in order to setup the workflow container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowSetupSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps) {
            this.options.releaseWorkflowSetupSteps(releaseWorkflowSetupSteps);
            return this;
        }

        /**
         * (experimental) Custom configuration used when creating changelog with standard-version package.
         * <p>
         * Given values either append to default configuration or overwrite values in it.
         * <p>
         * Default: - standard configuration applicable for GitHub repositories
         * <p>
         * @return {@code this}
         * @param versionrcOptions Custom configuration used when creating changelog with standard-version package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionrcOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> versionrcOptions) {
            this.options.versionrcOptions(versionrcOptions);
            return this;
        }

        /**
         * (experimental) Container image to use for GitHub workflows.
         * <p>
         * Default: - default image
         * <p>
         * @return {@code this}
         * @param workflowContainerImage Container image to use for GitHub workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowContainerImage(final java.lang.String workflowContainerImage) {
            this.options.workflowContainerImage(workflowContainerImage);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param workflowRunsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOn(final java.util.List<java.lang.String> workflowRunsOn) {
            this.options.workflowRunsOn(workflowRunsOn);
            return this;
        }

        /**
         * (experimental) The name of the main release branch.
         * <p>
         * Default: "main"
         * <p>
         * @return {@code this}
         * @param defaultReleaseBranch The name of the main release branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultReleaseBranch(final java.lang.String defaultReleaseBranch) {
            this.options.defaultReleaseBranch(defaultReleaseBranch);
            return this;
        }

        /**
         * (experimental) Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued).
         * <p>
         * Throw if set to true but <code>autoApproveOptions</code> are not defined.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param autoApproveProjenUpgrades Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoApproveProjenUpgrades(final java.lang.Boolean autoApproveProjenUpgrades) {
            this.options.autoApproveProjenUpgrades(autoApproveProjenUpgrades);
            return this;
        }

        /**
         * (experimental) Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).
         * <p>
         * Throw if set to true but <code>autoApproveOptions</code> are not defined.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param autoApproveUpgrades Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoApproveUpgrades(final java.lang.Boolean autoApproveUpgrades) {
            this.options.autoApproveUpgrades(autoApproveUpgrades);
            return this;
        }

        /**
         * (experimental) Define a GitHub workflow for building PRs.
         * <p>
         * Default: - true if not a subproject
         * <p>
         * @return {@code this}
         * @param buildWorkflow Define a GitHub workflow for building PRs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildWorkflow(final java.lang.Boolean buildWorkflow) {
            this.options.buildWorkflow(buildWorkflow);
            return this;
        }

        /**
         * (experimental) Options for `Bundler`.
         * <p>
         * @return {@code this}
         * @param bundlerOptions Options for `Bundler`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundlerOptions(final io.github.cdklabs.projen.javascript.BundlerOptions bundlerOptions) {
            this.options.bundlerOptions(bundlerOptions);
            return this;
        }

        /**
         * (experimental) Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v1 A secret is required for private repos. Configured with @codeCovTokenSecret.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param codeCov Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v1 A secret is required for private repos. Configured with @codeCovTokenSecret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeCov(final java.lang.Boolean codeCov) {
            this.options.codeCov(codeCov);
            return this;
        }

        /**
         * (experimental) Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.
         * <p>
         * Default: - if this option is not specified, only public repositories are supported
         * <p>
         * @return {@code this}
         * @param codeCovTokenSecret Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeCovTokenSecret(final java.lang.String codeCovTokenSecret) {
            this.options.codeCovTokenSecret(codeCovTokenSecret);
            return this;
        }

        /**
         * (experimental) License copyright owner.
         * <p>
         * Default: - defaults to the value of authorName or "" if `authorName` is undefined.
         * <p>
         * @return {@code this}
         * @param copyrightOwner License copyright owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder copyrightOwner(final java.lang.String copyrightOwner) {
            this.options.copyrightOwner(copyrightOwner);
            return this;
        }

        /**
         * (experimental) The copyright years to put in the LICENSE file.
         * <p>
         * Default: - current year
         * <p>
         * @return {@code this}
         * @param copyrightPeriod The copyright years to put in the LICENSE file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder copyrightPeriod(final java.lang.String copyrightPeriod) {
            this.options.copyrightPeriod(copyrightPeriod);
            return this;
        }

        /**
         * (experimental) Use dependabot to handle dependency upgrades.
         * <p>
         * Cannot be used in conjunction with <code>depsUpgrade</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dependabot Use dependabot to handle dependency upgrades. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependabot(final java.lang.Boolean dependabot) {
            this.options.dependabot(dependabot);
            return this;
        }

        /**
         * (experimental) Options for dependabot.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param dependabotOptions Options for dependabot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependabotOptions(final io.github.cdklabs.projen.github.DependabotOptions dependabotOptions) {
            this.options.dependabotOptions(dependabotOptions);
            return this;
        }

        /**
         * (experimental) Use github workflows to handle dependency upgrades.
         * <p>
         * Cannot be used in conjunction with <code>dependabot</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param depsUpgrade Use github workflows to handle dependency upgrades. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder depsUpgrade(final java.lang.Boolean depsUpgrade) {
            this.options.depsUpgrade(depsUpgrade);
            return this;
        }

        /**
         * (experimental) Options for depsUpgrade.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param depsUpgradeOptions Options for depsUpgrade. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder depsUpgradeOptions(final io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions depsUpgradeOptions) {
            this.options.depsUpgradeOptions(depsUpgradeOptions);
            return this;
        }

        /**
         * (experimental) Additional entries to .gitignore.
         * <p>
         * @return {@code this}
         * @param gitignore Additional entries to .gitignore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitignore(final java.util.List<java.lang.String> gitignore) {
            this.options.gitignore(gitignore);
            return this;
        }

        /**
         * (experimental) Setup jest unit tests.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param jest Setup jest unit tests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jest(final java.lang.Boolean jest) {
            this.options.jest(jest);
            return this;
        }

        /**
         * (experimental) Jest options.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param jestOptions Jest options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jestOptions(final io.github.cdklabs.projen.javascript.JestOptions jestOptions) {
            this.options.jestOptions(jestOptions);
            return this;
        }

        /**
         * (experimental) Automatically update files modified during builds to pull-request branches.
         * <p>
         * This means
         * that any files synthesized by projen or e.g. test snapshots will always be up-to-date
         * before a PR is merged.
         * <p>
         * Implies that PR builds do not have anti-tamper checks.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param mutableBuild Automatically update files modified during builds to pull-request branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutableBuild(final java.lang.Boolean mutableBuild) {
            this.options.mutableBuild(mutableBuild);
            return this;
        }

        /**
         * (deprecated) Additional entries to .npmignore.
         * <p>
         * @return {@code this}
         * @deprecated - use `project.addPackageIgnore`
         * @param npmignore Additional entries to .npmignore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder npmignore(final java.util.List<java.lang.String> npmignore) {
            this.options.npmignore(npmignore);
            return this;
        }

        /**
         * (experimental) Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param npmignoreEnabled Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmignoreEnabled(final java.lang.Boolean npmignoreEnabled) {
            this.options.npmignoreEnabled(npmignoreEnabled);
            return this;
        }

        /**
         * (experimental) Indicates of "projen" should be installed as a devDependency.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param projenDevDependency Indicates of "projen" should be installed as a devDependency. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenDevDependency(final java.lang.Boolean projenDevDependency) {
            this.options.projenDevDependency(projenDevDependency);
            return this;
        }

        /**
         * (experimental) Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.
         * <p>
         * Default: - true if projenrcJson is false
         * <p>
         * @return {@code this}
         * @param projenrcJs Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJs(final java.lang.Boolean projenrcJs) {
            this.options.projenrcJs(projenrcJs);
            return this;
        }

        /**
         * (experimental) Options for .projenrc.js.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param projenrcJsOptions Options for .projenrc.js. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJsOptions(final io.github.cdklabs.projen.javascript.ProjenrcOptions projenrcJsOptions) {
            this.options.projenrcJsOptions(projenrcJsOptions);
            return this;
        }

        /**
         * (deprecated) Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued).
         * <p>
         * Throw if set to true but <code>autoApproveOptions</code> are not defined.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @deprecated use `autoApproveProjenUpgrades`.
         * @param projenUpgradeAutoMerge Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder projenUpgradeAutoMerge(final java.lang.Boolean projenUpgradeAutoMerge) {
            this.options.projenUpgradeAutoMerge(projenUpgradeAutoMerge);
            return this;
        }

        /**
         * (experimental) Customize the projenUpgrade schedule in cron expression.
         * <p>
         * Default: [ "0 6 * * *" ]
         * <p>
         * @return {@code this}
         * @param projenUpgradeSchedule Customize the projenUpgrade schedule in cron expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenUpgradeSchedule(final java.util.List<java.lang.String> projenUpgradeSchedule) {
            this.options.projenUpgradeSchedule(projenUpgradeSchedule);
            return this;
        }

        /**
         * (experimental) Periodically submits a pull request for projen upgrades (executes `yarn projen:upgrade`).
         * <p>
         * This setting is a GitHub secret name which contains a GitHub Access Token
         * with <code>repo</code> and <code>workflow</code> permissions.
         * <p>
         * This token is used to submit the upgrade pull request, which will likely
         * include workflow updates.
         * <p>
         * To create a personal access token see https://github.com/settings/tokens
         * <p>
         * Default: - no automatic projen upgrade pull requests
         * <p>
         * @return {@code this}
         * @param projenUpgradeSecret Periodically submits a pull request for projen upgrades (executes `yarn projen:upgrade`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenUpgradeSecret(final java.lang.String projenUpgradeSecret) {
            this.options.projenUpgradeSecret(projenUpgradeSecret);
            return this;
        }

        /**
         * (experimental) Version of projen to install.
         * <p>
         * Default: - Defaults to the latest version.
         * <p>
         * @return {@code this}
         * @param projenVersion Version of projen to install. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenVersion(final java.lang.String projenVersion) {
            this.options.projenVersion(projenVersion);
            return this;
        }

        /**
         * (experimental) Include a GitHub pull request template.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param pullRequestTemplate Include a GitHub pull request template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestTemplate(final java.lang.Boolean pullRequestTemplate) {
            this.options.pullRequestTemplate(pullRequestTemplate);
            return this;
        }

        /**
         * (experimental) The contents of the pull request template.
         * <p>
         * Default: - default content
         * <p>
         * @return {@code this}
         * @param pullRequestTemplateContents The contents of the pull request template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestTemplateContents(final java.util.List<java.lang.String> pullRequestTemplateContents) {
            this.options.pullRequestTemplateContents(pullRequestTemplateContents);
            return this;
        }

        /**
         * (experimental) Add release management to this project.
         * <p>
         * Default: - true (false for subprojects)
         * <p>
         * @return {@code this}
         * @param release Add release management to this project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder release(final java.lang.Boolean release) {
            this.options.release(release);
            return this;
        }

        /**
         * (experimental) Automatically release to npm when new versions are introduced.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param releaseToNpm Automatically release to npm when new versions are introduced. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseToNpm(final java.lang.Boolean releaseToNpm) {
            this.options.releaseToNpm(releaseToNpm);
            return this;
        }

        /**
         * (deprecated) DEPRECATED: renamed to `release`.
         * <p>
         * Default: - true if not a subproject
         * <p>
         * @return {@code this}
         * @deprecated see `release`.
         * @param releaseWorkflow DEPRECATED: renamed to `release`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseWorkflow(final java.lang.Boolean releaseWorkflow) {
            this.options.releaseWorkflow(releaseWorkflow);
            return this;
        }

        /**
         * (experimental) Workflow steps to use in order to bootstrap this repo.
         * <p>
         * Default: "yarn install --frozen-lockfile && yarn projen"
         * <p>
         * @return {@code this}
         * @param workflowBootstrapSteps Workflow steps to use in order to bootstrap this repo. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowBootstrapSteps(final java.util.List<? extends java.lang.Object> workflowBootstrapSteps) {
            this.options.workflowBootstrapSteps(workflowBootstrapSteps);
            return this;
        }

        /**
         * (experimental) The git identity to use in workflows.
         * <p>
         * Default: - GitHub Actions
         * <p>
         * @return {@code this}
         * @param workflowGitIdentity The git identity to use in workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowGitIdentity(final io.github.cdklabs.projen.github.GitIdentity workflowGitIdentity) {
            this.options.workflowGitIdentity(workflowGitIdentity);
            return this;
        }

        /**
         * (experimental) The node version to use in GitHub workflows.
         * <p>
         * Default: - same as `minNodeVersion`
         * <p>
         * @return {@code this}
         * @param workflowNodeVersion The node version to use in GitHub workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowNodeVersion(final java.lang.String workflowNodeVersion) {
            this.options.workflowNodeVersion(workflowNodeVersion);
            return this;
        }

        /**
         * (experimental) Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableTsconfig Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableTsconfig(final java.lang.Boolean disableTsconfig) {
            this.options.disableTsconfig(disableTsconfig);
            return this;
        }

        /**
         * (experimental) Docgen by Typedoc.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param docgen Docgen by Typedoc. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder docgen(final java.lang.Boolean docgen) {
            this.options.docgen(docgen);
            return this;
        }

        /**
         * (experimental) Docs directory.
         * <p>
         * Default: "docs"
         * <p>
         * @return {@code this}
         * @param docsDirectory Docs directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder docsDirectory(final java.lang.String docsDirectory) {
            this.options.docsDirectory(docsDirectory);
            return this;
        }

        /**
         * (experimental) The .d.ts file that includes the type declarations for this module.
         * <p>
         * Default: - .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)
         * <p>
         * @return {@code this}
         * @param entrypointTypes The .d.ts file that includes the type declarations for this module. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypointTypes(final java.lang.String entrypointTypes) {
            this.options.entrypointTypes(entrypointTypes);
            return this;
        }

        /**
         * (experimental) Setup eslint.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param eslint Setup eslint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eslint(final java.lang.Boolean eslint) {
            this.options.eslint(eslint);
            return this;
        }

        /**
         * (experimental) Eslint options.
         * <p>
         * Default: - opinionated default options
         * <p>
         * @return {@code this}
         * @param eslintOptions Eslint options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eslintOptions(final io.github.cdklabs.projen.javascript.EslintOptions eslintOptions) {
            this.options.eslintOptions(eslintOptions);
            return this;
        }

        /**
         * (experimental) Typescript  artifacts output directory.
         * <p>
         * Default: "lib"
         * <p>
         * @return {@code this}
         * @param libdir Typescript  artifacts output directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder libdir(final java.lang.String libdir) {
            this.options.libdir(libdir);
            return this;
        }

        /**
         * (experimental) Defines a `yarn package` command that will produce a tarball and place it under `dist/js`.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param packageValue Defines a `yarn package` command that will produce a tarball and place it under `dist/js`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder packageValue(final java.lang.Boolean packageValue) {
            this.options.packageValue(packageValue);
            return this;
        }

        /**
         * (experimental) Use TypeScript for your projenrc file (`.projenrc.ts`).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param projenrcTs Use TypeScript for your projenrc file (`.projenrc.ts`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcTs(final java.lang.Boolean projenrcTs) {
            this.options.projenrcTs(projenrcTs);
            return this;
        }

        /**
         * (experimental) Options for .projenrc.ts.
         * <p>
         * @return {@code this}
         * @param projenrcTsOptions Options for .projenrc.ts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcTsOptions(final io.github.cdklabs.projen.typescript.ProjenrcOptions projenrcTsOptions) {
            this.options.projenrcTsOptions(projenrcTsOptions);
            return this;
        }

        /**
         * (experimental) Generate one-time sample in `src/` and `test/` if there are no files there.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param sampleCode Generate one-time sample in `src/` and `test/` if there are no files there. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sampleCode(final java.lang.Boolean sampleCode) {
            this.options.sampleCode(sampleCode);
            return this;
        }

        /**
         * (experimental) Typescript sources directory.
         * <p>
         * Default: "src"
         * <p>
         * @return {@code this}
         * @param srcdir Typescript sources directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder srcdir(final java.lang.String srcdir) {
            this.options.srcdir(srcdir);
            return this;
        }

        /**
         * (experimental) Jest tests directory. Tests files should be named `xxx.test.ts`.
         * <p>
         * If this directory is under <code>srcdir</code> (e.g. <code>src/test</code>, <code>src/__tests__</code>),
         * then tests are going to be compiled into <code>lib/</code> and executed as javascript.
         * If the test directory is outside of <code>src</code>, then we configure jest to
         * compile the code in-memory.
         * <p>
         * Default: "test"
         * <p>
         * @return {@code this}
         * @param testdir Jest tests directory. Tests files should be named `xxx.test.ts`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder testdir(final java.lang.String testdir) {
            this.options.testdir(testdir);
            return this;
        }

        /**
         * (experimental) Custom TSConfig.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param tsconfig Custom TSConfig. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tsconfig(final io.github.cdklabs.projen.javascript.TypescriptConfigOptions tsconfig) {
            this.options.tsconfig(tsconfig);
            return this;
        }

        /**
         * (experimental) Custom tsconfig options for the development tsconfig.json file (used for testing).
         * <p>
         * Default: - use the production tsconfig options
         * <p>
         * @return {@code this}
         * @param tsconfigDev Custom tsconfig options for the development tsconfig.json file (used for testing). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tsconfigDev(final io.github.cdklabs.projen.javascript.TypescriptConfigOptions tsconfigDev) {
            this.options.tsconfigDev(tsconfigDev);
            return this;
        }

        /**
         * (experimental) The name of the development tsconfig.json file.
         * <p>
         * Default: "tsconfig.dev.json"
         * <p>
         * @return {@code this}
         * @param tsconfigDevFile The name of the development tsconfig.json file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tsconfigDevFile(final java.lang.String tsconfigDevFile) {
            this.options.tsconfigDevFile(tsconfigDevFile);
            return this;
        }

        /**
         * (experimental) TypeScript version to use.
         * <p>
         * NOTE: Typescript is not semantically versioned and should remain on the
         * same minor, so we recommend using a <code>~</code> dependency (e.g. <code>~1.2.3</code>).
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param typescriptVersion TypeScript version to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder typescriptVersion(final java.lang.String typescriptVersion) {
            this.options.typescriptVersion(typescriptVersion);
            return this;
        }

        /**
         * (experimental) The name of the library author.
         * <p>
         * Default: $GIT_USER_NAME
         * <p>
         * @return {@code this}
         * @param author The name of the library author. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder author(final java.lang.String author) {
            this.options.author(author);
            return this;
        }

        /**
         * (experimental) Email or URL of the library author.
         * <p>
         * Default: $GIT_USER_EMAIL
         * <p>
         * @return {@code this}
         * @param authorAddress Email or URL of the library author. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorAddress(final java.lang.String authorAddress) {
            this.options.authorAddress(authorAddress);
            return this;
        }

        /**
         * (experimental) Git repository URL.
         * <p>
         * Default: $GIT_REMOTE
         * <p>
         * @return {@code this}
         * @param repositoryUrl Git repository URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryUrl(final java.lang.String repositoryUrl) {
            this.options.repositoryUrl(repositoryUrl);
            return this;
        }

        /**
         * (experimental) Automatically run API compatibility test against the latest version published to npm after compilation.
         * <p>
         * <ul>
         * <li>You can manually run compatibility tests using <code>yarn compat</code> if this feature is disabled.</li>
         * <li>You can ignore compatibility failures by adding lines to a ".compatignore" file.</li>
         * </ul>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param compat Automatically run API compatibility test against the latest version published to npm after compilation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compat(final java.lang.Boolean compat) {
            this.options.compat(compat);
            return this;
        }

        /**
         * (experimental) Name of the ignore file for API compatibility tests.
         * <p>
         * Default: ".compatignore"
         * <p>
         * @return {@code this}
         * @param compatIgnore Name of the ignore file for API compatibility tests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compatIgnore(final java.lang.String compatIgnore) {
            this.options.compatIgnore(compatIgnore);
            return this;
        }

        /**
         * @return {@code this}
         * @deprecated use `publishToNuget`
         * @param dotnet This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder dotnet(final io.github.cdklabs.projen.cdk.JsiiDotNetTarget dotnet) {
            this.options.dotnet(dotnet);
            return this;
        }

        /**
         * (experimental) Accepts a list of glob patterns.
         * <p>
         * Files matching any of those patterns will be excluded from the TypeScript compiler input.
         * <p>
         * By default, jsii will include all *.ts files (except .d.ts files) in the TypeScript compiler input.
         * This can be problematic for example when the package's build or test procedure generates .ts files
         * that cannot be compiled with jsii's compiler settings.
         * <p>
         * @return {@code this}
         * @param excludeTypescript Accepts a list of glob patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder excludeTypescript(final java.util.List<java.lang.String> excludeTypescript) {
            this.options.excludeTypescript(excludeTypescript);
            return this;
        }

        /**
         * (experimental) Publish Go bindings to a git repository.
         * <p>
         * Default: - no publishing
         * <p>
         * @return {@code this}
         * @param publishToGo Publish Go bindings to a git repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishToGo(final io.github.cdklabs.projen.cdk.JsiiGoTarget publishToGo) {
            this.options.publishToGo(publishToGo);
            return this;
        }

        /**
         * (experimental) Publish to maven.
         * <p>
         * Default: - no publishing
         * <p>
         * @return {@code this}
         * @param publishToMaven Publish to maven. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishToMaven(final io.github.cdklabs.projen.cdk.JsiiJavaTarget publishToMaven) {
            this.options.publishToMaven(publishToMaven);
            return this;
        }

        /**
         * (experimental) Publish to NuGet.
         * <p>
         * Default: - no publishing
         * <p>
         * @return {@code this}
         * @param publishToNuget Publish to NuGet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishToNuget(final io.github.cdklabs.projen.cdk.JsiiDotNetTarget publishToNuget) {
            this.options.publishToNuget(publishToNuget);
            return this;
        }

        /**
         * (experimental) Publish to pypi.
         * <p>
         * Default: - no publishing
         * <p>
         * @return {@code this}
         * @param publishToPypi Publish to pypi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishToPypi(final io.github.cdklabs.projen.cdk.JsiiPythonTarget publishToPypi) {
            this.options.publishToPypi(publishToPypi);
            return this;
        }

        /**
         * @return {@code this}
         * @deprecated use `publishToPyPi`
         * @param python This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder python(final io.github.cdklabs.projen.cdk.JsiiPythonTarget python) {
            this.options.python(python);
            return this;
        }

        /**
         * Default: "."
         * <p>
         * @return {@code this}
         * @param rootdir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rootdir(final java.lang.String rootdir) {
            this.options.rootdir(rootdir);
            return this;
        }

        /**
         * (experimental) Libraries will be picked up by the construct catalog when they are published to npm as jsii modules and will be published under:.
         * <p>
         * https://awscdk.io/packages/[&#64;SCOPE/]PACKAGE&#64;VERSION
         * <p>
         * The catalog will also post a tweet to https://twitter.com/awscdkio with the
         * package name, description and the above link. You can disable these tweets
         * through <code>{ announce: false }</code>.
         * <p>
         * You can also add a Twitter handle through <code>{ twitter: 'xx' }</code> which will be
         * mentioned in the tweet.
         * <p>
         * Default: - new version will be announced
         * <p>
         * @return {@code this}
         * @see https://github.com/construct-catalog/catalog
         * @param catalog Libraries will be picked up by the construct catalog when they are published to npm as jsii modules and will be published under:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder catalog(final io.github.cdklabs.projen.cdk.Catalog catalog) {
            this.options.catalog(catalog);
            return this;
        }

        /**
         * (experimental) Minimum target version this library is tested against.
         * <p>
         * Default: "0.4.0"
         * <p>
         * @return {@code this}
         * @param cdktfVersion Minimum target version this library is tested against. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdktfVersion(final java.lang.String cdktfVersion) {
            this.options.cdktfVersion(cdktfVersion);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.cdktf.ConstructLibraryCdktf}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.cdktf.ConstructLibraryCdktf build() {
            return new io.github.cdklabs.projen.cdktf.ConstructLibraryCdktf(
                this.options.build()
            );
        }
    }
}
