package io.github.cdklabs.projen.github;

/**
 * (experimental) Sets up mergify to merging approved pull requests.
 * <p>
 * If <code>buildJob</code> is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 * <p>
 * <code>approvedReviews</code> specified the number of code review approvals required for
 * the PR to be merged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.755Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.AutoMerge")
public class AutoMerge extends io.github.cdklabs.projen.Component {

    protected AutoMerge(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoMerge(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param github This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AutoMerge(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.AutoMergeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.github.AutoMerge}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.github.AutoMerge> {
        /**
         * @return a new instance of {@link Builder}.
         * @param github This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.github.GitHub github) {
            return new Builder(github);
        }

        private final io.github.cdklabs.projen.github.GitHub github;
        private final io.github.cdklabs.projen.github.AutoMergeOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.github.GitHub github) {
            this.github = github;
            this.options = new io.github.cdklabs.projen.github.AutoMergeOptions.Builder();
        }

        /**
         * (experimental) Number of approved code reviews.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param approvedReviews Number of approved code reviews. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder approvedReviews(final java.lang.Number approvedReviews) {
            this.options.approvedReviews(approvedReviews);
            return this;
        }

        /**
         * (experimental) List of labels that will prevent auto-merging.
         * <p>
         * Default: ['do-not-merge']
         * <p>
         * @return {@code this}
         * @param blockingLabels List of labels that will prevent auto-merging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder blockingLabels(final java.util.List<java.lang.String> blockingLabels) {
            this.options.blockingLabels(blockingLabels);
            return this;
        }

        /**
         * (experimental) The GitHub job ID of the build workflow.
         * <p>
         * @return {@code this}
         * @param buildJob The GitHub job ID of the build workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildJob(final java.lang.String buildJob) {
            this.options.buildJob(buildJob);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.github.AutoMerge}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.github.AutoMerge build() {
            return new io.github.cdklabs.projen.github.AutoMerge(
                this.github,
                this.options.build()
            );
        }
    }
}
