package io.github.cdklabs.projen.github;

/**
 * (experimental) Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 * <p>
 * The default configuration will:
 * <p>
 * <ul>
 * <li>Add a "Stale" label to pull requests after 14 days and closed after 2 days</li>
 * <li>Add a "Stale" label to issues after 60 days and closed after 7 days</li>
 * <li>If a comment is added, the label will be removed and timer is restarted.</li>
 * </ul>
 * <p>
 * @see https://github.com/actions/stale
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.771Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.Stale")
public class Stale extends io.github.cdklabs.projen.Component {

    protected Stale(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stale(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param github This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Stale(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.StaleOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required"), options });
    }

    /**
     * @param github This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Stale(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.github.Stale}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.github.Stale> {
        /**
         * @return a new instance of {@link Builder}.
         * @param github This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.github.GitHub github) {
            return new Builder(github);
        }

        private final io.github.cdklabs.projen.github.GitHub github;
        private io.github.cdklabs.projen.github.StaleOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.github.GitHub github) {
            this.github = github;
        }

        /**
         * (experimental) How to handle stale issues.
         * <p>
         * Default: - By default, stale issues with no activity will be marked as
         * stale after 60 days and closed within 7 days.
         * <p>
         * @return {@code this}
         * @param issues How to handle stale issues. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder issues(final io.github.cdklabs.projen.github.StaleBehavior issues) {
            this.options().issues(issues);
            return this;
        }

        /**
         * (experimental) How to handle stale pull requests.
         * <p>
         * Default: - By default, pull requests with no activity will be marked as
         * stale after 14 days and closed within 2 days with relevant comments.
         * <p>
         * @return {@code this}
         * @param pullRequest How to handle stale pull requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequest(final io.github.cdklabs.projen.github.StaleBehavior pullRequest) {
            this.options().pullRequest(pullRequest);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param runsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOn(final java.util.List<java.lang.String> runsOn) {
            this.options().runsOn(runsOn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.github.Stale}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.github.Stale build() {
            return new io.github.cdklabs.projen.github.Stale(
                this.github,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.github.StaleOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.github.StaleOptions.Builder();
            }
            return this.options;
        }
    }
}
