/**
 * <h1>projen</h1>
 * <p>
 * <img alt="projen logo" src="./logo/projen.svg">
 * <p>
 * <a href="https://opensource.org/licenses/Apache-2.0"><img alt="License" src="https://img.shields.io/badge/License-Apache%202.0-yellowgreen.svg"></a>
 * <a href="https://gitpod.io/#https://github.com/projen/projen"><img alt="Gitpod ready-to-code" src="https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod"></a>
 * <img alt="Build" src="https://github.com/projen/projen/workflows/Build/badge.svg">
 * <img alt="Release" src="https://github.com/projen/projen/workflows/Release/badge.svg">
 * <img alt="Commit activity" src="https://img.shields.io/github/commit-activity/w/projen/projen">
 * <p>
 * <!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
 * <p>
 * <a href="#contributors-"><img alt="All Contributors" src="https://img.shields.io/badge/all_contributors-63-orange.svg?style=flat-square"></a>
 * <p>
 * <!-- ALL-CONTRIBUTORS-BADGE:END -->
 * <p>
 * Define and maintain complex project configuration through code.
 * <p>
 * <blockquote>
 * <p>
 * JOIN THE <a href="https://twitter.com/search?q=%23TemplatesAreEvil">#TemplatesAreEvil</a> MOVEMENT!
 * <p>
 * </blockquote>
 * <p>
 * <em>projen</em> synthesizes project configuration files such as <code>package.json</code>,
 * <code>tsconfig.json</code>, <code>.gitignore</code>, GitHub Workflows, eslint, jest, etc from a
 * well-typed definition written in JavaScript.
 * <p>
 * Check out <a href="https://youtu.be/SOWMPzXtTCw">this talk</a> about projen.
 * <p>
 * As opposed to existing templating/scaffolding tools, <em>projen</em> is not a one-off
 * generator. Synthesized files should never be manually edited (in fact, projen
 * enforces that). To modify your project setup, users interact with rich
 * strongly-typed class and execute <code>projen</code> to update their project configuration
 * files.
 * <p>
 * <h2>Getting Started</h2>
 * <p>
 * To create a new project, run the following command and follow the instructions:
 * <p>
 * <blockquote><pre>
 * $ mkdir my-project
 * $ cd my-project
 * $ git init
 * $ npx projen new PROJECT-TYPE
 * 🤖 Synthesizing project...
 * ...
 * </pre></blockquote>
 * <p>
 * Currently supported project types (use <code>npx projen new</code> without a type for a
 * list):
 * <p>
 * <!-- <macro exec="node ./scripts/readme-projects.js"> -->
 * <p>
 * <ul>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-awscdk-awscdkjavaapp">awscdk-app-java</a> - AWS CDK app in Java.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-awscdk-awscdktypescriptapp">awscdk-app-ts</a> - AWS CDK app in TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-awscdk-awscdkconstructlibrary">awscdk-construct</a> - AWS CDK construct library project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-cdk8s-cdk8stypescriptapp">cdk8s-app-ts</a> - CDK8s app in TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-cdk8s-constructlibrarycdk8s">cdk8s-construct</a> - CDK8s construct library project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-cdktf-constructlibrarycdktf">cdktf-construct</a> - CDKTF construct library project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-java-javaproject">java</a> - Java project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-cdk-jsiiproject">jsii</a> - Multi-language jsii library project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-web-nextjsproject">nextjs</a> - Next.js project without TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-web-nextjstypescriptproject">nextjs-ts</a> - Next.js project with TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-javascript-nodeproject">node</a> - Node.js project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-project">project</a> - Base project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-python-pythonproject">python</a> - Python project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-web-reactproject">react</a> - React project without TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-web-reacttypescriptproject">react-ts</a> - React project with TypeScript.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-typescript-typescriptproject">typescript</a> - TypeScript project.</li>
 * <li><a href="https://github.com/projen/projen/blob/main/API.md#projen-typescript-typescriptappproject">typescript-app</a> - TypeScript app.</li>
 * </ul>
 * <p>
 * <!-- </macro> --><blockquote>
 * <p>
 * Use <code>npx projen new PROJECT-TYPE --help</code> to view a list of command line
 * switches that allows you to specify most project options during bootstrapping.
 * For example: <code>npx projen new jsii --author-name "Jerry Berry"</code>.
 * <p>
 * </blockquote>
 * <p>
 * The <code>new</code> command will create a <code>.projenrc.js</code> file which looks like this for
 * <code>jsii</code> projects:
 * <p>
 * <blockquote><pre>
 * const { JsiiProject } = require('projen');
 * 
 * const project = new JsiiProject({
 *   authorAddress: "elad.benisrael&#64;gmail.com",
 *   authorName: "Elad Ben-Israel",
 *   name: "foobar",
 *   repository: "https://github.com/eladn/foobar.git",
 * });
 * 
 * project.synth();
 * </pre></blockquote>
 * <p>
 * This program instantiates the project type with minimal setup, and then calls
 * <code>synth()</code> to synthesize the project files. By default, the <code>new</code> command will
 * also execute this program, which will result in a fully working project.
 * <p>
 * Once your project is created, you can configure your project by editing
 * <code>.projenrc.js</code> and re-running <code>npx projen</code> to synthesize again.
 * <p>
 * <blockquote>
 * <p>
 * The files generated by <em>projen</em> are considered an "implementation detail" and
 * <em>projen</em> protects them from being manually edited (most files are marked
 * read-only, and an "anti tamper" check is configured in the CI build workflow
 * to ensure that files are not updated during build).
 * <p>
 * </blockquote>
 * <p>
 * For example, to setup PyPI publishing in <code>jsii</code> projects, you can use
 * <a href="https://github.com/eladb/projen/blob/master/API.md#projen-jsiipythontarget"><code>python option</code></a>:
 * <p>
 * <blockquote><pre>
 * const project = new JsiiProject({
 *   // ...
 *   python: {
 *     distName: "mydist",
 *     module: "my_module",
 *   }
 * });
 * </pre></blockquote>
 * <p>
 * Run:
 * <p>
 * <blockquote><pre>
 * npx projen
 * </pre></blockquote>
 * <p>
 * And you'll notice that your <code>package.json</code> file now contains a <code>python</code> section in
 * it's <code>jsii</code> config and the GitHub <code>release.yml</code> workflow includes a PyPI
 * publishing step.
 * <p>
 * We recommend to put this in your shell profile, so you can simply run <code>pj</code> every
 * time you update <code>.projenrc.js</code>:
 * <p>
 * <blockquote><pre>
 * alias pj='npx projen'
 * </pre></blockquote>
 * <p>
 * Most projects come with an assortment of <strong>tasks</strong> that handle various
 * development activities, from compiling to publishing. Tasks can be and composed
 * together, and can be run as local commands or turned into GitHub workflows. You
 * can list all tasks with <code>npx projen --help</code>:
 * <p>
 * <blockquote><pre>
 * $ npx projen --help
 * projen [command]
 * 
 * Commands:
 *   projen new [PROJECT-TYPE-NAME] [OPTIONS]  Creates a new projen project
 *   projen clobber                            hard resets to HEAD of origin and cleans the local repo
 *   projen compile                            Only compile
 *   projen test:compile                       compiles the test code
 *   projen test                               Run tests
 *   projen build                              Full release build (test+compile)
 *   projen upgrade-dependencies               upgrade dependencies
 *   projen upgrade-projen                     upgrade projen
 * ...
 * </pre></blockquote>
 * <p>
 * The <code>build</code> task is the same task that's executed in your CI builds. It
 * typically compiles, lints, tests and packages your module for distribution.
 * <p>
 * <h3>Shell Completions</h3>
 * <p>
 * If installed as a global package, <code>projen</code> includes rich shell tab-completion support. To enable this in your shell, run:
 * <p>
 * <blockquote><pre>
 * # Bash
 * projen completion &gt;&gt; ~/.bashrc
 * 
 * # ZSH
 * projen completion &gt;&gt; ~/.zshrc
 * </pre></blockquote>
 * <p>
 * <h2>Features</h2>
 * <p>
 * Some examples for features built-in to project types:
 * <p>
 * <ul>
 * <li>Fully synthesize <code>package.json</code></li>
 * <li>Standard npm scripts like <code>compile</code>, <code>build</code>, <code>test</code>, <code>package</code></li>
 * <li>eslint</li>
 * <li>Jest</li>
 * <li>jsii: compile, package, api compatibility checks, API.md</li>
 * <li>Bump &amp; release scripts with CHANGELOG generation based on conventional commits (manual releases are currently broken! <a href="https://github.com/projen/projen/issues/726">#726</a>)</li>
 * <li>Automated PR builds</li>
 * <li>Automated releases to npm, maven, NuGet and PyPI</li>
 * <li>Mergify configuration</li>
 * <li>LICENSE file generation</li>
 * <li>gitignore + npmignore management</li>
 * <li>Node "engines" support with coupling to CI build environment and &#64;types/node</li>
 * <li>Anti-tamper: CI builds will fail if a synthesized file is modified manually</li>
 * </ul>
 * <p>
 * <h2>API Reference</h2>
 * <p>
 * See <a href="./API.md">API Reference</a> for API details.
 * <p>
 * In addition, several projen components and project types are explained with examples in <a href="./docs">/docs</a> (currently a work in progress!).
 * <p>
 * <h2>Ecosystem</h2>
 * <p>
 * <em>projen</em> takes a "batteries included" approach and aims to offer dozens of different project types out of
 * the box (we are just getting started). Think <code>projen new react</code>, <code>projen new angular</code>, <code>projen new java-maven</code>,
 * <code>projen new awscdk-typescript</code>, <code>projen new cdk8s-python</code> (nothing in projen is tied to javascript or npm!)...
 * <p>
 * Adding new project types is as simple as submitting a pull request to this repo and exporting a class that
 * extends <code>projen.Project</code> (or one of it's derivatives). Projen automatically discovers project types so your
 * type will immediately be available in <code>projen new</code>.
 * <p>
 * <h3>Projects in external modules</h3>
 * <p>
 * <em>projen</em> is bundled with many project types out of the box, but it can also work
 * with project types and components defined in external jsii modules (the reason
 * we need jsii is because projen uses the jsii metadata to discover project types
 * &amp; options in projen new).
 * <p>
 * Say we have a module in npm called <code>projen-vuejs</code> which includes a single project
 * type for vue.js:
 * <p>
 * <blockquote><pre>
 * $ npx projen new --from projen-vuejs
 * </pre></blockquote>
 * <p>
 * If the referenced module includes multiple project types, the type is required.
 * Switches can also be used to specify initial values based on the project type
 * APIs. You can also use any package syntax supported by <a href="https://classic.yarnpkg.com/en/docs/cli/add#toc-adding-dependencies">yarn
 * add</a> like
 * <code>projen-vuejs&#64;1.2.3</code>, <code>file:/path/to/local/folder</code>,
 * <code>git&#64;github.com/awesome/projen-vuejs#1.2.3</code>, etc.
 * <p>
 * <blockquote><pre>
 * $ npx projen new --from projen-vuejs&#64;^2 vuejs-ts --description "my awesome vue project"
 * </pre></blockquote>
 * <p>
 * Under the hood, <code>projen new</code> will install the <code>projen-vuejs</code> module from npm
 * (version 2.0.0 and above), discover the project types in it and bootstrap the
 * <code>vuejs-ts</code> project type. It will assign the value <code>"my awesome vue project"</code> to
 * the <code>description</code> field. If you examine your <code>.projenrc.js</code> file, you'll see
 * that <code>projen-vuejs</code> is defined as a dev dependency:
 * <p>
 * <blockquote><pre>
 * const { VueJsProject } = require('projen-vuejs');
 * 
 * const project = new VueJsProject({
 *   name: 'my-vuejs-sample',
 *   description: "my awesome vue project",
 *   // ...
 *   devDeps: [
 *     'projen-vuejs'
 *   ]
 * });
 * 
 * project.synth();
 * </pre></blockquote>
 * <p>
 * <h2>Roadmap</h2>
 * <p>
 * See <a href="./VISION.md">Vision</a>.
 * <p>
 * <h2>FAQ</h2>
 * <p>
 * <h3>Do I have to write my configuration in JavaScript?</h3>
 * <p>
 * Not at all! JavaScript is the default, but it's also possible to write it in
 * Java, TypeScript, or even JSON. Python support is also planned. This is made
 * possible by the <a href="https://github.com/aws/jsii">jsii</a> library which allows us
 * to write APIs once and generate libraries in several languages. You can choose
 * a different language by passing the <code>--projenrc-ts</code>, <code>--projenrc-java</code>, or
 * <code>--projenrc-json</code> flags when running <code>projen new</code>.
 * <p>
 * Note: using a <code>.projenrc.json</code> file to specify configuration only allows
 * accessing a subset of the entire API - the options which are passed to the
 * constructor of each project type.
 * <p>
 * <h2>Contributions</h2>
 * <p>
 * Contributions of all kinds are welcome! Check out our <a href="./CONTRIBUTING.md">contributor's
 * guide</a> and our <a href="./CODE_OF_CONDUCT.md">code of conduct</a>.
 * <p>
 * For a quick start, check out a development environment:
 * <p>
 * <blockquote><pre>
 * $ git clone git&#64;github.com:projen/projen
 * $ cd projen
 * $ yarn
 * $ yarn watch # compile in the background
 * </pre></blockquote>
 * <p>
 * Thanks goes to these wonderful people (<a href="https://allcontributors.org/docs/en/emoji-key">emoji key</a>):
 * <p>
 * <!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section --><!-- prettier-ignore-start --><!-- markdownlint-disable --><table>  <tr>
 *     <td align="center"><a href="http://eladb.github.com/"><img src="https://avatars3.githubusercontent.com/u/598796?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Elad Ben-Israel</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=eladb" title="Code">💻</a></td>
 *     <td align="center"><a href="https://rybicki.io/"><img src="https://avatars2.githubusercontent.com/u/5008987?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Christopher Rybicki</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=Chriscbr" title="Code">💻</a></td>
 *     <td align="center"><a href="http://p6m7g8.github.io/"><img src="https://avatars0.githubusercontent.com/u/34295?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Philip M. Gollucci</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=pgollucci" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/hoegertn"><img src="https://avatars2.githubusercontent.com/u/1287829?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Thorsten Hoeger</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=hoegertn" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/kcwinner"><img src="https://avatars3.githubusercontent.com/u/2728868?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kenneth Winner</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=kcwinner" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/JordanSinko"><img src="https://avatars2.githubusercontent.com/u/10212966?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jordan Sinko</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=JordanSinko" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/misterjoshua"><img src="https://avatars2.githubusercontent.com/u/644092?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Josh Kellendonk</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=misterjoshua" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/andrestone"><img src="https://avatars1.githubusercontent.com/u/7958086?v=4?s=100" width="100px;" alt=""/><br /><sub><b>andrestone</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=andrestone" title="Code">💻</a></td>
 *     <td align="center"><a href="https://pallares.io/"><img src="https://avatars3.githubusercontent.com/u/1077520?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Cristian Pallarés</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=skyrpex" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/jogold"><img src="https://avatars2.githubusercontent.com/u/12623249?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jonathan Goldwasser</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=jogold" title="Code">💻</a></td>
 *     <td align="center"><a href="http://www.matthewbonig.com/"><img src="https://avatars2.githubusercontent.com/u/1559437?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matthew Bonig</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=mbonig" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/pahud"><img src="https://avatars3.githubusercontent.com/u/278432?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pahud Hsieh</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=pahud" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/adamelmore"><img src="https://avatars2.githubusercontent.com/u/2363879?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Adam Elmore</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=adamelmore" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/abelmokadem"><img src="https://avatars0.githubusercontent.com/u/9717944?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ash</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=abelmokadem" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/jmourelos"><img src="https://avatars3.githubusercontent.com/u/3878434?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jacob</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=jmourelos" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/bigkraig"><img src="https://avatars1.githubusercontent.com/u/508403?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kraig Amador</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=bigkraig" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/mmuller88"><img src="https://avatars0.githubusercontent.com/u/18393842?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Martin Muller</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=mmuller88" title="Code">💻</a></td>
 *     <td align="center"><a href="https://tlakomy.com/"><img src="https://avatars2.githubusercontent.com/u/16646517?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tomasz Łakomy</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=tlakomy" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/john-tipper"><img src="https://avatars2.githubusercontent.com/u/9730398?v=4?s=100" width="100px;" alt=""/><br /><sub><b>john-tipper</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=john-tipper" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/henrysachs"><img src="https://avatars0.githubusercontent.com/u/17173951?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Henry Sachs</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=henrysachs" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/eganjs"><img src="https://avatars3.githubusercontent.com/u/6639482?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Joseph Egan</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=eganjs" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://skorfmann.com/"><img src="https://avatars1.githubusercontent.com/u/136789?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sebastian Korfmann</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=skorfmann" title="Code">💻</a></td>
 *     <td align="center"><a href="http://www.callant.net/"><img src="https://avatars1.githubusercontent.com/u/5915843?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Bart Callant</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=bartcallant" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/campionfellin"><img src="https://avatars3.githubusercontent.com/u/11984923?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Campion Fellin</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=campionfellin" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/gradybarrett"><img src="https://avatars1.githubusercontent.com/u/1140074?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Grady Barrett</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=gradybarrett" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/HassanMahmud"><img src="https://avatars3.githubusercontent.com/u/58504381?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hassan Mahmud</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=HassanMahmud" title="Code">💻</a></td>
 *     <td align="center"><a href="https://dk.linkedin.com/in/hassanmahmud93"><img src="https://avatars1.githubusercontent.com/u/7426703?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hassan Mahmud</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=hass123uk" title="Code">💻</a></td>
 *     <td align="center"><a href="http://joapy.com/"><img src="https://avatars3.githubusercontent.com/u/325306?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jake Pearson</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=jakepearson" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/JeremyJonas"><img src="https://avatars1.githubusercontent.com/u/464119?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jeremy Jonas</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=JeremyJonas" title="Code">💻</a></td>
 *     <td align="center"><a href="https://dev.to/martzcodes"><img src="https://avatars1.githubusercontent.com/u/978362?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matt Martz</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=martzcodes" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/fongie"><img src="https://avatars1.githubusercontent.com/u/19932622?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Max Körlinge</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=fongie" title="Code">💻</a></td>
 *     <td align="center"><a href="https://blog.neilkuan.dev/"><img src="https://avatars2.githubusercontent.com/u/46012524?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Neil Kuan</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=guan840912" title="Code">💻</a></td>
 *     <td align="center"><a href="https://dynobase.dev/"><img src="https://avatars3.githubusercontent.com/u/3391616?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rafal Wilinski</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=RafalWilinski" title="Code">💻</a></td>
 *     <td align="center"><a href="https://keybase.io/romainmuller"><img src="https://avatars2.githubusercontent.com/u/411689?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Romain Marcadier</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=RomainMuller" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/thomasklinger1234"><img src="https://avatars1.githubusercontent.com/u/39558817?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Thomas Klinger</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=thomasklinger1234" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/gwriss"><img src="https://avatars2.githubusercontent.com/u/1842089?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tobias</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=gwriss" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/flyingImer"><img src="https://avatars0.githubusercontent.com/u/1973868?v=4?s=100" width="100px;" alt=""/><br /><sub><b>flyingImer</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=flyingImer" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/Hunter-Thompson"><img src="https://avatars.githubusercontent.com/u/20844961?v=4?s=100" width="100px;" alt=""/><br /><sub><b> Aatman </b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=Hunter-Thompson" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/mmcculloh-dms"><img src="https://avatars.githubusercontent.com/u/68597641?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mark McCulloh</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=mmcculloh-dms" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/aisamu"><img src="https://avatars.githubusercontent.com/u/431708?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Samuel Tschiedel</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=aisamu" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/iliapolo"><img src="https://avatars.githubusercontent.com/u/1428812?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eli Polonsky</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=iliapolo" title="Code">💻</a></td>
 *     <td align="center"><a href="https://unsubstantiated.blog/"><img src="https://avatars.githubusercontent.com/u/1308885?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alexander Steppke</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=Miradorn" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/kanatti"><img src="https://avatars.githubusercontent.com/u/8623654?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Balagopal Kanattil</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=kanatti" title="Code">💻</a></td>
 *     <td align="center"><a href="http://twitter.com/bracki"><img src="https://avatars.githubusercontent.com/u/49786?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jan Brauer</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=bracki" title="Code">💻</a></td>
 *     <td align="center"><a href="https://polothy.github.io/"><img src="https://avatars.githubusercontent.com/u/634657?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mark Nielsen</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=polothy" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/MrArnoldPalmer"><img src="https://avatars.githubusercontent.com/u/7221111?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mitchell Valine</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=MrArnoldPalmer" title="Code">💻</a></td>
 *     <td align="center"><a href="https://blog.neilkuan.net/"><img src="https://avatars.githubusercontent.com/u/46012524?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Neil Kuan</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=neilkuan" title="Code">💻</a></td>
 *     <td align="center"><a href="https://garbe.io/"><img src="https://avatars.githubusercontent.com/u/721899?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Philipp Garbe</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=pgarbe" title="Code">💻</a></td>
 *     <td align="center"><a href="https://selfstructured.com/"><img src="https://avatars.githubusercontent.com/u/361689?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shawn MacIntyre</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=smacintyre" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/tobias-bardino"><img src="https://avatars.githubusercontent.com/u/1842089?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tobias</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=tobias-bardino" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/yglcode"><img src="https://avatars.githubusercontent.com/u/11893614?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Yigong Liu</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=yglcode" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/eduardomourar"><img src="https://avatars.githubusercontent.com/u/16357187?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eduardo Rodrigues</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=eduardomourar" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/hassanazharkhan"><img src="https://avatars.githubusercontent.com/u/57677979?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hassan Azhar</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=hassanazharkhan" title="Code">💻</a></td>
 *     <td align="center"><a href="https://www.linkedin.com/in/julian-michel-812a223a/"><img src="https://avatars.githubusercontent.com/u/15660169?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Julian Michel</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=jumic" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/lmarsden"><img src="https://avatars.githubusercontent.com/u/51232932?v=4?s=100" width="100px;" alt=""/><br /><sub><b>lmarsden</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=lmarsden" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/adrianmace"><img src="https://avatars.githubusercontent.com/u/5071859?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Adrian Mace</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=adrianmace" title="Code">💻</a></td>
 *   </tr>
 *   <tr>
 *     <td align="center"><a href="https://github.com/mKeRix"><img src="https://avatars.githubusercontent.com/u/770596?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Heiko Rothe</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=mKeRix" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/hyandell"><img src="https://avatars.githubusercontent.com/u/477715?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Henri Yandell</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=hyandell" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/mwg-rea"><img src="https://avatars.githubusercontent.com/u/82480228?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matthew Gamble</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=mwg-rea" title="Code">💻</a></td>
 *     <td align="center"><a href="https://willdady.com/"><img src="https://avatars.githubusercontent.com/u/204259?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Will Dady</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=willdady" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/msessa"><img src="https://avatars.githubusercontent.com/u/1912143?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matteo Sessa</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=msessa" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/Hi-Fi"><img src="https://avatars.githubusercontent.com/u/1499780?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Juho Saarinen</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=Hi-Fi" title="Code">💻</a></td>
 *     <td align="center"><a href="https://github.com/njlynch"><img src="https://avatars.githubusercontent.com/u/1376292?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nick Lynch</b></sub></a><br /><a href="https://github.com/projen/projen/commits?author=njlynch" title="Code">💻</a></td>
 *   </tr>
 * </table><!-- markdownlint-restore --><!-- prettier-ignore-end --><!-- ALL-CONTRIBUTORS-LIST:END -->
 * <p>
 * <h2>License</h2>
 * <p>
 * Distributed under the <a href="./LICENSE">Apache-2.0</a> license.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package io.github.cdklabs.projen;
