package io.github.cdklabs.projen.release;

/**
 * (experimental) Manages releases (currently through GitHub workflows).
 * <p>
 * By default, no branches are released. To add branches, call <code>addBranch()</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.923Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.Release")
public class Release extends io.github.cdklabs.projen.Component {

    protected Release(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Release(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Release(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHubProject project, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.ReleaseOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a release branch.
     * <p>
     * It is a git branch from which releases are published. If a project has more than one release
     * branch, we require that <code>majorVersion</code> is also specified for the primary branch in order to
     * ensure branches always release the correct version.
     * <p>
     * @param branch The branch to monitor (e.g. `main`, `v2.x`). This parameter is required.
     * @param options Branch definition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addBranch(final @org.jetbrains.annotations.NotNull java.lang.String branch, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.BranchOptions options) {
        software.amazon.jsii.Kernel.call(this, "addBranch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(branch, "branch is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds jobs to all release workflows.
     * <p>
     * @param jobs The jobs to add (name => job). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addJobs(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.Job> jobs) {
        software.amazon.jsii.Kernel.call(this, "addJobs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(jobs, "jobs is required") });
    }

    /**
     * (experimental) Called before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void preSynthesize() {
        software.amazon.jsii.Kernel.call(this, "preSynthesize", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Retrieve all release branch names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getBranches() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Package publisher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.Publisher getPublisher() {
        return software.amazon.jsii.Kernel.get(this, "publisher", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.release.Publisher.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.release.Release}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.release.Release> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.github.GitHubProject project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.github.GitHubProject project;
        private final io.github.cdklabs.projen.release.ReleaseOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.github.GitHubProject project) {
            this.project = project;
            this.options = new io.github.cdklabs.projen.release.ReleaseOptions.Builder();
        }

        /**
         * (experimental) Checks that after build there are no modified files on git.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param antitamper Checks that after build there are no modified files on git. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder antitamper(final java.lang.Boolean antitamper) {
            this.options.antitamper(antitamper);
            return this;
        }

        /**
         * (experimental) A directory which will contain artifacts to be published to npm.
         * <p>
         * Default: "dist"
         * <p>
         * @return {@code this}
         * @param artifactsDirectory A directory which will contain artifacts to be published to npm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactsDirectory(final java.lang.String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        /**
         * (experimental) Version requirement of `jsii-release` which is used to publish modules to npm.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param jsiiReleaseVersion Version requirement of `jsii-release` which is used to publish modules to npm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jsiiReleaseVersion(final java.lang.String jsiiReleaseVersion) {
            this.options.jsiiReleaseVersion(jsiiReleaseVersion);
            return this;
        }

        /**
         * (experimental) Major version to release from the default branch.
         * <p>
         * If this is specified, we bump the latest version of this major version line.
         * If not specified, we bump the global latest version.
         * <p>
         * Default: - Major version is not enforced.
         * <p>
         * @return {@code this}
         * @param majorVersion Major version to release from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(final java.lang.Number majorVersion) {
            this.options.majorVersion(majorVersion);
            return this;
        }

        /**
         * (experimental) The npmDistTag to use when publishing from the default branch.
         * <p>
         * To set the npm dist-tag for release branches, set the <code>npmDistTag</code> property
         * for each branch.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param npmDistTag The npmDistTag to use when publishing from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmDistTag(final java.lang.String npmDistTag) {
            this.options.npmDistTag(npmDistTag);
            return this;
        }

        /**
         * (experimental) Steps to execute after build as part of the release workflow.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param postBuildSteps Steps to execute after build as part of the release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder postBuildSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        /**
         * (experimental) Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
         * <p>
         * Default: - normal semantic versions
         * <p>
         * @return {@code this}
         * @param prerelease Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prerelease(final java.lang.String prerelease) {
            this.options.prerelease(prerelease);
            return this;
        }

        /**
         * (experimental) Define publishing tasks that can be executed manually as well as workflows.
         * <p>
         * Normally, publishing only happens within automated workflows. Enable this
         * in order to create a publishing task for each publishing activity.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publishTasks Define publishing tasks that can be executed manually as well as workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTasks(final java.lang.Boolean publishTasks) {
            this.options.publishTasks(publishTasks);
            return this;
        }

        /**
         * (experimental) Defines additional release branches.
         * <p>
         * A workflow will be created for each
         * release branch which will publish releases from commits in this branch.
         * Each release branch <em>must</em> be assigned a major version number which is used
         * to enforce that versions published from that branch always use that major
         * version. If multiple branches are used, the <code>majorVersion</code> field must also
         * be provided for the default branch.
         * <p>
         * Default: - no additional branches are used for release. you can use
         * `addBranch()` to add additional branches.
         * <p>
         * @return {@code this}
         * @param releaseBranches Defines additional release branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseBranches(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.release.BranchOptions> releaseBranches) {
            this.options.releaseBranches(releaseBranches);
            return this;
        }

        /**
         * (deprecated) Automatically release new versions every commit to one of branches in `releaseBranches`.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.continuous()` instead
         * @param releaseEveryCommit Automatically release new versions every commit to one of branches in `releaseBranches`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseEveryCommit(final java.lang.Boolean releaseEveryCommit) {
            this.options.releaseEveryCommit(releaseEveryCommit);
            return this;
        }

        /**
         * (experimental) Create a github issue on every failed publishing task.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param releaseFailureIssue Create a github issue on every failed publishing task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssue(final java.lang.Boolean releaseFailureIssue) {
            this.options.releaseFailureIssue(releaseFailureIssue);
            return this;
        }

        /**
         * (experimental) The label to apply to issues indicating publish failures.
         * <p>
         * Only applies if <code>releaseFailureIssue</code> is true.
         * <p>
         * Default: "failed-release"
         * <p>
         * @return {@code this}
         * @param releaseFailureIssueLabel The label to apply to issues indicating publish failures. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssueLabel(final java.lang.String releaseFailureIssueLabel) {
            this.options.releaseFailureIssueLabel(releaseFailureIssueLabel);
            return this;
        }

        /**
         * (deprecated) CRON schedule to trigger new releases.
         * <p>
         * Default: - no scheduled releases
         * <p>
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.scheduled()` instead
         * @param releaseSchedule CRON schedule to trigger new releases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseSchedule(final java.lang.String releaseSchedule) {
            this.options.releaseSchedule(releaseSchedule);
            return this;
        }

        /**
         * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
         * <p>
         * Note: this prefix is used to detect the latest tagged version
         * when bumping, so if you change this on a project with an existing version
         * history, you may need to manually tag your latest release
         * with the new prefix.
         * <p>
         * Default: - no prefix
         * <p>
         * @return {@code this}
         * @param releaseTagPrefix Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagPrefix(final java.lang.String releaseTagPrefix) {
            this.options.releaseTagPrefix(releaseTagPrefix);
            return this;
        }

        /**
         * (experimental) The release trigger to use.
         * <p>
         * Default: - Continuous releases (`ReleaseTrigger.continuous()`)
         * <p>
         * @return {@code this}
         * @param releaseTrigger The release trigger to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTrigger(final io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger) {
            this.options.releaseTrigger(releaseTrigger);
            return this;
        }

        /**
         * (experimental) The name of the default release workflow.
         * <p>
         * Default: "Release"
         * <p>
         * @return {@code this}
         * @param releaseWorkflowName The name of the default release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowName(final java.lang.String releaseWorkflowName) {
            this.options.releaseWorkflowName(releaseWorkflowName);
            return this;
        }

        /**
         * (experimental) A set of workflow steps to execute in order to setup the workflow container.
         * <p>
         * @return {@code this}
         * @param releaseWorkflowSetupSteps A set of workflow steps to execute in order to setup the workflow container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowSetupSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps) {
            this.options.releaseWorkflowSetupSteps(releaseWorkflowSetupSteps);
            return this;
        }

        /**
         * (experimental) Custom configuration used when creating changelog with standard-version package.
         * <p>
         * Given values either append to default configuration or overwrite values in it.
         * <p>
         * Default: - standard configuration applicable for GitHub repositories
         * <p>
         * @return {@code this}
         * @param versionrcOptions Custom configuration used when creating changelog with standard-version package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionrcOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> versionrcOptions) {
            this.options.versionrcOptions(versionrcOptions);
            return this;
        }

        /**
         * (experimental) Container image to use for GitHub workflows.
         * <p>
         * Default: - default image
         * <p>
         * @return {@code this}
         * @param workflowContainerImage Container image to use for GitHub workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowContainerImage(final java.lang.String workflowContainerImage) {
            this.options.workflowContainerImage(workflowContainerImage);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param workflowRunsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOn(final java.util.List<java.lang.String> workflowRunsOn) {
            this.options.workflowRunsOn(workflowRunsOn);
            return this;
        }

        /**
         * (experimental) The default branch name to release from.
         * <p>
         * Use <code>majorVersion</code> to restrict this branch to only publish releases with a
         * specific major version.
         * <p>
         * You can add additional branches using <code>addBranch()</code>.
         * <p>
         * @return {@code this}
         * @param branch The default branch name to release from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branch(final java.lang.String branch) {
            this.options.branch(branch);
            return this;
        }

        /**
         * (experimental) The task to execute in order to create the release artifacts.
         * <p>
         * Artifacts are
         * expected to reside under <code>artifactsDirectory</code> (defaults to <code>dist/</code>) once
         * build is complete.
         * <p>
         * @return {@code this}
         * @param task The task to execute in order to create the release artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder task(final io.github.cdklabs.projen.Task task) {
            this.options.task(task);
            return this;
        }

        /**
         * (experimental) A name of a .json file to set the `version` field in after a bump.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated from non-compiling source. May contain errors.
         * "package.json"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param versionFile A name of a .json file to set the `version` field in after a bump. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionFile(final java.lang.String versionFile) {
            this.options.versionFile(versionFile);
            return this;
        }

        /**
         * (experimental) Create a GitHub release for each release.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param githubRelease Create a GitHub release for each release. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder githubRelease(final java.lang.Boolean githubRelease) {
            this.options.githubRelease(githubRelease);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.release.Release}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.release.Release build() {
            return new io.github.cdklabs.projen.release.Release(
                this.project,
                this.options.build()
            );
        }
    }
}
