package io.github.cdklabs.projen.vscode;

/**
 * (experimental) A development environment running VSCode in a container;
 * <p>
 * used by GitHub
 * codespaces.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-20T00:39:28.980Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.vscode.DevContainer")
public class DevContainer extends io.github.cdklabs.projen.Component implements io.github.cdklabs.projen.IDevEnvironment {

    protected DevContainer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DevContainer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DevContainer(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.vscode.DevContainerOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), options });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DevContainer(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     * <p>
     * @param image This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addDockerImage(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.DevEnvironmentDockerImage image) {
        software.amazon.jsii.Kernel.call(this, "addDockerImage", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * (experimental) Adds ports that should be exposed (forwarded) from the container.
     * <p>
     * @param ports The new ports. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addPorts(final @org.jetbrains.annotations.NotNull java.lang.String... ports) {
        software.amazon.jsii.Kernel.call(this, "addPorts", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(ports).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds tasks to run when the container starts.
     * <p>
     * Tasks will be run in sequence.
     * <p>
     * @param tasks The new tasks. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addTasks(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task... tasks) {
        software.amazon.jsii.Kernel.call(this, "addTasks", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(tasks).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds a list of VSCode extensions that should be automatically installed in the container.
     * <p>
     * @param extensions The extension IDs. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addVscodeExtensions(final @org.jetbrains.annotations.NotNull java.lang.String... extensions) {
        software.amazon.jsii.Kernel.call(this, "addVscodeExtensions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(extensions).toArray(Object[]::new));
    }

    /**
     * (experimental) Direct access to the devcontainer configuration (escape hatch).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.vscode.DevContainer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.vscode.DevContainer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private io.github.cdklabs.projen.vscode.DevContainerOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
        }

        /**
         * (experimental) A Docker image or Dockerfile for the container.
         * <p>
         * @return {@code this}
         * @param dockerImage A Docker image or Dockerfile for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerImage(final io.github.cdklabs.projen.DevEnvironmentDockerImage dockerImage) {
            this.options().dockerImage(dockerImage);
            return this;
        }

        /**
         * (experimental) An array of ports that should be exposed from the container.
         * <p>
         * @return {@code this}
         * @param ports An array of ports that should be exposed from the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ports(final java.util.List<java.lang.String> ports) {
            this.options().ports(ports);
            return this;
        }

        /**
         * (experimental) An array of tasks that should be run when the container starts.
         * <p>
         * @return {@code this}
         * @param tasks An array of tasks that should be run when the container starts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tasks(final java.util.List<? extends io.github.cdklabs.projen.Task> tasks) {
            this.options().tasks(tasks);
            return this;
        }

        /**
         * (experimental) An array of extension IDs that specify the extensions that should be installed inside the container when it is created.
         * <p>
         * @return {@code this}
         * @param vscodeExtensions An array of extension IDs that specify the extensions that should be installed inside the container when it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vscodeExtensions(final java.util.List<java.lang.String> vscodeExtensions) {
            this.options().vscodeExtensions(vscodeExtensions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.github.cdklabs.projen.vscode.DevContainer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.vscode.DevContainer build() {
            return new io.github.cdklabs.projen.vscode.DevContainer(
                this.project,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.vscode.DevContainerOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.vscode.DevContainerOptions.Builder();
            }
            return this.options;
        }
    }
}
