package io.github.cdklabs.projen;

/**
 * (experimental) A task that can be performed on the project.
 * <p>
 * Modeled as a series of shell
 * commands and subtasks.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.152Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.Task")
public class Task extends software.amazon.jsii.JsiiObject {

    protected Task(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Task(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param name This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Task(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskOptions props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), props });
    }

    /**
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Task(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Add a command to execute which determines if the task should be skipped.
     * <p>
     * If a condition already exists, the new condition will be appended with <code>&amp;&amp;</code> delimiter.
     * <p>
     * @see <a href="{@link Task.condition }">{@link Task.condition }</a>
     * @param condition The command to execute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addCondition(final @org.jetbrains.annotations.NotNull java.lang.String... condition) {
        software.amazon.jsii.Kernel.call(this, "addCondition", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(condition).toArray(Object[]::new));
    }

    /**
     * (experimental) Execute a builtin task.
     * <p>
     * Builtin tasks are programs bundled as part of projen itself and used as
     * helpers for various components.
     * <p>
     * In the future we should support built-in tasks from external modules.
     * <p>
     * @param name The name of the builtin task to execute (e.g. <code>release/resolve-version</code>). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void builtin(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        software.amazon.jsii.Kernel.call(this, "builtin", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Adds an environment variable to this task.
     * <p>
     * @param name The name of the variable. This parameter is required.
     * @param value The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void env(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "env", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Executes a shell command.
     * <p>
     * @param command Shell command. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void exec(final @org.jetbrains.annotations.NotNull java.lang.String command, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "exec", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(command, "command is required"), options });
    }

    /**
     * (experimental) Executes a shell command.
     * <p>
     * @param command Shell command. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void exec(final @org.jetbrains.annotations.NotNull java.lang.String command) {
        software.amazon.jsii.Kernel.call(this, "exec", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(command, "command is required") });
    }

    /**
     * (experimental) Forbid additional changes to this task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void lock() {
        software.amazon.jsii.Kernel.call(this, "lock", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (deprecated) Adds a command at the beginning of the task.
     * <p>
     * @deprecated use <code>prependExec()</code>
     * @param shell The command to add. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void prepend(final @org.jetbrains.annotations.NotNull java.lang.String shell, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "prepend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(shell, "shell is required"), options });
    }

    /**
     * (deprecated) Adds a command at the beginning of the task.
     * <p>
     * @deprecated use <code>prependExec()</code>
     * @param shell The command to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void prepend(final @org.jetbrains.annotations.NotNull java.lang.String shell) {
        software.amazon.jsii.Kernel.call(this, "prepend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(shell, "shell is required") });
    }

    /**
     * (experimental) Adds a command at the beginning of the task.
     * <p>
     * @param shell The command to add. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependExec(final @org.jetbrains.annotations.NotNull java.lang.String shell, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "prependExec", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(shell, "shell is required"), options });
    }

    /**
     * (experimental) Adds a command at the beginning of the task.
     * <p>
     * @param shell The command to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependExec(final @org.jetbrains.annotations.NotNull java.lang.String shell) {
        software.amazon.jsii.Kernel.call(this, "prependExec", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(shell, "shell is required") });
    }

    /**
     * (experimental) Says something at the beginning of the task.
     * <p>
     * @param message Your message. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependSay(final @org.jetbrains.annotations.NotNull java.lang.String message, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "prependSay", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required"), options });
    }

    /**
     * (experimental) Says something at the beginning of the task.
     * <p>
     * @param message Your message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependSay(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "prependSay", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * (experimental) Adds a spawn instruction at the beginning of the task.
     * <p>
     * @param subtask The subtask to execute. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependSpawn(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task subtask, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "prependSpawn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subtask, "subtask is required"), options });
    }

    /**
     * (experimental) Adds a spawn instruction at the beginning of the task.
     * <p>
     * @param subtask The subtask to execute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void prependSpawn(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task subtask) {
        software.amazon.jsii.Kernel.call(this, "prependSpawn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subtask, "subtask is required") });
    }

    /**
     * (experimental) Reset the task so it no longer has any commands.
     * <p>
     * @param command the first command to add to the task after it was cleared.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void reset(final @org.jetbrains.annotations.Nullable java.lang.String command, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "reset", software.amazon.jsii.NativeType.VOID, new Object[] { command, options });
    }

    /**
     * (experimental) Reset the task so it no longer has any commands.
     * <p>
     * @param command the first command to add to the task after it was cleared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void reset(final @org.jetbrains.annotations.Nullable java.lang.String command) {
        software.amazon.jsii.Kernel.call(this, "reset", software.amazon.jsii.NativeType.VOID, new Object[] { command });
    }

    /**
     * (experimental) Reset the task so it no longer has any commands.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void reset() {
        software.amazon.jsii.Kernel.call(this, "reset", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Say something.
     * <p>
     * @param message Your message. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void say(final @org.jetbrains.annotations.NotNull java.lang.String message, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "say", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required"), options });
    }

    /**
     * (experimental) Say something.
     * <p>
     * @param message Your message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void say(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "say", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * (experimental) Spawns a sub-task.
     * <p>
     * @param subtask The subtask to execute. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void spawn(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task subtask, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TaskStepOptions options) {
        software.amazon.jsii.Kernel.call(this, "spawn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subtask, "subtask is required"), options });
    }

    /**
     * (experimental) Spawns a sub-task.
     * <p>
     * @param subtask The subtask to execute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void spawn(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task subtask) {
        software.amazon.jsii.Kernel.call(this, "spawn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subtask, "subtask is required") });
    }

    /**
     * (experimental) Returns all environment variables in the task level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getEnvVars() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "envVars", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Task name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns an immutable copy of all the step specifications of the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<io.github.cdklabs.projen.TaskStep> getSteps() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.TaskStep.class))));
    }

    /**
     * (experimental) A command to execute which determines if the task should be skipped.
     * <p>
     * If it
     * returns a zero exit code, the task will not be executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
        return software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the description of this task.
     * <p>
     * Sets the description of this task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the description of this task.
     * <p>
     * Sets the description of this task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.Task}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.Task> {
        /**
         * @return a new instance of {@link Builder}.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String name) {
            return new Builder(name);
        }

        private final java.lang.String name;
        private io.github.cdklabs.projen.TaskOptions.Builder props;

        private Builder(final java.lang.String name) {
            this.name = name;
        }

        /**
         * (experimental) A shell command which determines if the this task should be executed.
         * <p>
         * If
         * the program exits with a zero exit code, steps will be executed. A non-zero
         * code means that task will be skipped.
         * <p>
         * @return {@code this}
         * @param condition A shell command which determines if the this task should be executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(final java.lang.String condition) {
            this.props().condition(condition);
            return this;
        }

        /**
         * (experimental) The working directory for all steps in this task (unless overridden by the step).
         * <p>
         * Default: - process.cwd()
         * <p>
         * @return {@code this}
         * @param cwd The working directory for all steps in this task (unless overridden by the step). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cwd(final java.lang.String cwd) {
            this.props().cwd(cwd);
            return this;
        }

        /**
         * (experimental) The description of this build command.
         * <p>
         * Default: - the task name
         * <p>
         * @return {@code this}
         * @param description The description of this build command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) Defines environment variables for the execution of this task.
         * <p>
         * Values in this map will be evaluated in a shell, so you can do stuff like <code>$(echo "foo")</code>.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param env Defines environment variables for the execution of this task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(final java.util.Map<java.lang.String, java.lang.String> env) {
            this.props().env(env);
            return this;
        }

        /**
         * (experimental) A set of environment variables that must be defined in order to execute this task.
         * <p>
         * Task execution will fail if one of these is not defined.
         * <p>
         * @return {@code this}
         * @param requiredEnv A set of environment variables that must be defined in order to execute this task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requiredEnv(final java.util.List<java.lang.String> requiredEnv) {
            this.props().requiredEnv(requiredEnv);
            return this;
        }

        /**
         * (experimental) Should the provided <code>exec</code> shell command receive fixed args.
         * <p>
         * Default: - no arguments are passed to the step
         * <p>
         * @return {@code this}
         * @see <a href="{@link TaskStepOptions.args }">{@link TaskStepOptions.args }</a>
         * @param args Should the provided <code>exec</code> shell command receive fixed args. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(final java.util.List<java.lang.String> args) {
            this.props().args(args);
            return this;
        }

        /**
         * (experimental) Shell command to execute as the first command of the task.
         * <p>
         * Default: - add steps using `task.exec(command)` or `task.spawn(subtask)`
         * <p>
         * @return {@code this}
         * @param exec Shell command to execute as the first command of the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exec(final java.lang.String exec) {
            this.props().exec(exec);
            return this;
        }

        /**
         * (experimental) Should the provided <code>exec</code> shell command receive args passed to the task.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="{@link TaskStepOptions.receiveArgs }">{@link TaskStepOptions.receiveArgs }</a>
         * @param receiveArgs Should the provided <code>exec</code> shell command receive args passed to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder receiveArgs(final java.lang.Boolean receiveArgs) {
            this.props().receiveArgs(receiveArgs);
            return this;
        }

        /**
         * (experimental) List of task steps to run.
         * <p>
         * @return {@code this}
         * @param steps List of task steps to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder steps(final java.util.List<? extends io.github.cdklabs.projen.TaskStep> steps) {
            this.props().steps(steps);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.Task}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.Task build() {
            return new io.github.cdklabs.projen.Task(
                this.name,
                this.props != null ? this.props.build() : null
            );
        }

        private io.github.cdklabs.projen.TaskOptions.Builder props() {
            if (this.props == null) {
                this.props = new io.github.cdklabs.projen.TaskOptions.Builder();
            }
            return this.props;
        }
    }
}
