package io.github.cdklabs.projen;

/**
 * (experimental) Options for task steps.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.158Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.TaskStepOptions")
@software.amazon.jsii.Jsii.Proxy(TaskStepOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TaskStepOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A list of fixed arguments always passed to the step.
     * <p>
     * Useful to re-use existing tasks without having to re-define the whole task.\
     * Fixed args are always passed to the step, even if <code>receiveArgs</code> is <code>false</code>
     * and are always passed before any args the task is called with.
     * <p>
     * If the step executes a shell commands, args are passed through at the end of the <code>exec</code> shell command.\
     * The position of the args can be changed by including the marker <code>$&#64;</code> inside the command string.
     * <p>
     * If the step spawns a subtask, args are passed to the subtask.
     * The subtask must define steps receiving args for this to have any effect.
     * <p>
     * If the step calls a builtin script, args are passed to the script.
     * It is up to the script to use or discard the arguments.
     * <p>
     * Default: - no arguments are passed to the step
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * task.spawn("deploy", { args: ["--force"] });
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * (experimental) A shell command which determines if the this step should be executed.
     * <p>
     * If
     * the program exits with a zero exit code, the step will be executed. A non-zero
     * code means the step will be skipped (subsequent task steps will still be evaluated/executed).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
        return null;
    }

    /**
     * (experimental) The working directory for this step.
     * <p>
     * Default: - determined by the task
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCwd() {
        return null;
    }

    /**
     * (experimental) Defines environment variables for the execution of this step (<code>exec</code> and <code>builtin</code> only).
     * <p>
     * Values in this map can be simple, literal values or shell expressions that will be evaluated at runtime e.g. <code>$(echo "foo")</code>.
     * <p>
     * Default: - no environment variables defined in step
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * { "foo": "bar", "boo": "$(echo baz)" }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * (experimental) Step name.
     * <p>
     * Default: - no name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) Should this step receive args passed to the task.
     * <p>
     * If <code>true</code>, args are passed through at the end of the <code>exec</code> shell command.\
     * The position of the args can be changed by including the marker <code>$&#64;</code> inside the command string.
     * <p>
     * If the step spawns a subtask, args are passed to the subtask.
     * The subtask must define steps receiving args for this to have any effect.
     * <p>
     * Default: false
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * task.exec("echo Hello $&#64; World!", { receiveArgs: true });
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReceiveArgs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TaskStepOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TaskStepOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TaskStepOptions> {
        java.util.List<java.lang.String> args;
        java.lang.String condition;
        java.lang.String cwd;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.lang.String name;
        java.lang.Boolean receiveArgs;

        /**
         * Sets the value of {@link TaskStepOptions#getArgs}
         * @param args A list of fixed arguments always passed to the step.
         *             Useful to re-use existing tasks without having to re-define the whole task.\
         *             Fixed args are always passed to the step, even if <code>receiveArgs</code> is <code>false</code>
         *             and are always passed before any args the task is called with.
         *             <p>
         *             If the step executes a shell commands, args are passed through at the end of the <code>exec</code> shell command.\
         *             The position of the args can be changed by including the marker <code>$&#64;</code> inside the command string.
         *             <p>
         *             If the step spawns a subtask, args are passed to the subtask.
         *             The subtask must define steps receiving args for this to have any effect.
         *             <p>
         *             If the step calls a builtin script, args are passed to the script.
         *             It is up to the script to use or discard the arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(java.util.List<java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link TaskStepOptions#getCondition}
         * @param condition A shell command which determines if the this step should be executed.
         *                  If
         *                  the program exits with a zero exit code, the step will be executed. A non-zero
         *                  code means the step will be skipped (subsequent task steps will still be evaluated/executed).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(java.lang.String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link TaskStepOptions#getCwd}
         * @param cwd The working directory for this step.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cwd(java.lang.String cwd) {
            this.cwd = cwd;
            return this;
        }

        /**
         * Sets the value of {@link TaskStepOptions#getEnv}
         * @param env Defines environment variables for the execution of this step (<code>exec</code> and <code>builtin</code> only).
         *            Values in this map can be simple, literal values or shell expressions that will be evaluated at runtime e.g. <code>$(echo "foo")</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link TaskStepOptions#getName}
         * @param name Step name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link TaskStepOptions#getReceiveArgs}
         * @param receiveArgs Should this step receive args passed to the task.
         *                    If <code>true</code>, args are passed through at the end of the <code>exec</code> shell command.\
         *                    The position of the args can be changed by including the marker <code>$&#64;</code> inside the command string.
         *                    <p>
         *                    If the step spawns a subtask, args are passed to the subtask.
         *                    The subtask must define steps receiving args for this to have any effect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder receiveArgs(java.lang.Boolean receiveArgs) {
            this.receiveArgs = receiveArgs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskStepOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TaskStepOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TaskStepOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskStepOptions {
        private final java.util.List<java.lang.String> args;
        private final java.lang.String condition;
        private final java.lang.String cwd;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.lang.String name;
        private final java.lang.Boolean receiveArgs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cwd = software.amazon.jsii.Kernel.get(this, "cwd", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.receiveArgs = software.amazon.jsii.Kernel.get(this, "receiveArgs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.args = builder.args;
            this.condition = builder.condition;
            this.cwd = builder.cwd;
            this.env = builder.env;
            this.name = builder.name;
            this.receiveArgs = builder.receiveArgs;
        }

        @Override
        public final java.util.List<java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public final java.lang.String getCondition() {
            return this.condition;
        }

        @Override
        public final java.lang.String getCwd() {
            return this.cwd;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getReceiveArgs() {
            return this.receiveArgs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getCwd() != null) {
                data.set("cwd", om.valueToTree(this.getCwd()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getReceiveArgs() != null) {
                data.set("receiveArgs", om.valueToTree(this.getReceiveArgs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.TaskStepOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TaskStepOptions.Jsii$Proxy that = (TaskStepOptions.Jsii$Proxy) o;

            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.cwd != null ? !this.cwd.equals(that.cwd) : that.cwd != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.receiveArgs != null ? this.receiveArgs.equals(that.receiveArgs) : that.receiveArgs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.args != null ? this.args.hashCode() : 0;
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.cwd != null ? this.cwd.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.receiveArgs != null ? this.receiveArgs.hashCode() : 0);
            return result;
        }
    }
}
