package io.github.cdklabs.projen.github;

/**
 * (experimental) Use to add private registry support for dependabot.
 * <p>
 * @see <a href="https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries">https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.418Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.DependabotRegistry")
@software.amazon.jsii.Jsii.Proxy(DependabotRegistry.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DependabotRegistry extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Registry type e.g. 'npm-registry' or 'docker-registry'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.DependabotRegistryType getType();

    /**
     * (experimental) Url for the registry e.g. 'https://npm.pkg.github.com' or 'registry.hub.docker.com'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUrl();

    /**
     * (experimental) A reference to a Dependabot secret containing an access key for this registry.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * (experimental) Used with the hex-organization registry type.
     * <p>
     * Default: undefined
     * <p>
     * @see <a href="https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#hex-organization">https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#hex-organization</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganization() {
        return null;
    }

    /**
     * (experimental) A reference to a Dependabot secret containing the password for the specified user.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * (experimental) For registries with type: python-index, if the boolean value is true, pip esolves dependencies by using the specified URL rather than the base URL of the Python Package Index (by default https://pypi.org/simple).
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplacesBase() {
        return null;
    }

    /**
     * (experimental) Secret token for dependabot access e.g. '${{ secrets.DEPENDABOT_PACKAGE_TOKEN }}'.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getToken() {
        return null;
    }

    /**
     * (experimental) The username that Dependabot uses to access the registry.
     * <p>
     * Default: - do not authenticate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DependabotRegistry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DependabotRegistry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DependabotRegistry> {
        io.github.cdklabs.projen.github.DependabotRegistryType type;
        java.lang.String url;
        java.lang.String key;
        java.lang.String organization;
        java.lang.String password;
        java.lang.Boolean replacesBase;
        java.lang.String token;
        java.lang.String username;

        /**
         * Sets the value of {@link DependabotRegistry#getType}
         * @param type Registry type e.g. 'npm-registry' or 'docker-registry'. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(io.github.cdklabs.projen.github.DependabotRegistryType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getUrl}
         * @param url Url for the registry e.g. 'https://npm.pkg.github.com' or 'registry.hub.docker.com'. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getKey}
         * @param key A reference to a Dependabot secret containing an access key for this registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getOrganization}
         * @param organization Used with the hex-organization registry type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder organization(java.lang.String organization) {
            this.organization = organization;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getPassword}
         * @param password A reference to a Dependabot secret containing the password for the specified user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getReplacesBase}
         * @param replacesBase For registries with type: python-index, if the boolean value is true, pip esolves dependencies by using the specified URL rather than the base URL of the Python Package Index (by default https://pypi.org/simple).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replacesBase(java.lang.Boolean replacesBase) {
            this.replacesBase = replacesBase;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getToken}
         * @param token Secret token for dependabot access e.g. '${{ secrets.DEPENDABOT_PACKAGE_TOKEN }}'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder token(java.lang.String token) {
            this.token = token;
            return this;
        }

        /**
         * Sets the value of {@link DependabotRegistry#getUsername}
         * @param username The username that Dependabot uses to access the registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DependabotRegistry}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DependabotRegistry build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DependabotRegistry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DependabotRegistry {
        private final io.github.cdklabs.projen.github.DependabotRegistryType type;
        private final java.lang.String url;
        private final java.lang.String key;
        private final java.lang.String organization;
        private final java.lang.String password;
        private final java.lang.Boolean replacesBase;
        private final java.lang.String token;
        private final java.lang.String username;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.DependabotRegistryType.class));
            this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organization = software.amazon.jsii.Kernel.get(this, "organization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replacesBase = software.amazon.jsii.Kernel.get(this, "replacesBase", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.token = software.amazon.jsii.Kernel.get(this, "token", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
            this.key = builder.key;
            this.organization = builder.organization;
            this.password = builder.password;
            this.replacesBase = builder.replacesBase;
            this.token = builder.token;
            this.username = builder.username;
        }

        @Override
        public final io.github.cdklabs.projen.github.DependabotRegistryType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getUrl() {
            return this.url;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getOrganization() {
            return this.organization;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Boolean getReplacesBase() {
            return this.replacesBase;
        }

        @Override
        public final java.lang.String getToken() {
            return this.token;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            data.set("url", om.valueToTree(this.getUrl()));
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getOrganization() != null) {
                data.set("organization", om.valueToTree(this.getOrganization()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getReplacesBase() != null) {
                data.set("replacesBase", om.valueToTree(this.getReplacesBase()));
            }
            if (this.getToken() != null) {
                data.set("token", om.valueToTree(this.getToken()));
            }
            if (this.getUsername() != null) {
                data.set("username", om.valueToTree(this.getUsername()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.github.DependabotRegistry"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DependabotRegistry.Jsii$Proxy that = (DependabotRegistry.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (!url.equals(that.url)) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.organization != null ? !this.organization.equals(that.organization) : that.organization != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.replacesBase != null ? !this.replacesBase.equals(that.replacesBase) : that.replacesBase != null) return false;
            if (this.token != null ? !this.token.equals(that.token) : that.token != null) return false;
            return this.username != null ? this.username.equals(that.username) : that.username == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.url.hashCode());
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.organization != null ? this.organization.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.replacesBase != null ? this.replacesBase.hashCode() : 0);
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            return result;
        }
    }
}
