package io.github.cdklabs.projen.gitlab;

/**
 * (experimental) Used to specify a list of files and directories that should be attached to the job if it succeeds.
 * <p>
 * Artifacts are sent to Gitlab where they can be downloaded.
 * <p>
 * @see <a href="https://docs.gitlab.com/ee/ci/yaml/#artifacts">https://docs.gitlab.com/ee/ci/yaml/#artifacts</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.464Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.gitlab.Artifacts")
@software.amazon.jsii.Jsii.Proxy(Artifacts.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Artifacts extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A list of paths to files/folders that should be excluded in the artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
        return null;
    }

    /**
     * (experimental) How long artifacts should be kept.
     * <p>
     * They are saved 30 days by default. Artifacts that have expired are removed periodically via cron job. Supports a wide variety of formats, e.g. '1 week', '3 mins 4 sec', '2 hrs 20 min', '2h20min', '6 mos 1 day', '47 yrs 6 mos and 4d', '3 weeks and 2 days'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getExpireIn() {
        return null;
    }

    /**
     * (experimental) Can be used to expose job artifacts in the merge request UI.
     * <p>
     * GitLab will add a link &lt;expose_as&gt; to the relevant merge request that points to the artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getExposeAs() {
        return null;
    }

    /**
     * (experimental) Name for the archive created on job success.
     * <p>
     * Can use variables in the name, e.g. '$CI_JOB_NAME'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) A list of paths to files/folders that should be included in the artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPaths() {
        return null;
    }

    /**
     * (experimental) Reports will be uploaded as artifacts, and often displayed in the Gitlab UI, such as in Merge Requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Reports getReports() {
        return null;
    }

    /**
     * (experimental) Whether to add all untracked files (along with 'artifacts.paths') to the artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUntracked() {
        return null;
    }

    /**
     * (experimental) Configure when artifacts are uploaded depended on job status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.CacheWhen getWhen() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Artifacts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Artifacts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Artifacts> {
        java.util.List<java.lang.String> exclude;
        java.lang.String expireIn;
        java.lang.String exposeAs;
        java.lang.String name;
        java.util.List<java.lang.String> paths;
        io.github.cdklabs.projen.gitlab.Reports reports;
        java.lang.Boolean untracked;
        io.github.cdklabs.projen.gitlab.CacheWhen when;

        /**
         * Sets the value of {@link Artifacts#getExclude}
         * @param exclude A list of paths to files/folders that should be excluded in the artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getExpireIn}
         * @param expireIn How long artifacts should be kept.
         *                 They are saved 30 days by default. Artifacts that have expired are removed periodically via cron job. Supports a wide variety of formats, e.g. '1 week', '3 mins 4 sec', '2 hrs 20 min', '2h20min', '6 mos 1 day', '47 yrs 6 mos and 4d', '3 weeks and 2 days'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expireIn(java.lang.String expireIn) {
            this.expireIn = expireIn;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getExposeAs}
         * @param exposeAs Can be used to expose job artifacts in the merge request UI.
         *                 GitLab will add a link &lt;expose_as&gt; to the relevant merge request that points to the artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exposeAs(java.lang.String exposeAs) {
            this.exposeAs = exposeAs;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getName}
         * @param name Name for the archive created on job success.
         *             Can use variables in the name, e.g. '$CI_JOB_NAME'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getPaths}
         * @param paths A list of paths to files/folders that should be included in the artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder paths(java.util.List<java.lang.String> paths) {
            this.paths = paths;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getReports}
         * @param reports Reports will be uploaded as artifacts, and often displayed in the Gitlab UI, such as in Merge Requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reports(io.github.cdklabs.projen.gitlab.Reports reports) {
            this.reports = reports;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getUntracked}
         * @param untracked Whether to add all untracked files (along with 'artifacts.paths') to the artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder untracked(java.lang.Boolean untracked) {
            this.untracked = untracked;
            return this;
        }

        /**
         * Sets the value of {@link Artifacts#getWhen}
         * @param when Configure when artifacts are uploaded depended on job status.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder when(io.github.cdklabs.projen.gitlab.CacheWhen when) {
            this.when = when;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Artifacts}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Artifacts build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Artifacts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Artifacts {
        private final java.util.List<java.lang.String> exclude;
        private final java.lang.String expireIn;
        private final java.lang.String exposeAs;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> paths;
        private final io.github.cdklabs.projen.gitlab.Reports reports;
        private final java.lang.Boolean untracked;
        private final io.github.cdklabs.projen.gitlab.CacheWhen when;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expireIn = software.amazon.jsii.Kernel.get(this, "expireIn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exposeAs = software.amazon.jsii.Kernel.get(this, "exposeAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.paths = software.amazon.jsii.Kernel.get(this, "paths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.reports = software.amazon.jsii.Kernel.get(this, "reports", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Reports.class));
            this.untracked = software.amazon.jsii.Kernel.get(this, "untracked", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.when = software.amazon.jsii.Kernel.get(this, "when", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.CacheWhen.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.exclude = builder.exclude;
            this.expireIn = builder.expireIn;
            this.exposeAs = builder.exposeAs;
            this.name = builder.name;
            this.paths = builder.paths;
            this.reports = builder.reports;
            this.untracked = builder.untracked;
            this.when = builder.when;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final java.lang.String getExpireIn() {
            return this.expireIn;
        }

        @Override
        public final java.lang.String getExposeAs() {
            return this.exposeAs;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getPaths() {
            return this.paths;
        }

        @Override
        public final io.github.cdklabs.projen.gitlab.Reports getReports() {
            return this.reports;
        }

        @Override
        public final java.lang.Boolean getUntracked() {
            return this.untracked;
        }

        @Override
        public final io.github.cdklabs.projen.gitlab.CacheWhen getWhen() {
            return this.when;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getExpireIn() != null) {
                data.set("expireIn", om.valueToTree(this.getExpireIn()));
            }
            if (this.getExposeAs() != null) {
                data.set("exposeAs", om.valueToTree(this.getExposeAs()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPaths() != null) {
                data.set("paths", om.valueToTree(this.getPaths()));
            }
            if (this.getReports() != null) {
                data.set("reports", om.valueToTree(this.getReports()));
            }
            if (this.getUntracked() != null) {
                data.set("untracked", om.valueToTree(this.getUntracked()));
            }
            if (this.getWhen() != null) {
                data.set("when", om.valueToTree(this.getWhen()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.gitlab.Artifacts"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Artifacts.Jsii$Proxy that = (Artifacts.Jsii$Proxy) o;

            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.expireIn != null ? !this.expireIn.equals(that.expireIn) : that.expireIn != null) return false;
            if (this.exposeAs != null ? !this.exposeAs.equals(that.exposeAs) : that.exposeAs != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) return false;
            if (this.reports != null ? !this.reports.equals(that.reports) : that.reports != null) return false;
            if (this.untracked != null ? !this.untracked.equals(that.untracked) : that.untracked != null) return false;
            return this.when != null ? this.when.equals(that.when) : that.when == null;
        }

        @Override
        public final int hashCode() {
            int result = this.exclude != null ? this.exclude.hashCode() : 0;
            result = 31 * result + (this.expireIn != null ? this.expireIn.hashCode() : 0);
            result = 31 * result + (this.exposeAs != null ? this.exposeAs.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.paths != null ? this.paths.hashCode() : 0);
            result = 31 * result + (this.reports != null ? this.reports.hashCode() : 0);
            result = 31 * result + (this.untracked != null ? this.untracked.hashCode() : 0);
            result = 31 * result + (this.when != null ? this.when.hashCode() : 0);
            return result;
        }
    }
}
