package io.github.cdklabs.projen.release;

/**
 * (experimental) Options for a release branch.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.578Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.BranchOptions")
@software.amazon.jsii.Jsii.Proxy(BranchOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BranchOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The major versions released from this branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getMajorVersion();

    /**
     * (experimental) The minimum major version to release.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinMajorVersion() {
        return null;
    }

    /**
     * (experimental) The minor versions released from this branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinorVersion() {
        return null;
    }

    /**
     * (experimental) The npm distribution tag to use for this branch.
     * <p>
     * Default: "latest"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getNpmDistTag() {
        return null;
    }

    /**
     * (experimental) Bump the version as a pre-release tag.
     * <p>
     * Default: - normal releases
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrerelease() {
        return null;
    }

    /**
     * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
     * <p>
     * Note: this prefix is used to detect the latest tagged version
     * when bumping, so if you change this on a project with an existing version
     * history, you may need to manually tag your latest release
     * with the new prefix.
     * <p>
     * Default: - no prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTagPrefix() {
        return null;
    }

    /**
     * (experimental) The name of the release workflow.
     * <p>
     * Default: "release-BRANCH"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkflowName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BranchOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BranchOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BranchOptions> {
        java.lang.Number majorVersion;
        java.lang.Number minMajorVersion;
        java.lang.Number minorVersion;
        java.lang.String npmDistTag;
        java.lang.String prerelease;
        java.lang.String tagPrefix;
        java.lang.String workflowName;

        /**
         * Sets the value of {@link BranchOptions#getMajorVersion}
         * @param majorVersion The major versions released from this branch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(java.lang.Number majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getMinMajorVersion}
         * @param minMajorVersion The minimum major version to release.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minMajorVersion(java.lang.Number minMajorVersion) {
            this.minMajorVersion = minMajorVersion;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getMinorVersion}
         * @param minorVersion The minor versions released from this branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minorVersion(java.lang.Number minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getNpmDistTag}
         * @param npmDistTag The npm distribution tag to use for this branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmDistTag(java.lang.String npmDistTag) {
            this.npmDistTag = npmDistTag;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getPrerelease}
         * @param prerelease Bump the version as a pre-release tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prerelease(java.lang.String prerelease) {
            this.prerelease = prerelease;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getTagPrefix}
         * @param tagPrefix Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
         *                  Note: this prefix is used to detect the latest tagged version
         *                  when bumping, so if you change this on a project with an existing version
         *                  history, you may need to manually tag your latest release
         *                  with the new prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tagPrefix(java.lang.String tagPrefix) {
            this.tagPrefix = tagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BranchOptions#getWorkflowName}
         * @param workflowName The name of the release workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowName(java.lang.String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BranchOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BranchOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BranchOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BranchOptions {
        private final java.lang.Number majorVersion;
        private final java.lang.Number minMajorVersion;
        private final java.lang.Number minorVersion;
        private final java.lang.String npmDistTag;
        private final java.lang.String prerelease;
        private final java.lang.String tagPrefix;
        private final java.lang.String workflowName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.majorVersion = software.amazon.jsii.Kernel.get(this, "majorVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minMajorVersion = software.amazon.jsii.Kernel.get(this, "minMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minorVersion = software.amazon.jsii.Kernel.get(this, "minorVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.npmDistTag = software.amazon.jsii.Kernel.get(this, "npmDistTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.prerelease = software.amazon.jsii.Kernel.get(this, "prerelease", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagPrefix = software.amazon.jsii.Kernel.get(this, "tagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workflowName = software.amazon.jsii.Kernel.get(this, "workflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.majorVersion = java.util.Objects.requireNonNull(builder.majorVersion, "majorVersion is required");
            this.minMajorVersion = builder.minMajorVersion;
            this.minorVersion = builder.minorVersion;
            this.npmDistTag = builder.npmDistTag;
            this.prerelease = builder.prerelease;
            this.tagPrefix = builder.tagPrefix;
            this.workflowName = builder.workflowName;
        }

        @Override
        public final java.lang.Number getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public final java.lang.Number getMinMajorVersion() {
            return this.minMajorVersion;
        }

        @Override
        public final java.lang.Number getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final java.lang.String getNpmDistTag() {
            return this.npmDistTag;
        }

        @Override
        public final java.lang.String getPrerelease() {
            return this.prerelease;
        }

        @Override
        public final java.lang.String getTagPrefix() {
            return this.tagPrefix;
        }

        @Override
        public final java.lang.String getWorkflowName() {
            return this.workflowName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("majorVersion", om.valueToTree(this.getMajorVersion()));
            if (this.getMinMajorVersion() != null) {
                data.set("minMajorVersion", om.valueToTree(this.getMinMajorVersion()));
            }
            if (this.getMinorVersion() != null) {
                data.set("minorVersion", om.valueToTree(this.getMinorVersion()));
            }
            if (this.getNpmDistTag() != null) {
                data.set("npmDistTag", om.valueToTree(this.getNpmDistTag()));
            }
            if (this.getPrerelease() != null) {
                data.set("prerelease", om.valueToTree(this.getPrerelease()));
            }
            if (this.getTagPrefix() != null) {
                data.set("tagPrefix", om.valueToTree(this.getTagPrefix()));
            }
            if (this.getWorkflowName() != null) {
                data.set("workflowName", om.valueToTree(this.getWorkflowName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.release.BranchOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BranchOptions.Jsii$Proxy that = (BranchOptions.Jsii$Proxy) o;

            if (!majorVersion.equals(that.majorVersion)) return false;
            if (this.minMajorVersion != null ? !this.minMajorVersion.equals(that.minMajorVersion) : that.minMajorVersion != null) return false;
            if (this.minorVersion != null ? !this.minorVersion.equals(that.minorVersion) : that.minorVersion != null) return false;
            if (this.npmDistTag != null ? !this.npmDistTag.equals(that.npmDistTag) : that.npmDistTag != null) return false;
            if (this.prerelease != null ? !this.prerelease.equals(that.prerelease) : that.prerelease != null) return false;
            if (this.tagPrefix != null ? !this.tagPrefix.equals(that.tagPrefix) : that.tagPrefix != null) return false;
            return this.workflowName != null ? this.workflowName.equals(that.workflowName) : that.workflowName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.majorVersion.hashCode();
            result = 31 * result + (this.minMajorVersion != null ? this.minMajorVersion.hashCode() : 0);
            result = 31 * result + (this.minorVersion != null ? this.minorVersion.hashCode() : 0);
            result = 31 * result + (this.npmDistTag != null ? this.npmDistTag.hashCode() : 0);
            result = 31 * result + (this.prerelease != null ? this.prerelease.hashCode() : 0);
            result = 31 * result + (this.tagPrefix != null ? this.tagPrefix.hashCode() : 0);
            result = 31 * result + (this.workflowName != null ? this.workflowName.hashCode() : 0);
            return result;
        }
    }
}
