package io.github.cdklabs.projen.release;

/**
 * (experimental) Publishing options for Git releases.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-10T23:18:45.580Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.GitPublishOptions")
@software.amazon.jsii.Jsii.Proxy(GitPublishOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitPublishOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The location of an .md file (relative to <code>dist/</code>) that includes the changelog for the release.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * changelog.md
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getChangelogFile();

    /**
     * (experimental) The location of a text file (relative to <code>dist/</code>) that contains the release tag.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * releasetag.txt
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getReleaseTagFile();

    /**
     * (experimental) The location of a text file (relative to <code>dist/</code>) that contains the version number.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * version.txt
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionFile();

    /**
     * (experimental) Branch to push to.
     * <p>
     * Default: "main"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getGitBranch() {
        return null;
    }

    /**
     * (experimental) Override git-push command.
     * <p>
     * Set to an empty string to disable pushing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getGitPushCommand() {
        return null;
    }

    /**
     * (experimental) The location of an .md file that includes the project-level changelog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectChangelogFile() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitPublishOptions> {
        java.lang.String changelogFile;
        java.lang.String releaseTagFile;
        java.lang.String versionFile;
        java.lang.String gitBranch;
        java.lang.String gitPushCommand;
        java.lang.String projectChangelogFile;

        /**
         * Sets the value of {@link GitPublishOptions#getChangelogFile}
         * @param changelogFile The location of an .md file (relative to <code>dist/</code>) that includes the changelog for the release. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changelogFile(java.lang.String changelogFile) {
            this.changelogFile = changelogFile;
            return this;
        }

        /**
         * Sets the value of {@link GitPublishOptions#getReleaseTagFile}
         * @param releaseTagFile The location of a text file (relative to <code>dist/</code>) that contains the release tag. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagFile(java.lang.String releaseTagFile) {
            this.releaseTagFile = releaseTagFile;
            return this;
        }

        /**
         * Sets the value of {@link GitPublishOptions#getVersionFile}
         * @param versionFile The location of a text file (relative to <code>dist/</code>) that contains the version number. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionFile(java.lang.String versionFile) {
            this.versionFile = versionFile;
            return this;
        }

        /**
         * Sets the value of {@link GitPublishOptions#getGitBranch}
         * @param gitBranch Branch to push to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitBranch(java.lang.String gitBranch) {
            this.gitBranch = gitBranch;
            return this;
        }

        /**
         * Sets the value of {@link GitPublishOptions#getGitPushCommand}
         * @param gitPushCommand Override git-push command.
         *                       Set to an empty string to disable pushing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitPushCommand(java.lang.String gitPushCommand) {
            this.gitPushCommand = gitPushCommand;
            return this;
        }

        /**
         * Sets the value of {@link GitPublishOptions#getProjectChangelogFile}
         * @param projectChangelogFile The location of an .md file that includes the project-level changelog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectChangelogFile(java.lang.String projectChangelogFile) {
            this.projectChangelogFile = projectChangelogFile;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitPublishOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitPublishOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitPublishOptions {
        private final java.lang.String changelogFile;
        private final java.lang.String releaseTagFile;
        private final java.lang.String versionFile;
        private final java.lang.String gitBranch;
        private final java.lang.String gitPushCommand;
        private final java.lang.String projectChangelogFile;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.changelogFile = software.amazon.jsii.Kernel.get(this, "changelogFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseTagFile = software.amazon.jsii.Kernel.get(this, "releaseTagFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionFile = software.amazon.jsii.Kernel.get(this, "versionFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gitBranch = software.amazon.jsii.Kernel.get(this, "gitBranch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gitPushCommand = software.amazon.jsii.Kernel.get(this, "gitPushCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectChangelogFile = software.amazon.jsii.Kernel.get(this, "projectChangelogFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.changelogFile = java.util.Objects.requireNonNull(builder.changelogFile, "changelogFile is required");
            this.releaseTagFile = java.util.Objects.requireNonNull(builder.releaseTagFile, "releaseTagFile is required");
            this.versionFile = java.util.Objects.requireNonNull(builder.versionFile, "versionFile is required");
            this.gitBranch = builder.gitBranch;
            this.gitPushCommand = builder.gitPushCommand;
            this.projectChangelogFile = builder.projectChangelogFile;
        }

        @Override
        public final java.lang.String getChangelogFile() {
            return this.changelogFile;
        }

        @Override
        public final java.lang.String getReleaseTagFile() {
            return this.releaseTagFile;
        }

        @Override
        public final java.lang.String getVersionFile() {
            return this.versionFile;
        }

        @Override
        public final java.lang.String getGitBranch() {
            return this.gitBranch;
        }

        @Override
        public final java.lang.String getGitPushCommand() {
            return this.gitPushCommand;
        }

        @Override
        public final java.lang.String getProjectChangelogFile() {
            return this.projectChangelogFile;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("changelogFile", om.valueToTree(this.getChangelogFile()));
            data.set("releaseTagFile", om.valueToTree(this.getReleaseTagFile()));
            data.set("versionFile", om.valueToTree(this.getVersionFile()));
            if (this.getGitBranch() != null) {
                data.set("gitBranch", om.valueToTree(this.getGitBranch()));
            }
            if (this.getGitPushCommand() != null) {
                data.set("gitPushCommand", om.valueToTree(this.getGitPushCommand()));
            }
            if (this.getProjectChangelogFile() != null) {
                data.set("projectChangelogFile", om.valueToTree(this.getProjectChangelogFile()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.release.GitPublishOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitPublishOptions.Jsii$Proxy that = (GitPublishOptions.Jsii$Proxy) o;

            if (!changelogFile.equals(that.changelogFile)) return false;
            if (!releaseTagFile.equals(that.releaseTagFile)) return false;
            if (!versionFile.equals(that.versionFile)) return false;
            if (this.gitBranch != null ? !this.gitBranch.equals(that.gitBranch) : that.gitBranch != null) return false;
            if (this.gitPushCommand != null ? !this.gitPushCommand.equals(that.gitPushCommand) : that.gitPushCommand != null) return false;
            return this.projectChangelogFile != null ? this.projectChangelogFile.equals(that.projectChangelogFile) : that.projectChangelogFile == null;
        }

        @Override
        public final int hashCode() {
            int result = this.changelogFile.hashCode();
            result = 31 * result + (this.releaseTagFile.hashCode());
            result = 31 * result + (this.versionFile.hashCode());
            result = 31 * result + (this.gitBranch != null ? this.gitBranch.hashCode() : 0);
            result = 31 * result + (this.gitPushCommand != null ? this.gitPushCommand.hashCode() : 0);
            result = 31 * result + (this.projectChangelogFile != null ? this.projectChangelogFile.hashCode() : 0);
            return result;
        }
    }
}
