/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.DockerComposeBuild;
import io.github.cdklabs.projen.DockerComposePortMappingOptions;
import io.github.cdklabs.projen.DockerComposeServiceDescription;
import io.github.cdklabs.projen.DockerComposeServicePort;
import io.github.cdklabs.projen.IDockerComposeNetworkBinding;
import io.github.cdklabs.projen.IDockerComposeServiceName;
import io.github.cdklabs.projen.IDockerComposeVolumeBinding;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.DockerComposeService")
public class DockerComposeService
extends JsiiObject
implements IDockerComposeServiceName {
    protected DockerComposeService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerComposeService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DockerComposeService(@NotNull String serviceName, @NotNull DockerComposeServiceDescription serviceDescription) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(serviceName, "serviceName is required"), Objects.requireNonNull(serviceDescription, "serviceDescription is required")});
    }

    public void addDependsOn(@NotNull IDockerComposeServiceName serviceName) {
        Kernel.call((Object)this, (String)"addDependsOn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(serviceName, "serviceName is required")});
    }

    public void addEnvironment(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void addLabel(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)this, (String)"addLabel", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void addNetwork(@NotNull IDockerComposeNetworkBinding network) {
        Kernel.call((Object)this, (String)"addNetwork", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(network, "network is required")});
    }

    public void addPort(@NotNull Number publishedPort, @NotNull Number targetPort, @Nullable DockerComposePortMappingOptions options) {
        Kernel.call((Object)this, (String)"addPort", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(publishedPort, "publishedPort is required"), Objects.requireNonNull(targetPort, "targetPort is required"), options});
    }

    public void addPort(@NotNull Number publishedPort, @NotNull Number targetPort) {
        Kernel.call((Object)this, (String)"addPort", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(publishedPort, "publishedPort is required"), Objects.requireNonNull(targetPort, "targetPort is required")});
    }

    public void addVolume(@NotNull IDockerComposeVolumeBinding volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @NotNull
    public List<IDockerComposeServiceName> getDependsOn() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dependsOn", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IDockerComposeServiceName.class))));
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"labels", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<IDockerComposeNetworkBinding> getNetworks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"networks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IDockerComposeNetworkBinding.class))));
    }

    @NotNull
    public List<DockerComposeServicePort> getPorts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"ports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(DockerComposeServicePort.class))));
    }

    @Override
    @NotNull
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<IDockerComposeVolumeBinding> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IDockerComposeVolumeBinding.class))));
    }

    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public List<String> getEntrypoint() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"entrypoint", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public String getImage() {
        return (String)Kernel.get((Object)this, (String)"image", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public DockerComposeBuild getImageBuild() {
        return (DockerComposeBuild)Kernel.get((Object)this, (String)"imageBuild", (NativeType)NativeType.forClass(DockerComposeBuild.class));
    }

    @Nullable
    public String getPlatform() {
        return (String)Kernel.get((Object)this, (String)"platform", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DockerComposeService> {
        private final String serviceName;
        private final DockerComposeServiceDescription.Builder serviceDescription;

        public static Builder create(String serviceName) {
            return new Builder(serviceName);
        }

        private Builder(String serviceName) {
            this.serviceName = serviceName;
            this.serviceDescription = new DockerComposeServiceDescription.Builder();
        }

        public Builder command(List<String> command) {
            this.serviceDescription.command(command);
            return this;
        }

        public Builder dependsOn(List<? extends IDockerComposeServiceName> dependsOn) {
            this.serviceDescription.dependsOn(dependsOn);
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.serviceDescription.entrypoint(entrypoint);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.serviceDescription.environment(environment);
            return this;
        }

        public Builder image(String image) {
            this.serviceDescription.image(image);
            return this;
        }

        public Builder imageBuild(DockerComposeBuild imageBuild) {
            this.serviceDescription.imageBuild(imageBuild);
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.serviceDescription.labels(labels);
            return this;
        }

        public Builder networks(List<? extends IDockerComposeNetworkBinding> networks) {
            this.serviceDescription.networks(networks);
            return this;
        }

        public Builder platform(String platform) {
            this.serviceDescription.platform(platform);
            return this;
        }

        public Builder ports(List<? extends DockerComposeServicePort> ports) {
            this.serviceDescription.ports(ports);
            return this;
        }

        public Builder volumes(List<? extends IDockerComposeVolumeBinding> volumes) {
            this.serviceDescription.volumes(volumes);
            return this;
        }

        public DockerComposeService build() {
            return new DockerComposeService(this.serviceName, this.serviceDescription.build());
        }
    }
}

