/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen;

import io.github.cdklabs.projen.;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Dependencies;
import io.github.cdklabs.projen.FileBase;
import io.github.cdklabs.projen.GitAttributesFile;
import io.github.cdklabs.projen.GitOptions;
import io.github.cdklabs.projen.IgnoreFile;
import io.github.cdklabs.projen.IgnoreFileOptions;
import io.github.cdklabs.projen.InitProject;
import io.github.cdklabs.projen.JsonFile;
import io.github.cdklabs.projen.Logger;
import io.github.cdklabs.projen.LoggerOptions;
import io.github.cdklabs.projen.ObjectFile;
import io.github.cdklabs.projen.ProjectBuild;
import io.github.cdklabs.projen.ProjectOptions;
import io.github.cdklabs.projen.ProjenrcJsonOptions;
import io.github.cdklabs.projen.RenovatebotOptions;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.TaskOptions;
import io.github.cdklabs.projen.Tasks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IConstruct;

@Jsii(module=.Module.class, fqn="projen.Project")
public class Project
extends Construct {
    public static final String DEFAULT_TASK = (String)JsiiObject.jsiiStaticGet(Project.class, (String)"DEFAULT_TASK", (NativeType)NativeType.forClass(String.class));

    protected Project(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Project(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Project(@NotNull ProjectOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static Boolean isProject(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Project.class, (String)"isProject", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{x});
    }

    @NotNull
    public static Project of(@NotNull IConstruct construct) {
        return (Project)((Object)JsiiObject.jsiiStaticCall(Project.class, (String)"of", (NativeType)NativeType.forClass(Project.class), (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")}));
    }

    public void addExcludeFromCleanup(String ... globs) {
        Kernel.call((Object)((Object)this), (String)"addExcludeFromCleanup", (NativeType)NativeType.VOID, (Object[])Arrays.stream(globs).toArray(Object[]::new));
    }

    public void addGitIgnore(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addGitIgnore", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addPackageIgnore(@NotNull String _pattern) {
        Kernel.call((Object)((Object)this), (String)"addPackageIgnore", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_pattern, "_pattern is required")});
    }

    @NotNull
    public Task addTask(@NotNull String name, @Nullable TaskOptions props) {
        return (Task)((Object)Kernel.call((Object)((Object)this), (String)"addTask", (NativeType)NativeType.forClass(Task.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), props}));
    }

    @NotNull
    public Task addTask(@NotNull String name) {
        return (Task)((Object)Kernel.call((Object)((Object)this), (String)"addTask", (NativeType)NativeType.forClass(Task.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")}));
    }

    @Deprecated
    public void addTip(@NotNull String message) {
        Kernel.call((Object)((Object)this), (String)"addTip", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void annotateGenerated(@NotNull String _glob) {
        Kernel.call((Object)((Object)this), (String)"annotateGenerated", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_glob, "_glob is required")});
    }

    public void postSynthesize() {
        Kernel.call((Object)((Object)this), (String)"postSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void preSynthesize() {
        Kernel.call((Object)((Object)this), (String)"preSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Nullable
    public Task removeTask(@NotNull String name) {
        return (Task)((Object)Kernel.call((Object)((Object)this), (String)"removeTask", (NativeType)NativeType.forClass(Task.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")}));
    }

    @NotNull
    public String runTaskCommand(@NotNull Task task) {
        return (String)Kernel.call((Object)((Object)this), (String)"runTaskCommand", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(task, "task is required")});
    }

    public void synth() {
        Kernel.call((Object)((Object)this), (String)"synth", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Nullable
    public FileBase tryFindFile(@NotNull String filePath) {
        return (FileBase)((Object)Kernel.call((Object)((Object)this), (String)"tryFindFile", (NativeType)NativeType.forClass(FileBase.class), (Object[])new Object[]{Objects.requireNonNull(filePath, "filePath is required")}));
    }

    @Deprecated
    @Nullable
    public JsonFile tryFindJsonFile(@NotNull String filePath) {
        return (JsonFile)((Object)Kernel.call((Object)((Object)this), (String)"tryFindJsonFile", (NativeType)NativeType.forClass(JsonFile.class), (Object[])new Object[]{Objects.requireNonNull(filePath, "filePath is required")}));
    }

    @Nullable
    public ObjectFile tryFindObjectFile(@NotNull String filePath) {
        return (ObjectFile)((Object)Kernel.call((Object)((Object)this), (String)"tryFindObjectFile", (NativeType)NativeType.forClass(ObjectFile.class), (Object[])new Object[]{Objects.requireNonNull(filePath, "filePath is required")}));
    }

    @Nullable
    public FileBase tryRemoveFile(@NotNull String filePath) {
        return (FileBase)((Object)Kernel.call((Object)((Object)this), (String)"tryRemoveFile", (NativeType)NativeType.forClass(FileBase.class), (Object[])new Object[]{Objects.requireNonNull(filePath, "filePath is required")}));
    }

    @NotNull
    public Task getBuildTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"buildTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public Boolean getCommitGenerated() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"commitGenerated", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Task getCompileTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"compileTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public List<Component> getComponents() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"components", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Component.class))));
    }

    @NotNull
    public Dependencies getDeps() {
        return (Dependencies)((Object)Kernel.get((Object)((Object)this), (String)"deps", (NativeType)NativeType.forClass(Dependencies.class)));
    }

    @NotNull
    public Boolean getEjected() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"ejected", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<FileBase> getFiles() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"files", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(FileBase.class))));
    }

    @NotNull
    public GitAttributesFile getGitattributes() {
        return (GitAttributesFile)((Object)Kernel.get((Object)((Object)this), (String)"gitattributes", (NativeType)NativeType.forClass(GitAttributesFile.class)));
    }

    @NotNull
    public IgnoreFile getGitignore() {
        return (IgnoreFile)((Object)Kernel.get((Object)((Object)this), (String)"gitignore", (NativeType)NativeType.forClass(IgnoreFile.class)));
    }

    @NotNull
    public Logger getLogger() {
        return (Logger)((Object)Kernel.get((Object)((Object)this), (String)"logger", (NativeType)NativeType.forClass(Logger.class)));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getOutdir() {
        return (String)Kernel.get((Object)((Object)this), (String)"outdir", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Task getPackageTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"packageTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public Task getPostCompileTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"postCompileTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public Task getPreCompileTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"preCompileTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public ProjectBuild getProjectBuild() {
        return (ProjectBuild)((Object)Kernel.get((Object)((Object)this), (String)"projectBuild", (NativeType)NativeType.forClass(ProjectBuild.class)));
    }

    @NotNull
    public String getProjenCommand() {
        return (String)Kernel.get((Object)((Object)this), (String)"projenCommand", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Project getRoot() {
        return (Project)((Object)Kernel.get((Object)((Object)this), (String)"root", (NativeType)NativeType.forClass(Project.class)));
    }

    @NotNull
    public List<Project> getSubprojects() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"subprojects", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Project.class))));
    }

    @NotNull
    public Tasks getTasks() {
        return (Tasks)((Object)Kernel.get((Object)((Object)this), (String)"tasks", (NativeType)NativeType.forClass(Tasks.class)));
    }

    @NotNull
    public Task getTestTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"testTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @Nullable
    public Task getDefaultTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"defaultTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @Nullable
    public InitProject getInitProject() {
        return (InitProject)Kernel.get((Object)((Object)this), (String)"initProject", (NativeType)NativeType.forClass(InitProject.class));
    }

    @Nullable
    public Project getParent() {
        return (Project)((Object)Kernel.get((Object)((Object)this), (String)"parent", (NativeType)NativeType.forClass(Project.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Project> {
        private final ProjectOptions.Builder options = new ProjectOptions.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder name(String name) {
            this.options.name(name);
            return this;
        }

        public Builder commitGenerated(Boolean commitGenerated) {
            this.options.commitGenerated(commitGenerated);
            return this;
        }

        public Builder gitIgnoreOptions(IgnoreFileOptions gitIgnoreOptions) {
            this.options.gitIgnoreOptions(gitIgnoreOptions);
            return this;
        }

        public Builder gitOptions(GitOptions gitOptions) {
            this.options.gitOptions(gitOptions);
            return this;
        }

        public Builder logging(LoggerOptions logging) {
            this.options.logging(logging);
            return this;
        }

        public Builder outdir(String outdir) {
            this.options.outdir(outdir);
            return this;
        }

        public Builder parent(Project parent) {
            this.options.parent(parent);
            return this;
        }

        public Builder projenCommand(String projenCommand) {
            this.options.projenCommand(projenCommand);
            return this;
        }

        public Builder projenrcJson(Boolean projenrcJson) {
            this.options.projenrcJson(projenrcJson);
            return this;
        }

        public Builder projenrcJsonOptions(ProjenrcJsonOptions projenrcJsonOptions) {
            this.options.projenrcJsonOptions(projenrcJsonOptions);
            return this;
        }

        public Builder renovatebot(Boolean renovatebot) {
            this.options.renovatebot(renovatebot);
            return this;
        }

        public Builder renovatebotOptions(RenovatebotOptions renovatebotOptions) {
            this.options.renovatebotOptions(renovatebotOptions);
            return this;
        }

        public Project build() {
            return new Project(this.options.build());
        }
    }
}

