/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.github;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.GroupRunnerOptions;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.github.CheckoutWith;
import io.github.cdklabs.projen.github.GitIdentity;
import io.github.cdklabs.projen.github.TaskWorkflowJobOptions;
import io.github.cdklabs.projen.github.workflows.ContainerOptions;
import io.github.cdklabs.projen.github.workflows.JobDefaults;
import io.github.cdklabs.projen.github.workflows.JobPermissions;
import io.github.cdklabs.projen.github.workflows.JobStep;
import io.github.cdklabs.projen.github.workflows.JobStepOutput;
import io.github.cdklabs.projen.github.workflows.JobStrategy;
import io.github.cdklabs.projen.github.workflows.Tools;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.IConstruct;

@Jsii(module=$Module.class, fqn="projen.github.TaskWorkflowJob")
public class TaskWorkflowJob
extends Component {
    protected TaskWorkflowJob(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskWorkflowJob(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TaskWorkflowJob(@NotNull IConstruct scope, @NotNull Task task, @NotNull TaskWorkflowJobOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(task, "task is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public JobPermissions getPermissions() {
        return (JobPermissions)Kernel.get((Object)((Object)this), (String)"permissions", (NativeType)NativeType.forClass(JobPermissions.class));
    }

    @NotNull
    public List<JobStep> getSteps() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"steps", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(JobStep.class))));
    }

    @Nullable
    public Object getConcurrency() {
        return Kernel.get((Object)((Object)this), (String)"concurrency", (NativeType)NativeType.forClass(Object.class));
    }

    @Nullable
    public ContainerOptions getContainer() {
        return (ContainerOptions)Kernel.get((Object)((Object)this), (String)"container", (NativeType)NativeType.forClass(ContainerOptions.class));
    }

    @Nullable
    public Boolean getContinueOnError() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"continueOnError", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public JobDefaults getDefaults() {
        return (JobDefaults)Kernel.get((Object)((Object)this), (String)"defaults", (NativeType)NativeType.forClass(JobDefaults.class));
    }

    @Nullable
    public Map<String, String> getEnv() {
        return Optional.ofNullable((Map)Kernel.get((Object)((Object)this), (String)"env", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public Object getEnvironment() {
        return Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.forClass(Object.class));
    }

    @Nullable
    public String getIfValue() {
        return (String)Kernel.get((Object)((Object)this), (String)"if", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public List<String> getNeeds() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"needs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public Map<String, JobStepOutput> getOutputs() {
        return Optional.ofNullable((Map)Kernel.get((Object)((Object)this), (String)"outputs", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(JobStepOutput.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public List<String> getRunsOn() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"runsOn", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public GroupRunnerOptions getRunsOnGroup() {
        return (GroupRunnerOptions)Kernel.get((Object)((Object)this), (String)"runsOnGroup", (NativeType)NativeType.forClass(GroupRunnerOptions.class));
    }

    @Nullable
    public Map<String, ContainerOptions> getServices() {
        return Optional.ofNullable((Map)Kernel.get((Object)((Object)this), (String)"services", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(ContainerOptions.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public JobStrategy getStrategy() {
        return (JobStrategy)Kernel.get((Object)((Object)this), (String)"strategy", (NativeType)NativeType.forClass(JobStrategy.class));
    }

    @Nullable
    public Number getTimeoutMinutes() {
        return (Number)Kernel.get((Object)((Object)this), (String)"timeoutMinutes", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public Tools getTools() {
        return (Tools)Kernel.get((Object)((Object)this), (String)"tools", (NativeType)NativeType.forClass(Tools.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TaskWorkflowJob> {
        private final IConstruct scope;
        private final Task task;
        private final TaskWorkflowJobOptions.Builder options;

        public static Builder create(IConstruct scope, Task task) {
            return new Builder(scope, task);
        }

        private Builder(IConstruct scope, Task task) {
            this.scope = scope;
            this.task = task;
            this.options = new TaskWorkflowJobOptions.Builder();
        }

        public Builder permissions(JobPermissions permissions) {
            this.options.permissions(permissions);
            return this;
        }

        public Builder artifactsDirectory(String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        public Builder checkoutWith(CheckoutWith checkoutWith) {
            this.options.checkoutWith(checkoutWith);
            return this;
        }

        public Builder condition(String condition) {
            this.options.condition(condition);
            return this;
        }

        public Builder container(ContainerOptions container) {
            this.options.container(container);
            return this;
        }

        public Builder downloadLfs(Boolean downloadLfs) {
            this.options.downloadLfs(downloadLfs);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.options.env(env);
            return this;
        }

        public Builder gitIdentity(GitIdentity gitIdentity) {
            this.options.gitIdentity(gitIdentity);
            return this;
        }

        public Builder jobDefaults(JobDefaults jobDefaults) {
            this.options.jobDefaults(jobDefaults);
            return this;
        }

        public Builder outputs(Map<String, ? extends JobStepOutput> outputs) {
            this.options.outputs(outputs);
            return this;
        }

        public Builder postBuildSteps(List<? extends JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        public Builder preBuildSteps(List<? extends JobStep> preBuildSteps) {
            this.options.preBuildSteps(preBuildSteps);
            return this;
        }

        public Builder preCheckoutSteps(List<? extends JobStep> preCheckoutSteps) {
            this.options.preCheckoutSteps(preCheckoutSteps);
            return this;
        }

        public Builder runsOn(List<String> runsOn) {
            this.options.runsOn(runsOn);
            return this;
        }

        public Builder runsOnGroup(GroupRunnerOptions runsOnGroup) {
            this.options.runsOnGroup(runsOnGroup);
            return this;
        }

        public TaskWorkflowJob build() {
            return new TaskWorkflowJob(this.scope, this.task, this.options.build());
        }
    }
}

