/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.javascript;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.JsonFile;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.javascript.CodeArtifactOptions;
import io.github.cdklabs.projen.javascript.NodePackageManager;
import io.github.cdklabs.projen.javascript.NodePackageOptions;
import io.github.cdklabs.projen.javascript.NpmAccess;
import io.github.cdklabs.projen.javascript.PeerDependencyOptions;
import io.github.cdklabs.projen.javascript.ScopedPackagesOptions;
import io.github.cdklabs.projen.javascript.YarnBerryOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.javascript.NodePackage")
public class NodePackage
extends Component {
    protected NodePackage(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NodePackage(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NodePackage(@NotNull Project project, @Nullable NodePackageOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public NodePackage(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    public void addBin(@NotNull Map<String, String> bins) {
        Kernel.call((Object)((Object)this), (String)"addBin", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(bins, "bins is required")});
    }

    public void addBundledDeps(String ... deps) {
        Kernel.call((Object)((Object)this), (String)"addBundledDeps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(deps).toArray(Object[]::new));
    }

    public void addDeps(String ... deps) {
        Kernel.call((Object)((Object)this), (String)"addDeps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(deps).toArray(Object[]::new));
    }

    public void addDevDeps(String ... deps) {
        Kernel.call((Object)((Object)this), (String)"addDevDeps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(deps).toArray(Object[]::new));
    }

    public void addEngine(@NotNull String engine, @NotNull String version) {
        Kernel.call((Object)((Object)this), (String)"addEngine", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(engine, "engine is required"), Objects.requireNonNull(version, "version is required")});
    }

    public void addField(@NotNull String name, @NotNull Object value) {
        Kernel.call((Object)((Object)this), (String)"addField", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), value});
    }

    public void addKeywords(String ... keywords) {
        Kernel.call((Object)((Object)this), (String)"addKeywords", (NativeType)NativeType.VOID, (Object[])Arrays.stream(keywords).toArray(Object[]::new));
    }

    public void addPackageResolutions(String ... resolutions) {
        Kernel.call((Object)((Object)this), (String)"addPackageResolutions", (NativeType)NativeType.VOID, (Object[])Arrays.stream(resolutions).toArray(Object[]::new));
    }

    public void addPeerDeps(String ... deps) {
        Kernel.call((Object)((Object)this), (String)"addPeerDeps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(deps).toArray(Object[]::new));
    }

    public void addVersion(@NotNull String version) {
        Kernel.call((Object)((Object)this), (String)"addVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(version, "version is required")});
    }

    @Deprecated
    @NotNull
    public Boolean hasScript(@NotNull String name) {
        return (Boolean)Kernel.call((Object)((Object)this), (String)"hasScript", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    @Override
    public void postSynthesize() {
        Kernel.call((Object)((Object)this), (String)"postSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void removeScript(@NotNull String name) {
        Kernel.call((Object)((Object)this), (String)"removeScript", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    public void setScript(@NotNull String name, @NotNull String command) {
        Kernel.call((Object)((Object)this), (String)"setScript", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(command, "command is required")});
    }

    @Override
    public void synthesize() {
        Kernel.call((Object)((Object)this), (String)"synthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Nullable
    public String tryResolveDependencyVersion(@NotNull String dependencyName) {
        return (String)Kernel.call((Object)((Object)this), (String)"tryResolveDependencyVersion", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(dependencyName, "dependencyName is required")});
    }

    @NotNull
    public Boolean getAllowLibraryDependencies() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"allowLibraryDependencies", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public String getEntrypoint() {
        return (String)Kernel.get((Object)((Object)this), (String)"entrypoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public JsonFile getFile() {
        return (JsonFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(JsonFile.class)));
    }

    @NotNull
    public String getInstallAndUpdateLockfileCommand() {
        return (String)Kernel.get((Object)((Object)this), (String)"installAndUpdateLockfileCommand", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Task getInstallCiTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"installCiTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public String getInstallCommand() {
        return (String)Kernel.get((Object)((Object)this), (String)"installCommand", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Task getInstallTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"installTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public String getLockFile() {
        return (String)Kernel.get((Object)((Object)this), (String)"lockFile", (NativeType)NativeType.forClass(String.class));
    }

    @Deprecated
    @NotNull
    public Object getManifest() {
        return Kernel.get((Object)((Object)this), (String)"manifest", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public NpmAccess getNpmAccess() {
        return (NpmAccess)((Object)Kernel.get((Object)((Object)this), (String)"npmAccess", (NativeType)NativeType.forClass(NpmAccess.class)));
    }

    @NotNull
    public String getNpmRegistry() {
        return (String)Kernel.get((Object)((Object)this), (String)"npmRegistry", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getNpmRegistryUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"npmRegistryUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public NodePackageManager getPackageManager() {
        return (NodePackageManager)((Object)Kernel.get((Object)((Object)this), (String)"packageManager", (NativeType)NativeType.forClass(NodePackageManager.class)));
    }

    @NotNull
    public String getPackageName() {
        return (String)Kernel.get((Object)((Object)this), (String)"packageName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getProjenCommand() {
        return (String)Kernel.get((Object)((Object)this), (String)"projenCommand", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public CodeArtifactOptions getCodeArtifactOptions() {
        return (CodeArtifactOptions)Kernel.get((Object)((Object)this), (String)"codeArtifactOptions", (NativeType)NativeType.forClass(CodeArtifactOptions.class));
    }

    @Nullable
    public String getLicense() {
        return (String)Kernel.get((Object)((Object)this), (String)"license", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getMaxNodeVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"maxNodeVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getMinNodeVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"minNodeVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getNpmTokenSecret() {
        return (String)Kernel.get((Object)((Object)this), (String)"npmTokenSecret", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getPnpmVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"pnpmVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public List<ScopedPackagesOptions> getScopedPackagesOptions() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"scopedPackagesOptions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ScopedPackagesOptions.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NodePackage> {
        private final Project project;
        private NodePackageOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder allowLibraryDependencies(Boolean allowLibraryDependencies) {
            this.options().allowLibraryDependencies(allowLibraryDependencies);
            return this;
        }

        public Builder authorEmail(String authorEmail) {
            this.options().authorEmail(authorEmail);
            return this;
        }

        public Builder authorName(String authorName) {
            this.options().authorName(authorName);
            return this;
        }

        public Builder authorOrganization(Boolean authorOrganization) {
            this.options().authorOrganization(authorOrganization);
            return this;
        }

        public Builder authorUrl(String authorUrl) {
            this.options().authorUrl(authorUrl);
            return this;
        }

        public Builder autoDetectBin(Boolean autoDetectBin) {
            this.options().autoDetectBin(autoDetectBin);
            return this;
        }

        public Builder bin(Map<String, String> bin) {
            this.options().bin(bin);
            return this;
        }

        public Builder bugsEmail(String bugsEmail) {
            this.options().bugsEmail(bugsEmail);
            return this;
        }

        public Builder bugsUrl(String bugsUrl) {
            this.options().bugsUrl(bugsUrl);
            return this;
        }

        public Builder bundledDeps(List<String> bundledDeps) {
            this.options().bundledDeps(bundledDeps);
            return this;
        }

        public Builder codeArtifactOptions(CodeArtifactOptions codeArtifactOptions) {
            this.options().codeArtifactOptions(codeArtifactOptions);
            return this;
        }

        public Builder deps(List<String> deps) {
            this.options().deps(deps);
            return this;
        }

        public Builder description(String description) {
            this.options().description(description);
            return this;
        }

        public Builder devDeps(List<String> devDeps) {
            this.options().devDeps(devDeps);
            return this;
        }

        public Builder entrypoint(String entrypoint) {
            this.options().entrypoint(entrypoint);
            return this;
        }

        public Builder homepage(String homepage) {
            this.options().homepage(homepage);
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.options().keywords(keywords);
            return this;
        }

        public Builder license(String license) {
            this.options().license(license);
            return this;
        }

        public Builder licensed(Boolean licensed) {
            this.options().licensed(licensed);
            return this;
        }

        public Builder maxNodeVersion(String maxNodeVersion) {
            this.options().maxNodeVersion(maxNodeVersion);
            return this;
        }

        public Builder minNodeVersion(String minNodeVersion) {
            this.options().minNodeVersion(minNodeVersion);
            return this;
        }

        public Builder npmAccess(NpmAccess npmAccess) {
            this.options().npmAccess(npmAccess);
            return this;
        }

        @Deprecated
        public Builder npmRegistry(String npmRegistry) {
            this.options().npmRegistry(npmRegistry);
            return this;
        }

        public Builder npmRegistryUrl(String npmRegistryUrl) {
            this.options().npmRegistryUrl(npmRegistryUrl);
            return this;
        }

        public Builder npmTokenSecret(String npmTokenSecret) {
            this.options().npmTokenSecret(npmTokenSecret);
            return this;
        }

        public Builder packageManager(NodePackageManager packageManager) {
            this.options().packageManager(packageManager);
            return this;
        }

        public Builder packageName(String packageName) {
            this.options().packageName(packageName);
            return this;
        }

        public Builder peerDependencyOptions(PeerDependencyOptions peerDependencyOptions) {
            this.options().peerDependencyOptions(peerDependencyOptions);
            return this;
        }

        public Builder peerDeps(List<String> peerDeps) {
            this.options().peerDeps(peerDeps);
            return this;
        }

        public Builder pnpmVersion(String pnpmVersion) {
            this.options().pnpmVersion(pnpmVersion);
            return this;
        }

        public Builder repository(String repository) {
            this.options().repository(repository);
            return this;
        }

        public Builder repositoryDirectory(String repositoryDirectory) {
            this.options().repositoryDirectory(repositoryDirectory);
            return this;
        }

        public Builder scopedPackagesOptions(List<? extends ScopedPackagesOptions> scopedPackagesOptions) {
            this.options().scopedPackagesOptions(scopedPackagesOptions);
            return this;
        }

        @Deprecated
        public Builder scripts(Map<String, String> scripts) {
            this.options().scripts(scripts);
            return this;
        }

        public Builder stability(String stability) {
            this.options().stability(stability);
            return this;
        }

        public Builder yarnBerryOptions(YarnBerryOptions yarnBerryOptions) {
            this.options().yarnBerryOptions(yarnBerryOptions);
            return this;
        }

        public NodePackage build() {
            return new NodePackage(this.project, this.options != null ? this.options.build() : null);
        }

        private NodePackageOptions.Builder options() {
            if (this.options == null) {
                this.options = new NodePackageOptions.Builder();
            }
            return this.options;
        }
    }
}

