package io.github.cdklabs.projen.build;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.307Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.build.BuildWorkflow")
public class BuildWorkflow extends io.github.cdklabs.projen.Component {

    protected BuildWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BuildWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BuildWorkflow(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.build.BuildWorkflowOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds another job to the build workflow which is executed after the build job succeeded.
     * <p>
     * Jobs are executed <em>only</em> if the build did NOT self mutate. If the build
     * self-mutate, the branch will either be updated or the build will fail (in
     * forks), so there is no point in executing the post-build job.
     * <p>
     * @param id The id of the new job. This parameter is required.
     * @param job The job specification. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildJob(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.workflows.Job job) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildJob", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(job, "job is required") });
    }

    /**
     * (experimental) Run a sequence of commands as a job within the build workflow which is executed after the build job succeeded.
     * <p>
     * Jobs are executed <em>only</em> if the build did NOT self mutate. If the build
     * self-mutate, the branch will either be updated or the build will fail (in
     * forks), so there is no point in executing the post-build job.
     * <p>
     * @param id This parameter is required.
     * @param commands This parameter is required.
     * @param options Specify tools and other options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildJobCommands(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> commands, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.build.AddPostBuildJobCommandsOptions options) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildJobCommands", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(commands, "commands is required"), options });
    }

    /**
     * (experimental) Run a sequence of commands as a job within the build workflow which is executed after the build job succeeded.
     * <p>
     * Jobs are executed <em>only</em> if the build did NOT self mutate. If the build
     * self-mutate, the branch will either be updated or the build will fail (in
     * forks), so there is no point in executing the post-build job.
     * <p>
     * @param id This parameter is required.
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildJobCommands(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> commands) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildJobCommands", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(commands, "commands is required") });
    }

    /**
     * (experimental) Run a task as a job within the build workflow which is executed after the build job succeeded.
     * <p>
     * The job will have access to build artifacts and will install project
     * dependencies in order to be able to run any commands used in the tasks.
     * <p>
     * Jobs are executed <em>only</em> if the build did NOT self mutate. If the build
     * self-mutate, the branch will either be updated or the build will fail (in
     * forks), so there is no point in executing the post-build job.
     * <p>
     * @param task This parameter is required.
     * @param options Specify tools and other options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildJobTask(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task task, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.build.AddPostBuildJobTaskOptions options) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildJobTask", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(task, "task is required"), options });
    }

    /**
     * (experimental) Run a task as a job within the build workflow which is executed after the build job succeeded.
     * <p>
     * The job will have access to build artifacts and will install project
     * dependencies in order to be able to run any commands used in the tasks.
     * <p>
     * Jobs are executed <em>only</em> if the build did NOT self mutate. If the build
     * self-mutate, the branch will either be updated or the build will fail (in
     * forks), so there is no point in executing the post-build job.
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildJobTask(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task task) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildJobTask", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * (experimental) Adds steps that are executed after the build.
     * <p>
     * @param steps The job steps. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPostBuildSteps(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.workflows.JobStep... steps) {
        software.amazon.jsii.Kernel.call(this, "addPostBuildSteps", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Returns a list of job IDs that are part of the build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getBuildJobIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "buildJobIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Name of generated github workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.build.BuildWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.build.BuildWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private final io.github.cdklabs.projen.build.BuildWorkflowOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
            this.options = new io.github.cdklabs.projen.build.BuildWorkflowOptions.Builder();
        }

        /**
         * (experimental) A name of a directory that includes build artifacts.
         * <p>
         * @return {@code this}
         * @param artifactsDirectory A name of a directory that includes build artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactsDirectory(final java.lang.String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        /**
         * (experimental) The task to execute in order to build the project.
         * <p>
         * @return {@code this}
         * @param buildTask The task to execute in order to build the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildTask(final io.github.cdklabs.projen.Task buildTask) {
            this.options.buildTask(buildTask);
            return this;
        }

        /**
         * (experimental) The container image to use for builds.
         * <p>
         * Default: - the default workflow container
         * <p>
         * @return {@code this}
         * @param containerImage The container image to use for builds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerImage(final java.lang.String containerImage) {
            this.options.containerImage(containerImage);
            return this;
        }

        /**
         * (experimental) Build environment variables.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param env Build environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(final java.util.Map<java.lang.String, java.lang.String> env) {
            this.options.env(env);
            return this;
        }

        /**
         * (experimental) Git identity to use for the workflow.
         * <p>
         * Default: - default identity
         * <p>
         * @return {@code this}
         * @param gitIdentity Git identity to use for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitIdentity(final io.github.cdklabs.projen.github.GitIdentity gitIdentity) {
            this.options.gitIdentity(gitIdentity);
            return this;
        }

        /**
         * (experimental) Automatically update files modified during builds to pull-request branches.
         * <p>
         * This means that any files synthesized by projen or e.g. test snapshots will
         * always be up-to-date before a PR is merged.
         * <p>
         * Implies that PR builds do not have anti-tamper checks.
         * <p>
         * This is enabled by default only if <code>githubTokenSecret</code> is set. Otherwise it
         * is disabled, which implies that file changes that happen during build will
         * not be pushed back to the branch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param mutableBuild Automatically update files modified during builds to pull-request branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutableBuild(final java.lang.Boolean mutableBuild) {
            this.options.mutableBuild(mutableBuild);
            return this;
        }

        /**
         * (experimental) Name of the buildfile (e.g. "build" becomes "build.yml").
         * <p>
         * Default: "build"
         * <p>
         * @return {@code this}
         * @param name Name of the buildfile (e.g. "build" becomes "build.yml"). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * (experimental) Permissions granted to the build job To limit job permissions for <code>contents</code>, the desired permissions have to be explicitly set, e.g.: <code>{ contents: JobPermission.NONE }</code>.
         * <p>
         * Default: `{ contents: JobPermission.WRITE }`
         * <p>
         * @return {@code this}
         * @param permissions Permissions granted to the build job To limit job permissions for <code>contents</code>, the desired permissions have to be explicitly set, e.g.: <code>{ contents: JobPermission.NONE }</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder permissions(final io.github.cdklabs.projen.github.workflows.JobPermissions permissions) {
            this.options.permissions(permissions);
            return this;
        }

        /**
         * (experimental) Steps to execute after build.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param postBuildSteps Steps to execute after build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder postBuildSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        /**
         * (experimental) Steps to execute before the build.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param preBuildSteps Steps to execute before the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preBuildSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> preBuildSteps) {
            this.options.preBuildSteps(preBuildSteps);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param runsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOn(final java.util.List<java.lang.String> runsOn) {
            this.options.runsOn(runsOn);
            return this;
        }

        /**
         * (experimental) Github Runner Group selection options.
         * <p>
         * @return {@code this}
         * @param runsOnGroup Github Runner Group selection options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOnGroup(final io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup) {
            this.options.runsOnGroup(runsOnGroup);
            return this;
        }

        /**
         * (experimental) Build workflow triggers.
         * <p>
         * Default: "{ pullRequest: {}, workflowDispatch: {} }"
         * <p>
         * @return {@code this}
         * @param workflowTriggers Build workflow triggers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowTriggers(final io.github.cdklabs.projen.github.workflows.Triggers workflowTriggers) {
            this.options.workflowTriggers(workflowTriggers);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.build.BuildWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.build.BuildWorkflow build() {
            return new io.github.cdklabs.projen.build.BuildWorkflow(
                this.project,
                this.options.build()
            );
        }
    }
}
