package io.github.cdklabs.projen.github;

/**
 * (experimental) Defines dependabot configuration for node projects.
 * <p>
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.443Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.Dependabot")
public class Dependabot extends io.github.cdklabs.projen.Component {

    protected Dependabot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dependabot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param github This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Dependabot(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.DependabotOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required"), options });
    }

    /**
     * @param github This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Dependabot(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required") });
    }

    /**
     * (experimental) Allows a dependency from automatic updates.
     * <p>
     * @param dependencyName Use to allow updates for dependencies with matching names, optionally using <code>*</code> to match zero or more characters. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addAllow(final @org.jetbrains.annotations.NotNull java.lang.String dependencyName) {
        software.amazon.jsii.Kernel.call(this, "addAllow", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependencyName, "dependencyName is required") });
    }

    /**
     * (experimental) Ignores a dependency from automatic updates.
     * <p>
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using <code>*</code> to match zero or more characters. This parameter is required.
     * @param versions Use to ignore specific versions or ranges of versions. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addIgnore(final @org.jetbrains.annotations.NotNull java.lang.String dependencyName, final @org.jetbrains.annotations.NotNull java.lang.String... versions) {
        software.amazon.jsii.Kernel.call(this, "addIgnore", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dependencyName, "dependencyName is required") }), java.util.Arrays.<Object>stream(versions)).toArray(Object[]::new));
    }

    /**
     * (experimental) The raw dependabot configuration.
     * <p>
     * @see <a href="https://docs.github.com/en/github/administering-a-repository/configuration-options-for-dependency-updates">https://docs.github.com/en/github/administering-a-repository/configuration-options-for-dependency-updates</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) Whether or not projen is also upgraded in this config,.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIgnoresProjen() {
        return software.amazon.jsii.Kernel.get(this, "ignoresProjen", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.github.Dependabot}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.github.Dependabot> {
        /**
         * @return a new instance of {@link Builder}.
         * @param github This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.github.GitHub github) {
            return new Builder(github);
        }

        private final io.github.cdklabs.projen.github.GitHub github;
        private io.github.cdklabs.projen.github.DependabotOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.github.GitHub github) {
            this.github = github;
        }

        /**
         * (experimental) https://docs.github.com/en/code-security/dependabot/dependabot-version-updates/configuration-options-for-the-dependabot.yml-file#allow.
         * <p>
         * Use the allow option to customize which dependencies are updated. This
         * applies to both version and security updates.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param allow https://docs.github.com/en/code-security/dependabot/dependabot-version-updates/configuration-options-for-the-dependabot.yml-file#allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allow(final java.util.List<? extends io.github.cdklabs.projen.github.DependabotAllow> allow) {
            this.options().allow(allow);
            return this;
        }

        /**
         * (experimental) Specify individual assignees or teams of assignees for all pull requests raised for a package manager.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param assignees Specify individual assignees or teams of assignees for all pull requests raised for a package manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assignees(final java.util.List<java.lang.String> assignees) {
            this.options().assignees(assignees);
            return this;
        }

        /**
         * (experimental) https://docs.github.com/en/code-security/dependabot/dependabot-version-updates/configuration-options-for-the-dependabot.yml-file#groups.
         * <p>
         * You can create groups to package dependency updates together into a single PR.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param groups https://docs.github.com/en/code-security/dependabot/dependabot-version-updates/configuration-options-for-the-dependabot.yml-file#groups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder groups(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.github.DependabotGroup> groups) {
            this.options().groups(groups);
            return this;
        }

        /**
         * (experimental) You can use the <code>ignore</code> option to customize which dependencies are updated.
         * <p>
         * The ignore option supports the following options.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param ignore You can use the <code>ignore</code> option to customize which dependencies are updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignore(final java.util.List<? extends io.github.cdklabs.projen.github.DependabotIgnore> ignore) {
            this.options().ignore(ignore);
            return this;
        }

        /**
         * (experimental) Ignores updates to <code>projen</code>.
         * <p>
         * This is required since projen updates may cause changes in committed files
         * and anti-tamper checks will fail.
         * <p>
         * Projen upgrades are covered through the <code>ProjenUpgrade</code> class.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param ignoreProjen Ignores updates to <code>projen</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreProjen(final java.lang.Boolean ignoreProjen) {
            this.options().ignoreProjen(ignoreProjen);
            return this;
        }

        /**
         * (experimental) List of labels to apply to the created PR's.
         * <p>
         * @return {@code this}
         * @param labels List of labels to apply to the created PR's. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder labels(final java.util.List<java.lang.String> labels) {
            this.options().labels(labels);
            return this;
        }

        /**
         * (experimental) Sets the maximum of pull requests Dependabot opens for version updates.
         * <p>
         * Dependabot will not open any new requests until some of those open requests
         * are merged or closed.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param openPullRequestsLimit Sets the maximum of pull requests Dependabot opens for version updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openPullRequestsLimit(final java.lang.Number openPullRequestsLimit) {
            this.options().openPullRequestsLimit(openPullRequestsLimit);
            return this;
        }

        /**
         * (experimental) Map of package registries to use.
         * <p>
         * Default: - use public registries
         * <p>
         * @return {@code this}
         * @param registries Map of package registries to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder registries(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.github.DependabotRegistry> registries) {
            this.options().registries(registries);
            return this;
        }

        /**
         * (experimental) Specify individual reviewers or teams of reviewers for all pull requests raised for a package manager.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param reviewers Specify individual reviewers or teams of reviewers for all pull requests raised for a package manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reviewers(final java.util.List<java.lang.String> reviewers) {
            this.options().reviewers(reviewers);
            return this;
        }

        /**
         * (experimental) How often to check for new versions and raise pull requests.
         * <p>
         * Default: ScheduleInterval.DAILY
         * <p>
         * @return {@code this}
         * @param scheduleInterval How often to check for new versions and raise pull requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scheduleInterval(final io.github.cdklabs.projen.github.DependabotScheduleInterval scheduleInterval) {
            this.options().scheduleInterval(scheduleInterval);
            return this;
        }

        /**
         * (experimental) The strategy to use when edits manifest and lock files.
         * <p>
         * Default: VersioningStrategy.LOCKFILE_ONLY The default is to only update the
         * lock file because package.json is controlled by projen and any outside
         * updates will fail the build.
         * <p>
         * @return {@code this}
         * @param versioningStrategy The strategy to use when edits manifest and lock files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versioningStrategy(final io.github.cdklabs.projen.github.VersioningStrategy versioningStrategy) {
            this.options().versioningStrategy(versioningStrategy);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.github.Dependabot}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.github.Dependabot build() {
            return new io.github.cdklabs.projen.github.Dependabot(
                this.github,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.github.DependabotOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.github.DependabotOptions.Builder();
            }
            return this.options;
        }
    }
}
