package io.github.cdklabs.projen.github.workflows;

/**
 * (experimental) Options pertaining to container environments.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.476Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.workflows.ContainerOptions")
@software.amazon.jsii.Jsii.Proxy(ContainerOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ContainerOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Docker image to use as the container to run the action.
     * <p>
     * The value can
     * be the Docker Hub image name or a registry name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getImage();

    /**
     * (experimental) f the image's container registry requires authentication to pull the image, you can use credentials to set a map of the username and password.
     * <p>
     * The credentials are the same values that you would provide to the docker
     * login command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.ContainerCredentials getCredentials() {
        return null;
    }

    /**
     * (experimental) Sets a map of environment variables in the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * (experimental) Additional Docker container resource options.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/commandline/create/#options">https://docs.docker.com/engine/reference/commandline/create/#options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptions() {
        return null;
    }

    /**
     * (experimental) Sets an array of ports to expose on the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getPorts() {
        return null;
    }

    /**
     * (experimental) Sets an array of volumes for the container to use.
     * <p>
     * You can use volumes to
     * share data between services or other steps in a job. You can specify
     * named Docker volumes, anonymous Docker volumes, or bind mounts on the
     * host.
     * <p>
     * To specify a volume, you specify the source and destination path:
     * <code>&lt;source&gt;:&lt;destinationPath&gt;</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerOptions> {
        java.lang.String image;
        io.github.cdklabs.projen.github.workflows.ContainerCredentials credentials;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.util.List<java.lang.String> options;
        java.util.List<java.lang.Number> ports;
        java.util.List<java.lang.String> volumes;

        /**
         * Sets the value of {@link ContainerOptions#getImage}
         * @param image The Docker image to use as the container to run the action. This parameter is required.
         *              The value can
         *              be the Docker Hub image name or a registry name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(java.lang.String image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOptions#getCredentials}
         * @param credentials f the image's container registry requires authentication to pull the image, you can use credentials to set a map of the username and password.
         *                    The credentials are the same values that you would provide to the docker
         *                    login command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder credentials(io.github.cdklabs.projen.github.workflows.ContainerCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOptions#getEnv}
         * @param env Sets a map of environment variables in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOptions#getOptions}
         * @param options Additional Docker container resource options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder options(java.util.List<java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOptions#getPorts}
         * @param ports Sets an array of ports to expose on the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder ports(java.util.List<? extends java.lang.Number> ports) {
            this.ports = (java.util.List<java.lang.Number>)ports;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOptions#getVolumes}
         * @param volumes Sets an array of volumes for the container to use.
         *                You can use volumes to
         *                share data between services or other steps in a job. You can specify
         *                named Docker volumes, anonymous Docker volumes, or bind mounts on the
         *                host.
         *                <p>
         *                To specify a volume, you specify the source and destination path:
         *                <code>&lt;source&gt;:&lt;destinationPath&gt;</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumes(java.util.List<java.lang.String> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ContainerOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerOptions {
        private final java.lang.String image;
        private final io.github.cdklabs.projen.github.workflows.ContainerCredentials credentials;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.util.List<java.lang.String> options;
        private final java.util.List<java.lang.Number> ports;
        private final java.util.List<java.lang.String> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.ContainerCredentials.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.credentials = builder.credentials;
            this.env = builder.env;
            this.options = builder.options;
            this.ports = (java.util.List<java.lang.Number>)builder.ports;
            this.volumes = builder.volumes;
        }

        @Override
        public final java.lang.String getImage() {
            return this.image;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.ContainerCredentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.util.List<java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public final java.util.List<java.lang.Number> getPorts() {
            return this.ports;
        }

        @Override
        public final java.util.List<java.lang.String> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPorts() != null) {
                data.set("ports", om.valueToTree(this.getPorts()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.github.workflows.ContainerOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerOptions.Jsii$Proxy that = (ContainerOptions.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
