package io.github.cdklabs.projen.github.workflows;

/**
 * (experimental) A GitHub Workflow job definition.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.477Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.workflows.Job")
@software.amazon.jsii.Jsii.Proxy(Job.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Job extends software.amazon.jsii.JsiiSerializable, io.github.cdklabs.projen.github.workflows.CommonJobDefinition {

    /**
     * (experimental) A job contains a sequence of tasks called steps.
     * <p>
     * Steps can run commands,
     * run setup tasks, or run an action in your repository, a public repository,
     * or an action published in a Docker registry. Not all steps run actions,
     * but all actions run as a step. Each step runs in its own process in the
     * runner environment and has access to the workspace and filesystem.
     * Because steps run in their own process, changes to environment variables
     * are not preserved between steps. GitHub provides built-in steps to set up
     * and complete a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getSteps();

    /**
     * (experimental) A container to run any steps in a job that don't already specify a container.
     * <p>
     * If you have steps that use both script and container actions,
     * the container actions will run as sibling containers on the same network
     * with the same volume mounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.ContainerOptions getContainer() {
        return null;
    }

    /**
     * (experimental) Prevents a workflow run from failing when a job fails.
     * <p>
     * Set to true to
     * allow a workflow run to pass when this job fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContinueOnError() {
        return null;
    }

    /**
     * (experimental) A map of default settings that will apply to all steps in the job.
     * <p>
     * You
     * can also set default settings for the entire workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.JobDefaults getDefaults() {
        return null;
    }

    /**
     * (experimental) A map of environment variables that are available to all steps in the job.
     * <p>
     * You can also set environment variables for the entire workflow or an
     * individual step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * (experimental) The environment that the job references.
     * <p>
     * All environment protection rules
     * must pass before a job referencing the environment is sent to a runner.
     * <p>
     * @see <a href="https://docs.github.com/en/actions/reference/environments">https://docs.github.com/en/actions/reference/environments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return null;
    }

    /**
     * (experimental) A map of outputs for a job.
     * <p>
     * Job outputs are available to all downstream
     * jobs that depend on this job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput> getOutputs() {
        return null;
    }

    /**
     * (experimental) The type of machine to run the job on.
     * <p>
     * The machine can be either a
     * GitHub-hosted runner or a self-hosted runner.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ["ubuntu-latest"]
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRunsOn() {
        return null;
    }

    /**
     * (experimental) Github Runner Group selection options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.GroupRunnerOptions getRunsOnGroup() {
        return null;
    }

    /**
     * (experimental) Used to host service containers for a job in a workflow.
     * <p>
     * Service
     * containers are useful for creating databases or cache services like Redis.
     * The runner automatically creates a Docker network and manages the life
     * cycle of the service containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions> getServices() {
        return null;
    }

    /**
     * (experimental) The maximum number of minutes to let a job run before GitHub automatically cancels it.
     * <p>
     * Default: 360
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
        return null;
    }

    /**
     * (experimental) Tools required for this job.
     * <p>
     * Translates into <code>actions/setup-xxx</code> steps at
     * the beginning of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.Tools getTools() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Job}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Job}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Job> {
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> steps;
        io.github.cdklabs.projen.github.workflows.ContainerOptions container;
        java.lang.Boolean continueOnError;
        io.github.cdklabs.projen.github.workflows.JobDefaults defaults;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.lang.Object environment;
        java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput> outputs;
        java.util.List<java.lang.String> runsOn;
        io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup;
        java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions> services;
        java.lang.Number timeoutMinutes;
        io.github.cdklabs.projen.github.workflows.Tools tools;
        io.github.cdklabs.projen.github.workflows.JobPermissions permissions;
        java.lang.Object concurrency;
        java.lang.String ifValue;
        java.lang.String name;
        java.util.List<java.lang.String> needs;
        io.github.cdklabs.projen.github.workflows.JobStrategy strategy;

        /**
         * Sets the value of {@link Job#getSteps}
         * @param steps A job contains a sequence of tasks called steps. This parameter is required.
         *              Steps can run commands,
         *              run setup tasks, or run an action in your repository, a public repository,
         *              or an action published in a Docker registry. Not all steps run actions,
         *              but all actions run as a step. Each step runs in its own process in the
         *              runner environment and has access to the workspace and filesystem.
         *              Because steps run in their own process, changes to environment variables
         *              are not preserved between steps. GitHub provides built-in steps to set up
         *              and complete a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder steps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> steps) {
            this.steps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)steps;
            return this;
        }

        /**
         * Sets the value of {@link Job#getContainer}
         * @param container A container to run any steps in a job that don't already specify a container.
         *                  If you have steps that use both script and container actions,
         *                  the container actions will run as sibling containers on the same network
         *                  with the same volume mounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder container(io.github.cdklabs.projen.github.workflows.ContainerOptions container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link Job#getContinueOnError}
         * @param continueOnError Prevents a workflow run from failing when a job fails.
         *                        Set to true to
         *                        allow a workflow run to pass when this job fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder continueOnError(java.lang.Boolean continueOnError) {
            this.continueOnError = continueOnError;
            return this;
        }

        /**
         * Sets the value of {@link Job#getDefaults}
         * @param defaults A map of default settings that will apply to all steps in the job.
         *                 You
         *                 can also set default settings for the entire workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaults(io.github.cdklabs.projen.github.workflows.JobDefaults defaults) {
            this.defaults = defaults;
            return this;
        }

        /**
         * Sets the value of {@link Job#getEnv}
         * @param env A map of environment variables that are available to all steps in the job.
         *            You can also set environment variables for the entire workflow or an
         *            individual step.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link Job#getEnvironment}
         * @param environment The environment that the job references.
         *                    All environment protection rules
         *                    must pass before a job referencing the environment is sent to a runner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.lang.Object environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link Job#getOutputs}
         * @param outputs A map of outputs for a job.
         *                Job outputs are available to all downstream
         *                jobs that depend on this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder outputs(java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.github.workflows.JobStepOutput> outputs) {
            this.outputs = (java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput>)outputs;
            return this;
        }

        /**
         * Sets the value of {@link Job#getRunsOn}
         * @param runsOn The type of machine to run the job on.
         *               The machine can be either a
         *               GitHub-hosted runner or a self-hosted runner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOn(java.util.List<java.lang.String> runsOn) {
            this.runsOn = runsOn;
            return this;
        }

        /**
         * Sets the value of {@link Job#getRunsOnGroup}
         * @param runsOnGroup Github Runner Group selection options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOnGroup(io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup) {
            this.runsOnGroup = runsOnGroup;
            return this;
        }

        /**
         * Sets the value of {@link Job#getServices}
         * @param services Used to host service containers for a job in a workflow.
         *                 Service
         *                 containers are useful for creating databases or cache services like Redis.
         *                 The runner automatically creates a Docker network and manages the life
         *                 cycle of the service containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder services(java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.github.workflows.ContainerOptions> services) {
            this.services = (java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions>)services;
            return this;
        }

        /**
         * Sets the value of {@link Job#getTimeoutMinutes}
         * @param timeoutMinutes The maximum number of minutes to let a job run before GitHub automatically cancels it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        /**
         * Sets the value of {@link Job#getTools}
         * @param tools Tools required for this job.
         *              Translates into <code>actions/setup-xxx</code> steps at
         *              the beginning of the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tools(io.github.cdklabs.projen.github.workflows.Tools tools) {
            this.tools = tools;
            return this;
        }

        /**
         * Sets the value of {@link Job#getPermissions}
         * @param permissions You can modify the default permissions granted to the GITHUB_TOKEN, adding or removing access as required, so that you only allow the minimum required access. This parameter is required.
         *                    Use <code>{ contents: READ }</code> if your job only needs to clone code.
         *                    <p>
         *                    This is intentionally a required field since it is required in order to
         *                    allow workflows to run in GitHub repositories with restricted default
         *                    access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder permissions(io.github.cdklabs.projen.github.workflows.JobPermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link Job#getConcurrency}
         * @param concurrency Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time.
         *                    A concurrency group can be any
         *                    string or expression. The expression can use any context except for the
         *                    secrets context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder concurrency(java.lang.Object concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        /**
         * Sets the value of {@link Job#getIfValue}
         * @param ifValue You can use the if conditional to prevent a job from running unless a condition is met.
         *                You can use any supported context and expression to
         *                create a conditional.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ifValue(java.lang.String ifValue) {
            this.ifValue = ifValue;
            return this;
        }

        /**
         * Sets the value of {@link Job#getName}
         * @param name The name of the job displayed on GitHub.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Job#getNeeds}
         * @param needs Identifies any jobs that must complete successfully before this job will run.
         *              It can be a string or array of strings. If a job fails, all jobs
         *              that need it are skipped unless the jobs use a conditional expression
         *              that causes the job to continue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder needs(java.util.List<java.lang.String> needs) {
            this.needs = needs;
            return this;
        }

        /**
         * Sets the value of {@link Job#getStrategy}
         * @param strategy A strategy creates a build matrix for your jobs.
         *                 You can define different
         *                 variations to run each job in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder strategy(io.github.cdklabs.projen.github.workflows.JobStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Job}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Job build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Job}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Job {
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> steps;
        private final io.github.cdklabs.projen.github.workflows.ContainerOptions container;
        private final java.lang.Boolean continueOnError;
        private final io.github.cdklabs.projen.github.workflows.JobDefaults defaults;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.lang.Object environment;
        private final java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput> outputs;
        private final java.util.List<java.lang.String> runsOn;
        private final io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup;
        private final java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions> services;
        private final java.lang.Number timeoutMinutes;
        private final io.github.cdklabs.projen.github.workflows.Tools tools;
        private final io.github.cdklabs.projen.github.workflows.JobPermissions permissions;
        private final java.lang.Object concurrency;
        private final java.lang.String ifValue;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> needs;
        private final io.github.cdklabs.projen.github.workflows.JobStrategy strategy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.ContainerOptions.class));
            this.continueOnError = software.amazon.jsii.Kernel.get(this, "continueOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaults = software.amazon.jsii.Kernel.get(this, "defaults", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobDefaults.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStepOutput.class)));
            this.runsOn = software.amazon.jsii.Kernel.get(this, "runsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.runsOnGroup = software.amazon.jsii.Kernel.get(this, "runsOnGroup", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.GroupRunnerOptions.class));
            this.services = software.amazon.jsii.Kernel.get(this, "services", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.ContainerOptions.class)));
            this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tools = software.amazon.jsii.Kernel.get(this, "tools", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.Tools.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobPermissions.class));
            this.concurrency = software.amazon.jsii.Kernel.get(this, "concurrency", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ifValue = software.amazon.jsii.Kernel.get(this, "if", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.needs = software.amazon.jsii.Kernel.get(this, "needs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.strategy = software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStrategy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.steps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)java.util.Objects.requireNonNull(builder.steps, "steps is required");
            this.container = builder.container;
            this.continueOnError = builder.continueOnError;
            this.defaults = builder.defaults;
            this.env = builder.env;
            this.environment = builder.environment;
            this.outputs = (java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput>)builder.outputs;
            this.runsOn = builder.runsOn;
            this.runsOnGroup = builder.runsOnGroup;
            this.services = (java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions>)builder.services;
            this.timeoutMinutes = builder.timeoutMinutes;
            this.tools = builder.tools;
            this.permissions = java.util.Objects.requireNonNull(builder.permissions, "permissions is required");
            this.concurrency = builder.concurrency;
            this.ifValue = builder.ifValue;
            this.name = builder.name;
            this.needs = builder.needs;
            this.strategy = builder.strategy;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getSteps() {
            return this.steps;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.ContainerOptions getContainer() {
            return this.container;
        }

        @Override
        public final java.lang.Boolean getContinueOnError() {
            return this.continueOnError;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.JobDefaults getDefaults() {
            return this.defaults;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.Object getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.JobStepOutput> getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.util.List<java.lang.String> getRunsOn() {
            return this.runsOn;
        }

        @Override
        public final io.github.cdklabs.projen.GroupRunnerOptions getRunsOnGroup() {
            return this.runsOnGroup;
        }

        @Override
        public final java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.ContainerOptions> getServices() {
            return this.services;
        }

        @Override
        public final java.lang.Number getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.Tools getTools() {
            return this.tools;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.JobPermissions getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.lang.Object getConcurrency() {
            return this.concurrency;
        }

        @Override
        public final java.lang.String getIfValue() {
            return this.ifValue;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getNeeds() {
            return this.needs;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.JobStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("steps", om.valueToTree(this.getSteps()));
            if (this.getContainer() != null) {
                data.set("container", om.valueToTree(this.getContainer()));
            }
            if (this.getContinueOnError() != null) {
                data.set("continueOnError", om.valueToTree(this.getContinueOnError()));
            }
            if (this.getDefaults() != null) {
                data.set("defaults", om.valueToTree(this.getDefaults()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getRunsOn() != null) {
                data.set("runsOn", om.valueToTree(this.getRunsOn()));
            }
            if (this.getRunsOnGroup() != null) {
                data.set("runsOnGroup", om.valueToTree(this.getRunsOnGroup()));
            }
            if (this.getServices() != null) {
                data.set("services", om.valueToTree(this.getServices()));
            }
            if (this.getTimeoutMinutes() != null) {
                data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
            }
            if (this.getTools() != null) {
                data.set("tools", om.valueToTree(this.getTools()));
            }
            data.set("permissions", om.valueToTree(this.getPermissions()));
            if (this.getConcurrency() != null) {
                data.set("concurrency", om.valueToTree(this.getConcurrency()));
            }
            if (this.getIfValue() != null) {
                data.set("if", om.valueToTree(this.getIfValue()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNeeds() != null) {
                data.set("needs", om.valueToTree(this.getNeeds()));
            }
            if (this.getStrategy() != null) {
                data.set("strategy", om.valueToTree(this.getStrategy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.github.workflows.Job"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Job.Jsii$Proxy that = (Job.Jsii$Proxy) o;

            if (!steps.equals(that.steps)) return false;
            if (this.container != null ? !this.container.equals(that.container) : that.container != null) return false;
            if (this.continueOnError != null ? !this.continueOnError.equals(that.continueOnError) : that.continueOnError != null) return false;
            if (this.defaults != null ? !this.defaults.equals(that.defaults) : that.defaults != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.runsOn != null ? !this.runsOn.equals(that.runsOn) : that.runsOn != null) return false;
            if (this.runsOnGroup != null ? !this.runsOnGroup.equals(that.runsOnGroup) : that.runsOnGroup != null) return false;
            if (this.services != null ? !this.services.equals(that.services) : that.services != null) return false;
            if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
            if (this.tools != null ? !this.tools.equals(that.tools) : that.tools != null) return false;
            if (!permissions.equals(that.permissions)) return false;
            if (this.concurrency != null ? !this.concurrency.equals(that.concurrency) : that.concurrency != null) return false;
            if (this.ifValue != null ? !this.ifValue.equals(that.ifValue) : that.ifValue != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.needs != null ? !this.needs.equals(that.needs) : that.needs != null) return false;
            return this.strategy != null ? this.strategy.equals(that.strategy) : that.strategy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.steps.hashCode();
            result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
            result = 31 * result + (this.continueOnError != null ? this.continueOnError.hashCode() : 0);
            result = 31 * result + (this.defaults != null ? this.defaults.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.runsOn != null ? this.runsOn.hashCode() : 0);
            result = 31 * result + (this.runsOnGroup != null ? this.runsOnGroup.hashCode() : 0);
            result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
            result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
            result = 31 * result + (this.tools != null ? this.tools.hashCode() : 0);
            result = 31 * result + (this.permissions.hashCode());
            result = 31 * result + (this.concurrency != null ? this.concurrency.hashCode() : 0);
            result = 31 * result + (this.ifValue != null ? this.ifValue.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.needs != null ? this.needs.hashCode() : 0);
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            return result;
        }
    }
}
