package io.github.cdklabs.projen.gitlab;

/**
 * (experimental) CI for GitLab.
 * <p>
 * A CI is a configurable automated process made up of one or more stages/jobs.
 * <p>
 * @see <a href="https://docs.gitlab.com/ee/ci/yaml/">https://docs.gitlab.com/ee/ci/yaml/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.496Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.gitlab.CiConfiguration")
public class CiConfiguration extends io.github.cdklabs.projen.Component {

    protected CiConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CiConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CiConfiguration(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.CiConfigurationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @param project This parameter is required.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CiConfiguration(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Adds up to 4 default caches configuration to the CI configuration.
     * <p>
     * @param caches Caches to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addDefaultCaches(final @org.jetbrains.annotations.NotNull java.util.List<io.github.cdklabs.projen.gitlab.Cache> caches) {
        software.amazon.jsii.Kernel.call(this, "addDefaultCaches", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(caches, "caches is required") });
    }

    /**
     * (experimental) Add a globally defined variable to the CI configuration.
     * <p>
     * @param variables The variables to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addGlobalVariables(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> variables) {
        software.amazon.jsii.Kernel.call(this, "addGlobalVariables", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(variables, "variables is required") });
    }

    /**
     * (experimental) Add additional yml/yaml files to the CI includes.
     * <p>
     * @param includes The includes to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addIncludes(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.gitlab.Include... includes) {
        software.amazon.jsii.Kernel.call(this, "addIncludes", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(includes).toArray(Object[]::new));
    }

    /**
     * (experimental) Add jobs and their stages to the CI configuration.
     * <p>
     * @param jobs Jobs to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addJobs(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, io.github.cdklabs.projen.gitlab.Job> jobs) {
        software.amazon.jsii.Kernel.call(this, "addJobs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(jobs, "jobs is required") });
    }

    /**
     * (experimental) Add additional services.
     * <p>
     * @param services The services to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addServices(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.gitlab.Service... services) {
        software.amazon.jsii.Kernel.call(this, "addServices", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(services).toArray(Object[]::new));
    }

    /**
     * (experimental) Add stages to the CI configuration if not already present.
     * <p>
     * @param stages stages to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStages(final @org.jetbrains.annotations.NotNull java.lang.String... stages) {
        software.amazon.jsii.Kernel.call(this, "addStages", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(stages).toArray(Object[]::new));
    }

    /**
     * (experimental) Defines default scripts that should run <em>after</em> all jobs.
     * <p>
     * Can be overriden by the job level <code>afterScript</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDefaultAfterScript() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "defaultAfterScript", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Defines default scripts that should run <em>before</em> all jobs.
     * <p>
     * Can be overriden by the job level <code>afterScript</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDefaultBeforeScript() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "defaultBeforeScript", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Used to select a specific runner from the list of all runners that are available for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDefaultTags() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "defaultTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The workflow YAML file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.YamlFile getFile() {
        return software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.YamlFile.class));
    }

    /**
     * (experimental) The jobs in the CI configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, io.github.cdklabs.projen.gitlab.Job> getJobs() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "jobs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Job.class))));
    }

    /**
     * (experimental) The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Path to CI file generated by the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Groups jobs into stages.
     * <p>
     * All jobs in one stage must complete before next stage is
     * executed. Defaults to ['build', 'test', 'deploy'].
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Global variables that are passed to jobs.
     * <p>
     * If the job already has that variable defined, the job-level variable takes precedence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getVariables() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * (experimental) Default list of files and directories that should be attached to the job if it succeeds.
     * <p>
     * Artifacts are sent to Gitlab where they can be downloaded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Artifacts getDefaultArtifacts() {
        return software.amazon.jsii.Kernel.get(this, "defaultArtifacts", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Artifacts.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.gitlab.Cache> getDefaultCache() {
        return java.util.Optional.ofNullable((java.util.List<io.github.cdklabs.projen.gitlab.Cache>)(software.amazon.jsii.Kernel.get(this, "defaultCache", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Cache.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) Specifies the default docker image to use globally for all jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Image getDefaultImage() {
        return software.amazon.jsii.Kernel.get(this, "defaultImage", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Image.class));
    }

    /**
     * (experimental) The default behavior for whether a job should be canceled when a newer pipeline starts before the job completes (Default: false).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getDefaultInterruptible() {
        return software.amazon.jsii.Kernel.get(this, "defaultInterruptible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) How many times a job is retried if it fails.
     * <p>
     * If not defined, defaults to 0 and jobs do not retry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Retry getDefaultRetry() {
        return software.amazon.jsii.Kernel.get(this, "defaultRetry", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Retry.class));
    }

    /**
     * (experimental) A default timeout job written in natural language (Ex.
     * <p>
     * one hour, 3600 seconds, 60 minutes).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultTimeout() {
        return software.amazon.jsii.Kernel.get(this, "defaultTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A special job used to upload static sites to Gitlab pages.
     * <p>
     * Requires a <code>public/</code> directory
     * with <code>artifacts.path</code> pointing to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Job getPages() {
        return software.amazon.jsii.Kernel.get(this, "pages", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Job.class));
    }

    /**
     * (experimental) Used to control pipeline behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.gitlab.Workflow getWorkflow() {
        return software.amazon.jsii.Kernel.get(this, "workflow", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.Workflow.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.gitlab.CiConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.gitlab.CiConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project, final java.lang.String name) {
            return new Builder(project, name);
        }

        private final io.github.cdklabs.projen.Project project;
        private final java.lang.String name;
        private io.github.cdklabs.projen.gitlab.CiConfigurationOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project, final java.lang.String name) {
            this.project = project;
            this.name = name;
        }

        /**
         * (experimental) Default settings for the CI Configuration.
         * <p>
         * Jobs that do not define one or more of the listed keywords use the value defined in the default section.
         * <p>
         * @return {@code this}
         * @param defaultValue Default settings for the CI Configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultValue(final io.github.cdklabs.projen.gitlab.Default defaultValue) {
            this.options().defaultValue(defaultValue);
            return this;
        }

        /**
         * (experimental) An initial set of jobs to add to the configuration.
         * <p>
         * @return {@code this}
         * @param jobs An initial set of jobs to add to the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobs(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.gitlab.Job> jobs) {
            this.options().jobs(jobs);
            return this;
        }

        /**
         * (experimental) A special job used to upload static sites to Gitlab pages.
         * <p>
         * Requires a <code>public/</code> directory
         * with <code>artifacts.path</code> pointing to it.
         * <p>
         * @return {@code this}
         * @param pages A special job used to upload static sites to Gitlab pages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pages(final io.github.cdklabs.projen.gitlab.Job pages) {
            this.options().pages(pages);
            return this;
        }

        /**
         * (experimental) Groups jobs into stages.
         * <p>
         * All jobs in one stage must complete before next stage is
         * executed. If no stages are specified. Defaults to ['build', 'test', 'deploy'].
         * <p>
         * @return {@code this}
         * @param stages Groups jobs into stages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stages(final java.util.List<java.lang.String> stages) {
            this.options().stages(stages);
            return this;
        }

        /**
         * (experimental) Global variables that are passed to jobs.
         * <p>
         * If the job already has that variable defined, the job-level variable takes precedence.
         * <p>
         * @return {@code this}
         * @param variables Global variables that are passed to jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variables(final java.util.Map<java.lang.String, ? extends java.lang.Object> variables) {
            this.options().variables(variables);
            return this;
        }

        /**
         * (experimental) Used to control pipeline behavior.
         * <p>
         * @return {@code this}
         * @param workflow Used to control pipeline behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflow(final io.github.cdklabs.projen.gitlab.Workflow workflow) {
            this.options().workflow(workflow);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.gitlab.CiConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.gitlab.CiConfiguration build() {
            return new io.github.cdklabs.projen.gitlab.CiConfiguration(
                this.project,
                this.name,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.gitlab.CiConfigurationOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.gitlab.CiConfigurationOptions.Builder();
            }
            return this.options;
        }
    }
}
