package io.github.cdklabs.projen.gitlab;

/**
 * (experimental) Specifies the docker image to use for the job or globally for all jobs.
 * <p>
 * Job configuration
 * takes precedence over global setting. Requires a certain kind of Gitlab runner executor.
 * <p>
 * @see <a href="https://docs.gitlab.com/ee/ci/yaml/#image">https://docs.gitlab.com/ee/ci/yaml/#image</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.500Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.gitlab.Image")
@software.amazon.jsii.Jsii.Proxy(Image.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Image extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Full name of the image that should be used.
     * <p>
     * It should contain the Registry part if needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (experimental) Command or script that should be executed as the container's entrypoint.
     * <p>
     * It will be translated to Docker's --entrypoint option while creating the container. The syntax is similar to Dockerfile's ENTRYPOINT directive, where each shell token is a separate string in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getEntrypoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Image}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Image}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Image> {
        java.lang.String name;
        java.util.List<java.lang.Object> entrypoint;

        /**
         * Sets the value of {@link Image#getName}
         * @param name Full name of the image that should be used. This parameter is required.
         *             It should contain the Registry part if needed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Image#getEntrypoint}
         * @param entrypoint Command or script that should be executed as the container's entrypoint.
         *                   It will be translated to Docker's --entrypoint option while creating the container. The syntax is similar to Dockerfile's ENTRYPOINT directive, where each shell token is a separate string in the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder entrypoint(java.util.List<? extends java.lang.Object> entrypoint) {
            this.entrypoint = (java.util.List<java.lang.Object>)entrypoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Image}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Image build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Image}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Image {
        private final java.lang.String name;
        private final java.util.List<java.lang.Object> entrypoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.entrypoint = (java.util.List<java.lang.Object>)builder.entrypoint;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.Object> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.gitlab.Image"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Image.Jsii$Proxy that = (Image.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.entrypoint != null ? this.entrypoint.equals(that.entrypoint) : that.entrypoint == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            return result;
        }
    }
}
