package io.github.cdklabs.projen.gitlab;

/**
 * (experimental) Used to specify an additional Docker image to run scripts in.
 * <p>
 * The service image is linked to the image specified in the
 * <p>
 * @see <a href="https://docs.gitlab.com/ee/ci/yaml/#services">https://docs.gitlab.com/ee/ci/yaml/#services</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.516Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.gitlab.Service")
@software.amazon.jsii.Jsii.Proxy(Service.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Service extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Full name of the image that should be used.
     * <p>
     * It should contain the Registry part if needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (experimental) Additional alias that can be used to access the service from the job's container.
     * <p>
     * Read Accessing the services for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * (experimental) Command or script that should be used as the container's command.
     * <p>
     * It will be translated to arguments passed to Docker after the image's name. The syntax is similar to Dockerfile's CMD directive, where each shell token is a separate string in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * (experimental) Command or script that should be executed as the container's entrypoint.
     * <p>
     * It will be translated to Docker's --entrypoint option while creating the container. The syntax is similar to Dockerfile's ENTRYPOINT directive, where each shell token is a separate string in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntrypoint() {
        return null;
    }

    /**
     * (experimental) The pull policy that the runner uses to fetch the Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy> getPullPolicy() {
        return null;
    }

    /**
     * (experimental) Additional environment variables that are passed exclusively to the service..
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Service}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Service}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Service> {
        java.lang.String name;
        java.lang.String alias;
        java.util.List<java.lang.String> command;
        java.util.List<java.lang.String> entrypoint;
        java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy> pullPolicy;
        java.util.Map<java.lang.String, java.lang.String> variables;

        /**
         * Sets the value of {@link Service#getName}
         * @param name Full name of the image that should be used. This parameter is required.
         *             It should contain the Registry part if needed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Service#getAlias}
         * @param alias Additional alias that can be used to access the service from the job's container.
         *              Read Accessing the services for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link Service#getCommand}
         * @param command Command or script that should be used as the container's command.
         *                It will be translated to arguments passed to Docker after the image's name. The syntax is similar to Dockerfile's CMD directive, where each shell token is a separate string in the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link Service#getEntrypoint}
         * @param entrypoint Command or script that should be executed as the container's entrypoint.
         *                   It will be translated to Docker's --entrypoint option while creating the container. The syntax is similar to Dockerfile's ENTRYPOINT directive, where each shell token is a separate string in the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link Service#getPullPolicy}
         * @param pullPolicy The pull policy that the runner uses to fetch the Docker image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder pullPolicy(java.util.List<? extends io.github.cdklabs.projen.gitlab.PullPolicy> pullPolicy) {
            this.pullPolicy = (java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy>)pullPolicy;
            return this;
        }

        /**
         * Sets the value of {@link Service#getVariables}
         * @param variables Additional environment variables that are passed exclusively to the service..
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Service}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Service build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Service}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Service {
        private final java.lang.String name;
        private final java.lang.String alias;
        private final java.util.List<java.lang.String> command;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy> pullPolicy;
        private final java.util.Map<java.lang.String, java.lang.String> variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pullPolicy = software.amazon.jsii.Kernel.get(this, "pullPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.gitlab.PullPolicy.class)));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.alias = builder.alias;
            this.command = builder.command;
            this.entrypoint = builder.entrypoint;
            this.pullPolicy = (java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy>)builder.pullPolicy;
            this.variables = builder.variables;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.gitlab.PullPolicy> getPullPolicy() {
            return this.pullPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getVariables() {
            return this.variables;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getPullPolicy() != null) {
                data.set("pullPolicy", om.valueToTree(this.getPullPolicy()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.gitlab.Service"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Service.Jsii$Proxy that = (Service.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.pullPolicy != null ? !this.pullPolicy.equals(that.pullPolicy) : that.pullPolicy != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.pullPolicy != null ? this.pullPolicy.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
