package io.github.cdklabs.projen.javascript;

/**
 * (experimental) Adds support for bundling JavaScript applications and dependencies into a single file.
 * <p>
 * In the future, this will also supports bundling websites.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.542Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.javascript.Bundler")
public class Bundler extends io.github.cdklabs.projen.Component {

    protected Bundler(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bundler(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Creates a <code>Bundler</code>.
     * <p>
     * @param project This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Bundler(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.BundlerOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), options });
    }

    /**
     * (experimental) Creates a <code>Bundler</code>.
     * <p>
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Bundler(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Returns the <code>Bundler</code> instance associated with a project or <code>undefined</code> if there is no Bundler.
     * <p>
     * @return A bundler
     * @param project The project. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.Bundler of(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.javascript.Bundler.class, "of", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.Bundler.class), new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Adds a task to the project which bundles a specific entrypoint and all of its dependencies into a single javascript output file.
     * <p>
     * @param entrypoint The relative path of the artifact within the project. This parameter is required.
     * @param options Bundling options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.javascript.Bundle addBundle(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.javascript.AddBundleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addBundle", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.Bundle.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Root bundle directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBundledir() {
        return software.amazon.jsii.Kernel.get(this, "bundledir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Gets or creates the singleton "bundle" task of the project.
     * <p>
     * If the project doesn't have a "bundle" task, it will be created and spawned
     * during the pre-compile phase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task getBundleTask() {
        return software.amazon.jsii.Kernel.get(this, "bundleTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class));
    }

    /**
     * (experimental) The semantic version requirement for <code>esbuild</code> (if defined).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getEsbuildVersion() {
        return software.amazon.jsii.Kernel.get(this, "esbuildVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.javascript.Bundler}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.javascript.Bundler> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private io.github.cdklabs.projen.javascript.BundlerOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
        }

        /**
         * (deprecated) Install the <code>bundle</code> command as a pre-compile phase.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated Use <code>runBundleTask</code> instead.
         * @param addToPreCompile Install the <code>bundle</code> command as a pre-compile phase. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder addToPreCompile(final java.lang.Boolean addToPreCompile) {
            this.options().addToPreCompile(addToPreCompile);
            return this;
        }

        /**
         * (experimental) Output directory for all bundles.
         * <p>
         * Default: "assets"
         * <p>
         * @return {@code this}
         * @param assetsDir Output directory for all bundles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetsDir(final java.lang.String assetsDir) {
            this.options().assetsDir(assetsDir);
            return this;
        }

        /**
         * (experimental) The semantic version requirement for <code>esbuild</code>.
         * <p>
         * Default: - no specific version (implies latest)
         * <p>
         * @return {@code this}
         * @param esbuildVersion The semantic version requirement for <code>esbuild</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder esbuildVersion(final java.lang.String esbuildVersion) {
            this.options().esbuildVersion(esbuildVersion);
            return this;
        }

        /**
         * (experimental) Map of file extensions (without dot) and loaders to use for this file type.
         * <p>
         * Loaders are appended to the esbuild command by <code>--loader:.extension=loader</code>
         * <p>
         * @return {@code this}
         * @param loaders Map of file extensions (without dot) and loaders to use for this file type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loaders(final java.util.Map<java.lang.String, java.lang.String> loaders) {
            this.options().loaders(loaders);
            return this;
        }

        /**
         * (experimental) Choose which phase (if any) to add the <code>bundle</code> command to.
         * <p>
         * Note: If using <code>addBundle()</code> with the <code>bundleCompiledResults</code>, this option
         * must be set to <code>RunBundleTask.POST_COMPILE</code> or <code>RunBundleTask.MANUAL</code>.
         * <p>
         * Default: RunBundleTask.PRE_COMPILE
         * <p>
         * @return {@code this}
         * @see <a href="AddBundleOptions.bundleCompiledResults *">AddBundleOptions.bundleCompiledResults *</a>
         * @param runBundleTask Choose which phase (if any) to add the <code>bundle</code> command to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runBundleTask(final io.github.cdklabs.projen.javascript.RunBundleTask runBundleTask) {
            this.options().runBundleTask(runBundleTask);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.javascript.Bundler}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.javascript.Bundler build() {
            return new io.github.cdklabs.projen.javascript.Bundler(
                this.project,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.javascript.BundlerOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.javascript.BundlerOptions.Builder();
            }
            return this.options;
        }
    }
}
