package io.github.cdklabs.projen.javascript;

/**
 * (experimental) Installs the following npm scripts:.
 * <p>
 * <ul>
 * <li><code>test</code>, intended for testing locally and in CI. Will update snapshots unless <code>updateSnapshot: UpdateSnapshot: NEVER</code> is set.</li>
 * <li><code>test:watch</code>, intended for automatically rerunning tests when files change.</li>
 * <li><code>test:update</code>, intended for testing locally and updating snapshots to match the latest unit under test. Only available when <code>updateSnapshot: UpdateSnapshot: NEVER</code>.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-27T17:08:55.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.javascript.Jest")
public class Jest extends io.github.cdklabs.projen.Component {

    protected Jest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Jest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Jest(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.javascript.NodeProject project, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.JestOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), options });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Jest(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.javascript.NodeProject project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Returns the singleton Jest component of a project or undefined if there is none.
     * <p>
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.Jest of(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.javascript.Jest.class, "of", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.Jest.class), new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * @param pattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addIgnorePattern(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        software.amazon.jsii.Kernel.call(this, "addIgnorePattern", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * (experimental) Adds one or more moduleNameMapper entries to Jest's configuration.
     * <p>
     * Will overwrite if the same key is used as a pre-existing one.
     * <p>
     * @param moduleNameMapperAdditions <ul><li>A map from regular expressions to module names or to arrays of module names that allow to stub out resources, like images or styles with a single module.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addModuleNameMappers(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> moduleNameMapperAdditions) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(moduleNameMapperAdditions.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("moduleNameMapperAdditions").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(moduleNameMapperAdditions.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_957536: moduleNameMapperAdditions.entrySet()) {
                final java.lang.Object __val_957536 = __item_957536.getValue();
                if (
                     !(__val_957536 instanceof java.lang.String)
                    && !(__val_957536 instanceof java.util.List)
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("moduleNameMapperAdditions").append(".get(\"").append((__item_957536.getKey())).append("\")")
                            .append(" to be one of: java.lang.String, java.util.List<java.lang.String>; received ")
                            .append(__val_957536.getClass()).toString());
                }
                if (__val_957536 instanceof java.util.List) {
                    @SuppressWarnings("unchecked")
                    final java.util.List<java.lang.String> __cast_e54f08 = (java.util.List<java.lang.String>)__val_957536;
                    for (int __idx_e7d804 = 0; __idx_e7d804 < __cast_e54f08.size(); __idx_e7d804++) {
                        final java.lang.String __val_e7d804 = __cast_e54f08.get(__idx_e7d804);
                    }
                }
            }
        }
        software.amazon.jsii.Kernel.call(this, "addModuleNameMappers", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(moduleNameMapperAdditions, "moduleNameMapperAdditions is required") });
    }

    /**
     * (experimental) Adds one or more modulePaths to Jest's configuration.
     * <p>
     * @param modulePaths <ul><li>An array of absolute paths to additional locations to search when resolving modules   *.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addModulePaths(final @org.jetbrains.annotations.NotNull java.lang.String... modulePaths) {
        software.amazon.jsii.Kernel.call(this, "addModulePaths", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(modulePaths).toArray(Object[]::new));
    }

    /**
     * @param reporter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addReporter(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.javascript.JestReporter reporter) {
        software.amazon.jsii.Kernel.call(this, "addReporter", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(reporter, "reporter is required") });
    }

    /**
     * (experimental) Adds one or more roots to Jest's configuration.
     * <p>
     * @param roots <ul><li>A list of paths to directories that Jest should use to search for files in.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addRoots(final @org.jetbrains.annotations.NotNull java.lang.String... roots) {
        software.amazon.jsii.Kernel.call(this, "addRoots", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(roots).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds a a setup file to Jest's setupFiles configuration.
     * <p>
     * @param file File path to setup file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSetupFile(final @org.jetbrains.annotations.NotNull java.lang.String file) {
        software.amazon.jsii.Kernel.call(this, "addSetupFile", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(file, "file is required") });
    }

    /**
     * (experimental) Adds a a setup file to Jest's setupFilesAfterEnv configuration.
     * <p>
     * @param file File path to setup file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSetupFileAfterEnv(final @org.jetbrains.annotations.NotNull java.lang.String file) {
        software.amazon.jsii.Kernel.call(this, "addSetupFileAfterEnv", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(file, "file is required") });
    }

    /**
     * @param file This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSnapshotResolver(final @org.jetbrains.annotations.NotNull java.lang.String file) {
        software.amazon.jsii.Kernel.call(this, "addSnapshotResolver", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(file, "file is required") });
    }

    /**
     * (experimental) Adds a test match pattern.
     * <p>
     * @param pattern glob pattern to match for tests. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addTestMatch(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        software.amazon.jsii.Kernel.call(this, "addTestMatch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * (experimental) Adds a watch ignore pattern.
     * <p>
     * @param pattern The pattern (regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addWatchIgnorePattern(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        software.amazon.jsii.Kernel.call(this, "addWatchIgnorePattern", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * (experimental) Escape hatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) Jest version, including <code>&#64;</code> symbol, like <code>&#64;^29</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJestVersion() {
        return software.amazon.jsii.Kernel.get(this, "jestVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Jest config file.
     * <p>
     * <code>undefined</code> if settings are written to <code>package.json</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.JsonFile getFile() {
        return software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonFile.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.javascript.Jest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.javascript.Jest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.javascript.NodeProject project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.javascript.NodeProject project;
        private io.github.cdklabs.projen.javascript.JestOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.javascript.NodeProject project) {
            this.project = project;
        }

        /**
         * (experimental) Path to JSON config file for Jest.
         * <p>
         * Default: - No separate config file, jest settings are stored in package.json
         * <p>
         * @return {@code this}
         * @param configFilePath Path to JSON config file for Jest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configFilePath(final java.lang.String configFilePath) {
            this.options().configFilePath(configFilePath);
            return this;
        }

        /**
         * (deprecated) Collect coverage.
         * <p>
         * Deprecated
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated use jestConfig.collectCoverage
         * @param coverage Collect coverage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder coverage(final java.lang.Boolean coverage) {
            this.options().coverage(coverage);
            return this;
        }

        /**
         * (experimental) Include the <code>text</code> coverage reporter, which means that coverage summary is printed at the end of the jest execution.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param coverageText Include the <code>text</code> coverage reporter, which means that coverage summary is printed at the end of the jest execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder coverageText(final java.lang.Boolean coverageText) {
            this.options().coverageText(coverageText);
            return this;
        }

        /**
         * (experimental) Additional options to pass to the Jest CLI invocation.
         * <p>
         * Default: - no extra options
         * <p>
         * @return {@code this}
         * @param extraCliOptions Additional options to pass to the Jest CLI invocation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraCliOptions(final java.util.List<java.lang.String> extraCliOptions) {
            this.options().extraCliOptions(extraCliOptions);
            return this;
        }

        /**
         * (deprecated) Defines <code>testPathIgnorePatterns</code> and <code>coveragePathIgnorePatterns</code>.
         * <p>
         * Default: ["/node_modules/"]
         * <p>
         * @return {@code this}
         * @deprecated use jestConfig.coveragePathIgnorePatterns or jestConfig.testPathIgnorePatterns respectively
         * @param ignorePatterns Defines <code>testPathIgnorePatterns</code> and <code>coveragePathIgnorePatterns</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ignorePatterns(final java.util.List<java.lang.String> ignorePatterns) {
            this.options().ignorePatterns(ignorePatterns);
            return this;
        }

        /**
         * (experimental) Jest configuration.
         * <p>
         * Default: - default jest configuration
         * <p>
         * @return {@code this}
         * @param jestConfig Jest configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jestConfig(final io.github.cdklabs.projen.javascript.JestConfigOptions jestConfig) {
            this.options().jestConfig(jestConfig);
            return this;
        }

        /**
         * (experimental) The version of jest to use.
         * <p>
         * Note that same version is used as version of <code>&#64;types/jest</code> and <code>ts-jest</code> (if Typescript in use), so given version should work also for those.
         * <p>
         * Default: - installs the latest jest version
         * <p>
         * @return {@code this}
         * @param jestVersion The version of jest to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jestVersion(final java.lang.String jestVersion) {
            this.options().jestVersion(jestVersion);
            return this;
        }

        /**
         * (experimental) Result processing with jest-junit.
         * <p>
         * Output directory is <code>test-reports/</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param junitReporting Result processing with jest-junit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder junitReporting(final java.lang.Boolean junitReporting) {
            this.options().junitReporting(junitReporting);
            return this;
        }

        /**
         * (experimental) Preserve the default Jest reporter when additional reporters are added.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param preserveDefaultReporters Preserve the default Jest reporter when additional reporters are added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preserveDefaultReporters(final java.lang.Boolean preserveDefaultReporters) {
            this.options().preserveDefaultReporters(preserveDefaultReporters);
            return this;
        }

        /**
         * (experimental) Whether to update snapshots in task "test" (which is executed in task "build" and build workflows), or create a separate task "test:update" for updating snapshots.
         * <p>
         * Default: - ALWAYS
         * <p>
         * @return {@code this}
         * @param updateSnapshot Whether to update snapshots in task "test" (which is executed in task "build" and build workflows), or create a separate task "test:update" for updating snapshots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder updateSnapshot(final io.github.cdklabs.projen.javascript.UpdateSnapshot updateSnapshot) {
            this.options().updateSnapshot(updateSnapshot);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.javascript.Jest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.javascript.Jest build() {
            return new io.github.cdklabs.projen.javascript.Jest(
                this.project,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.javascript.JestOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.javascript.JestOptions.Builder();
            }
            return this.options;
        }
    }
}
