/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.awscdk;

import io.github.cdklabs.projen.;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.JsonFile;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.awscdk.ApprovalLevel;
import io.github.cdklabs.projen.awscdk.CdkConfigOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="projen.awscdk.CdkConfig")
public class CdkConfig
extends Component {
    protected CdkConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CdkConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CdkConfig(@NotNull Project project, @NotNull CdkConfigOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addExcludes(String ... patterns) {
        Kernel.call((Object)((Object)this), (String)"addExcludes", (NativeType)NativeType.VOID, (Object[])Arrays.stream(patterns).toArray(Object[]::new));
    }

    public void addIncludes(String ... patterns) {
        Kernel.call((Object)((Object)this), (String)"addIncludes", (NativeType)NativeType.VOID, (Object[])Arrays.stream(patterns).toArray(Object[]::new));
    }

    @NotNull
    public String getCdkout() {
        return (String)Kernel.get((Object)((Object)this), (String)"cdkout", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getExclude() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"exclude", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getInclude() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"include", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public JsonFile getJson() {
        return (JsonFile)((Object)Kernel.get((Object)((Object)this), (String)"json", (NativeType)NativeType.forClass(JsonFile.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CdkConfig> {
        private final Project project;
        private final CdkConfigOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
            this.options = new CdkConfigOptions.Builder();
        }

        public Builder buildCommand(String buildCommand) {
            this.options.buildCommand(buildCommand);
            return this;
        }

        public Builder cdkout(String cdkout) {
            this.options.cdkout(cdkout);
            return this;
        }

        public Builder context(Map<String, ? extends Object> context) {
            this.options.context(context);
            return this;
        }

        public Builder featureFlags(Boolean featureFlags) {
            this.options.featureFlags(featureFlags);
            return this;
        }

        public Builder requireApproval(ApprovalLevel requireApproval) {
            this.options.requireApproval(requireApproval);
            return this;
        }

        public Builder watchExcludes(List<String> watchExcludes) {
            this.options.watchExcludes(watchExcludes);
            return this;
        }

        public Builder watchIncludes(List<String> watchIncludes) {
            this.options.watchIncludes(watchIncludes);
            return this;
        }

        public Builder app(String app) {
            this.options.app(app);
            return this;
        }

        public CdkConfig build() {
            return new CdkConfig(this.project, this.options.build());
        }
    }
}

