/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.gitlab;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.YamlFile;
import io.github.cdklabs.projen.gitlab.Artifacts;
import io.github.cdklabs.projen.gitlab.Cache;
import io.github.cdklabs.projen.gitlab.CiConfigurationOptions;
import io.github.cdklabs.projen.gitlab.Default;
import io.github.cdklabs.projen.gitlab.Image;
import io.github.cdklabs.projen.gitlab.Include;
import io.github.cdklabs.projen.gitlab.Job;
import io.github.cdklabs.projen.gitlab.Retry;
import io.github.cdklabs.projen.gitlab.Service;
import io.github.cdklabs.projen.gitlab.Workflow;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.gitlab.CiConfiguration")
public class CiConfiguration
extends Component {
    protected CiConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CiConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CiConfiguration(@NotNull Project project, @NotNull String name, @Nullable CiConfigurationOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(name, "name is required"), options});
    }

    public CiConfiguration(@NotNull Project project, @NotNull String name) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(name, "name is required")});
    }

    public void addDefaultCaches(@NotNull List<Cache> caches) {
        Kernel.call((Object)((Object)this), (String)"addDefaultCaches", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(caches, "caches is required")});
    }

    public void addGlobalVariables(@NotNull Map<String, Object> variables) {
        Kernel.call((Object)((Object)this), (String)"addGlobalVariables", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(variables, "variables is required")});
    }

    public void addIncludes(Include ... includes) {
        Kernel.call((Object)((Object)this), (String)"addIncludes", (NativeType)NativeType.VOID, (Object[])Arrays.stream(includes).toArray(Object[]::new));
    }

    public void addJobs(@NotNull Map<String, Job> jobs) {
        Kernel.call((Object)((Object)this), (String)"addJobs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(jobs, "jobs is required")});
    }

    public void addServices(Service ... services) {
        Kernel.call((Object)((Object)this), (String)"addServices", (NativeType)NativeType.VOID, (Object[])Arrays.stream(services).toArray(Object[]::new));
    }

    public void addStages(String ... stages) {
        Kernel.call((Object)((Object)this), (String)"addStages", (NativeType)NativeType.VOID, (Object[])Arrays.stream(stages).toArray(Object[]::new));
    }

    @NotNull
    public List<String> getDefaultAfterScript() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"defaultAfterScript", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getDefaultBeforeScript() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"defaultBeforeScript", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getDefaultTags() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"defaultTags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public YamlFile getFile() {
        return (YamlFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(YamlFile.class)));
    }

    @NotNull
    public Map<String, Job> getJobs() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"jobs", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Job.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"path", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getStages() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"stages", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"variables", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Artifacts getDefaultArtifacts() {
        return (Artifacts)Kernel.get((Object)((Object)this), (String)"defaultArtifacts", (NativeType)NativeType.forClass(Artifacts.class));
    }

    @Nullable
    public List<Cache> getDefaultCache() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"defaultCache", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Cache.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public Image getDefaultImage() {
        return (Image)Kernel.get((Object)((Object)this), (String)"defaultImage", (NativeType)NativeType.forClass(Image.class));
    }

    @Nullable
    public Boolean getDefaultInterruptible() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"defaultInterruptible", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public Retry getDefaultRetry() {
        return (Retry)Kernel.get((Object)((Object)this), (String)"defaultRetry", (NativeType)NativeType.forClass(Retry.class));
    }

    @Nullable
    public String getDefaultTimeout() {
        return (String)Kernel.get((Object)((Object)this), (String)"defaultTimeout", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Job getPages() {
        return (Job)Kernel.get((Object)((Object)this), (String)"pages", (NativeType)NativeType.forClass(Job.class));
    }

    @Nullable
    public Workflow getWorkflow() {
        return (Workflow)Kernel.get((Object)((Object)this), (String)"workflow", (NativeType)NativeType.forClass(Workflow.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CiConfiguration> {
        private final Project project;
        private final String name;
        private CiConfigurationOptions.Builder options;

        public static Builder create(Project project, String name) {
            return new Builder(project, name);
        }

        private Builder(Project project, String name) {
            this.project = project;
            this.name = name;
        }

        public Builder defaultValue(Default defaultValue) {
            this.options().defaultValue(defaultValue);
            return this;
        }

        public Builder jobs(Map<String, ? extends Job> jobs) {
            this.options().jobs(jobs);
            return this;
        }

        public Builder pages(Job pages) {
            this.options().pages(pages);
            return this;
        }

        public Builder stages(List<String> stages) {
            this.options().stages(stages);
            return this;
        }

        public Builder variables(Map<String, ? extends Object> variables) {
            this.options().variables(variables);
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.options().workflow(workflow);
            return this;
        }

        public CiConfiguration build() {
            return new CiConfiguration(this.project, this.name, this.options != null ? this.options.build() : null);
        }

        private CiConfigurationOptions.Builder options() {
            if (this.options == null) {
                this.options = new CiConfigurationOptions.Builder();
            }
            return this.options;
        }
    }
}

