/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.javascript;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.javascript.EslintOptions;
import io.github.cdklabs.projen.javascript.EslintOverride;
import io.github.cdklabs.projen.javascript.NodeProject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.javascript.Eslint")
public class Eslint
extends Component {
    protected Eslint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Eslint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Eslint(@NotNull NodeProject project, @NotNull EslintOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Nullable
    public static Eslint of(@NotNull Project project) {
        return (Eslint)((Object)JsiiObject.jsiiStaticCall(Eslint.class, (String)"of", (NativeType)NativeType.forClass(Eslint.class), (Object[])new Object[]{Objects.requireNonNull(project, "project is required")}));
    }

    public void addExtends(String ... extendList) {
        Kernel.call((Object)((Object)this), (String)"addExtends", (NativeType)NativeType.VOID, (Object[])Arrays.stream(extendList).toArray(Object[]::new));
    }

    public void addIgnorePattern(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addIgnorePattern", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addLintPattern(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addLintPattern", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addOverride(@NotNull EslintOverride override) {
        Kernel.call((Object)((Object)this), (String)"addOverride", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(override, "override is required")});
    }

    public void addPlugins(String ... plugins) {
        Kernel.call((Object)((Object)this), (String)"addPlugins", (NativeType)NativeType.VOID, (Object[])Arrays.stream(plugins).toArray(Object[]::new));
    }

    public void addRules(@NotNull Map<String, Object> rules) {
        Kernel.call((Object)((Object)this), (String)"addRules", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rules, "rules is required")});
    }

    public void allowDevDeps(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"allowDevDeps", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    @NotNull
    public Object getConfig() {
        return Kernel.get((Object)((Object)this), (String)"config", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public Task getEslintTask() {
        return (Task)((Object)Kernel.get((Object)((Object)this), (String)"eslintTask", (NativeType)NativeType.forClass(Task.class)));
    }

    @NotNull
    public List<String> getIgnorePatterns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"ignorePatterns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getLintPatterns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"lintPatterns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<EslintOverride> getOverrides() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"overrides", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EslintOverride.class))));
    }

    @NotNull
    public Map<String, List<Object>> getRules() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"rules", (NativeType)NativeType.mapOf((NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class)))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Eslint> {
        private final NodeProject project;
        private final EslintOptions.Builder options;

        public static Builder create(NodeProject project) {
            return new Builder(project);
        }

        private Builder(NodeProject project) {
            this.project = project;
            this.options = new EslintOptions.Builder();
        }

        public Builder dirs(List<String> dirs) {
            this.options.dirs(dirs);
            return this;
        }

        public Builder aliasExtensions(List<String> aliasExtensions) {
            this.options.aliasExtensions(aliasExtensions);
            return this;
        }

        public Builder aliasMap(Map<String, String> aliasMap) {
            this.options.aliasMap(aliasMap);
            return this;
        }

        public Builder devdirs(List<String> devdirs) {
            this.options.devdirs(devdirs);
            return this;
        }

        public Builder fileExtensions(List<String> fileExtensions) {
            this.options.fileExtensions(fileExtensions);
            return this;
        }

        public Builder ignorePatterns(List<String> ignorePatterns) {
            this.options.ignorePatterns(ignorePatterns);
            return this;
        }

        @Deprecated
        public Builder lintProjenRc(Boolean lintProjenRc) {
            this.options.lintProjenRc(lintProjenRc);
            return this;
        }

        @Deprecated
        public Builder lintProjenRcFile(String lintProjenRcFile) {
            this.options.lintProjenRcFile(lintProjenRcFile);
            return this;
        }

        public Builder prettier(Boolean prettier) {
            this.options.prettier(prettier);
            return this;
        }

        public Builder tsAlwaysTryTypes(Boolean tsAlwaysTryTypes) {
            this.options.tsAlwaysTryTypes(tsAlwaysTryTypes);
            return this;
        }

        public Builder tsconfigPath(String tsconfigPath) {
            this.options.tsconfigPath(tsconfigPath);
            return this;
        }

        public Builder yaml(Boolean yaml) {
            this.options.yaml(yaml);
            return this;
        }

        public Eslint build() {
            return new Eslint(this.project, this.options.build());
        }
    }
}

