/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.javascript;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.JsonFile;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.javascript.TypeScriptCompilerOptions;
import io.github.cdklabs.projen.javascript.TypescriptConfigExtends;
import io.github.cdklabs.projen.javascript.TypescriptConfigOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.javascript.TypescriptConfig")
public class TypescriptConfig
extends Component {
    protected TypescriptConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TypescriptConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TypescriptConfig(@NotNull Project project, @NotNull TypescriptConfigOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addExclude(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addExclude", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addExtends(@NotNull TypescriptConfig value) {
        Kernel.call((Object)((Object)this), (String)"addExtends", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(value, "value is required")});
    }

    public void addInclude(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addInclude", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    @Override
    public void preSynthesize() {
        Kernel.call((Object)((Object)this), (String)"preSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public String resolveExtendsPath(@NotNull String configPath) {
        return (String)Kernel.call((Object)((Object)this), (String)"resolveExtendsPath", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(configPath, "configPath is required")});
    }

    @NotNull
    public List<String> getExclude() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"exclude", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getExtendsValue() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"extends", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public JsonFile getFile() {
        return (JsonFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(JsonFile.class)));
    }

    @NotNull
    public String getFileName() {
        return (String)Kernel.get((Object)((Object)this), (String)"fileName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getInclude() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"include", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public TypeScriptCompilerOptions getCompilerOptions() {
        return (TypeScriptCompilerOptions)Kernel.get((Object)((Object)this), (String)"compilerOptions", (NativeType)NativeType.forClass(TypeScriptCompilerOptions.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TypescriptConfig> {
        private final Project project;
        private final TypescriptConfigOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
            this.options = new TypescriptConfigOptions.Builder();
        }

        public Builder compilerOptions(TypeScriptCompilerOptions compilerOptions) {
            this.options.compilerOptions(compilerOptions);
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.options.exclude(exclude);
            return this;
        }

        public Builder extendsValue(TypescriptConfigExtends extendsValue) {
            this.options.extendsValue(extendsValue);
            return this;
        }

        public Builder fileName(String fileName) {
            this.options.fileName(fileName);
            return this;
        }

        public Builder include(List<String> include) {
            this.options.include(include);
            return this;
        }

        public TypescriptConfig build() {
            return new TypescriptConfig(this.project, this.options.build());
        }
    }
}

