/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.vscode;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.DevEnvironmentDockerImage;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.vscode.DevContainerFeature;
import io.github.cdklabs.projen.vscode.DevContainerOptions;
import io.github.cdklabs.projen.vscode.IDevContainerEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.vscode.DevContainer")
public class DevContainer
extends Component
implements IDevContainerEnvironment {
    protected DevContainer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DevContainer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DevContainer(@NotNull Project project, @Nullable DevContainerOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public DevContainer(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    @Override
    public void addDockerImage(@NotNull DevEnvironmentDockerImage image) {
        Kernel.call((Object)this, (String)"addDockerImage", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(image, "image is required")});
    }

    @Override
    public void addFeatures(DevContainerFeature ... features) {
        Kernel.call((Object)this, (String)"addFeatures", (NativeType)NativeType.VOID, (Object[])Arrays.stream(features).toArray(Object[]::new));
    }

    @Override
    public void addPorts(String ... ports) {
        Kernel.call((Object)this, (String)"addPorts", (NativeType)NativeType.VOID, (Object[])Arrays.stream(ports).toArray(Object[]::new));
    }

    @Override
    public void addTasks(Task ... tasks) {
        Kernel.call((Object)this, (String)"addTasks", (NativeType)NativeType.VOID, (Object[])Arrays.stream(tasks).toArray(Object[]::new));
    }

    @Override
    public void addVscodeExtensions(String ... extensions) {
        Kernel.call((Object)this, (String)"addVscodeExtensions", (NativeType)NativeType.VOID, (Object[])Arrays.stream(extensions).toArray(Object[]::new));
    }

    @NotNull
    public Object getConfig() {
        return Kernel.get((Object)this, (String)"config", (NativeType)NativeType.forClass(Object.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DevContainer> {
        private final Project project;
        private DevContainerOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder dockerImage(DevEnvironmentDockerImage dockerImage) {
            this.options().dockerImage(dockerImage);
            return this;
        }

        public Builder ports(List<String> ports) {
            this.options().ports(ports);
            return this;
        }

        public Builder tasks(List<? extends Task> tasks) {
            this.options().tasks(tasks);
            return this;
        }

        public Builder vscodeExtensions(List<String> vscodeExtensions) {
            this.options().vscodeExtensions(vscodeExtensions);
            return this;
        }

        public Builder features(List<? extends DevContainerFeature> features) {
            this.options().features(features);
            return this;
        }

        public DevContainer build() {
            return new DevContainer(this.project, this.options != null ? this.options.build() : null);
        }

        private DevContainerOptions.Builder options() {
            if (this.options == null) {
                this.options = new DevContainerOptions.Builder();
            }
            return this.options;
        }
    }
}

