package io.github.cdklabs.projen;

/**
 * (experimental) The <code>Dependencies</code> component is responsible to track the list of dependencies a project has, and then used by project types as the model for rendering project-specific dependency manifests such as the dependencies section <code>package.json</code> files.
 * <p>
 * To add a dependency you can use a project-type specific API such as
 * <code>nodeProject.addDeps()</code> or use the generic API of <code>project.deps</code>:
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:42.727Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.Dependencies")
public class Dependencies extends io.github.cdklabs.projen.Component {

    protected Dependencies(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dependencies(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        MANIFEST_FILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(io.github.cdklabs.projen.Dependencies.class, "MANIFEST_FILE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Adds a dependencies component to the project.
     * <p>
     * @param project The parent project. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Dependencies(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Returns the coordinates of a dependency spec.
     * <p>
     * Given <code>foo&#64;^3.4.0</code> returns <code>{ name: "foo", version: "^3.4.0" }</code>.
     * Given <code>bar&#64;npm:&#64;bar/legacy</code> returns <code>{ name: "bar", version: "npm:&#64;bar/legacy" }</code>.
     * <p>
     * @param spec This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.DependencyCoordinates parseDependency(final @org.jetbrains.annotations.NotNull java.lang.String spec) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.Dependencies.class, "parseDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.DependencyCoordinates.class), new Object[] { java.util.Objects.requireNonNull(spec, "spec is required") });
    }

    /**
     * (experimental) Adds a dependency to this project.
     * <p>
     * @param spec The dependency spec in the format <code>MODULE[&#64;VERSION]</code> where <code>MODULE</code> is the package-manager-specific module name and <code>VERSION</code> is an optional semantic version requirement (e.g. <code>^3.4.0</code>). This parameter is required.
     * @param type The type of the dependency. This parameter is required.
     * @param metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Dependency addDependency(final @org.jetbrains.annotations.NotNull java.lang.String spec, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.DependencyType type, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> metadata) {
        return software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(spec, "spec is required"), java.util.Objects.requireNonNull(type, "type is required"), metadata });
    }

    /**
     * (experimental) Adds a dependency to this project.
     * <p>
     * @param spec The dependency spec in the format <code>MODULE[&#64;VERSION]</code> where <code>MODULE</code> is the package-manager-specific module name and <code>VERSION</code> is an optional semantic version requirement (e.g. <code>^3.4.0</code>). This parameter is required.
     * @param type The type of the dependency. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Dependency addDependency(final @org.jetbrains.annotations.NotNull java.lang.String spec, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.DependencyType type) {
        return software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(spec, "spec is required"), java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) Returns a dependency by name.
     * <p>
     * Fails if there is no dependency defined by that name or if <code>type</code> is not
     * provided and there is more then one dependency type for this dependency.
     * <p>
     * @return a copy (cannot be modified)
     * @param name The name of the dependency. This parameter is required.
     * @param type The dependency type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Dependency getDependency(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.DependencyType type) {
        return software.amazon.jsii.Kernel.call(this, "getDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), type });
    }

    /**
     * (experimental) Returns a dependency by name.
     * <p>
     * Fails if there is no dependency defined by that name or if <code>type</code> is not
     * provided and there is more then one dependency type for this dependency.
     * <p>
     * @return a copy (cannot be modified)
     * @param name The name of the dependency. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Dependency getDependency(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "getDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Removes a dependency.
     * <p>
     * @param name The name of the module to remove (without the version). This parameter is required.
     * @param type The dependency type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void removeDependency(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.DependencyType type) {
        software.amazon.jsii.Kernel.call(this, "removeDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), type });
    }

    /**
     * (experimental) Removes a dependency.
     * <p>
     * @param name The name of the module to remove (without the version). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void removeDependency(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        software.amazon.jsii.Kernel.call(this, "removeDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Returns a dependency by name.
     * <p>
     * Returns <code>undefined</code> if there is no dependency defined by that name or if
     * <code>type</code> is not provided and there is more then one dependency type for this
     * dependency.
     * <p>
     * @return a copy (cannot be modified) or undefined if there is no match
     * @param name The name of the dependency. This parameter is required.
     * @param type The dependency type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.Dependency tryGetDependency(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.DependencyType type) {
        return software.amazon.jsii.Kernel.call(this, "tryGetDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), type });
    }

    /**
     * (experimental) Returns a dependency by name.
     * <p>
     * Returns <code>undefined</code> if there is no dependency defined by that name or if
     * <code>type</code> is not provided and there is more then one dependency type for this
     * dependency.
     * <p>
     * @return a copy (cannot be modified) or undefined if there is no match
     * @param name The name of the dependency. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.Dependency tryGetDependency(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "tryGetDependency", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) The project-relative path of the deps manifest file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String MANIFEST_FILE;

    /**
     * (experimental) A copy of all dependencies recorded for this project.
     * <p>
     * The list is sorted by type-&gt;name-&gt;version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<io.github.cdklabs.projen.Dependency> getAll() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Dependency.class))));
    }
}
