package io.github.cdklabs.projen;

/**
 * (experimental) Configure options for a task to be run when opening a Gitpod workspace (e.g. running tests, or starting a dev server).
 * <p>
 * Start Mode         | Execution
 * Fresh Workspace    | before &amp;&amp; init &amp;&amp; command
 * Restart Workspace  | before &amp;&amp; command
 * Snapshot           | before &amp;&amp; command
 * Prebuild           | before &amp;&amp; init &amp;&amp; prebuild
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:42.759Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.GitpodTask")
@software.amazon.jsii.Jsii.Proxy(GitpodTask.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitpodTask extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Required.
     * <p>
     * The shell command to run
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCommand();

    /**
     * (experimental) In case you need to run something even before init, that is a requirement for both init and command, you can use the before property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBefore() {
        return null;
    }

    /**
     * (experimental) The init property can be used to specify shell commands that should only be executed after a workspace was freshly cloned and needs to be initialized somehow.
     * <p>
     * Such tasks are usually builds or downloading
     * dependencies. Anything you only want to do once but not when you restart a workspace or start a snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInit() {
        return null;
    }

    /**
     * (experimental) A name for this task.
     * <p>
     * Default: - task names are omitted when blank
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) You can configure where in the IDE the terminal should be opened.
     * <p>
     * Default: GitpodOpenIn.BOTTOM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.GitpodOpenIn getOpenIn() {
        return null;
    }

    /**
     * (experimental) You can configure how the terminal should be opened relative to the previous task.
     * <p>
     * Default: GitpodOpenMode.TAB_AFTER
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.GitpodOpenMode getOpenMode() {
        return null;
    }

    /**
     * (experimental) The optional prebuild command will be executed during prebuilds.
     * <p>
     * It is meant to run additional long running
     * processes that could be useful, e.g. running test suites.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrebuild() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitpodTask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitpodTask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitpodTask> {
        java.lang.String command;
        java.lang.String before;
        java.lang.String init;
        java.lang.String name;
        io.github.cdklabs.projen.GitpodOpenIn openIn;
        io.github.cdklabs.projen.GitpodOpenMode openMode;
        java.lang.String prebuild;

        /**
         * Sets the value of {@link GitpodTask#getCommand}
         * @param command Required. This parameter is required.
         *                The shell command to run
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.lang.String command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getBefore}
         * @param before In case you need to run something even before init, that is a requirement for both init and command, you can use the before property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder before(java.lang.String before) {
            this.before = before;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getInit}
         * @param init The init property can be used to specify shell commands that should only be executed after a workspace was freshly cloned and needs to be initialized somehow.
         *             Such tasks are usually builds or downloading
         *             dependencies. Anything you only want to do once but not when you restart a workspace or start a snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder init(java.lang.String init) {
            this.init = init;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getName}
         * @param name A name for this task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getOpenIn}
         * @param openIn You can configure where in the IDE the terminal should be opened.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openIn(io.github.cdklabs.projen.GitpodOpenIn openIn) {
            this.openIn = openIn;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getOpenMode}
         * @param openMode You can configure how the terminal should be opened relative to the previous task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openMode(io.github.cdklabs.projen.GitpodOpenMode openMode) {
            this.openMode = openMode;
            return this;
        }

        /**
         * Sets the value of {@link GitpodTask#getPrebuild}
         * @param prebuild The optional prebuild command will be executed during prebuilds.
         *                 It is meant to run additional long running
         *                 processes that could be useful, e.g. running test suites.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prebuild(java.lang.String prebuild) {
            this.prebuild = prebuild;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitpodTask}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitpodTask build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitpodTask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitpodTask {
        private final java.lang.String command;
        private final java.lang.String before;
        private final java.lang.String init;
        private final java.lang.String name;
        private final io.github.cdklabs.projen.GitpodOpenIn openIn;
        private final io.github.cdklabs.projen.GitpodOpenMode openMode;
        private final java.lang.String prebuild;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.before = software.amazon.jsii.Kernel.get(this, "before", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.init = software.amazon.jsii.Kernel.get(this, "init", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openIn = software.amazon.jsii.Kernel.get(this, "openIn", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.GitpodOpenIn.class));
            this.openMode = software.amazon.jsii.Kernel.get(this, "openMode", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.GitpodOpenMode.class));
            this.prebuild = software.amazon.jsii.Kernel.get(this, "prebuild", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
            this.before = builder.before;
            this.init = builder.init;
            this.name = builder.name;
            this.openIn = builder.openIn;
            this.openMode = builder.openMode;
            this.prebuild = builder.prebuild;
        }

        @Override
        public final java.lang.String getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getBefore() {
            return this.before;
        }

        @Override
        public final java.lang.String getInit() {
            return this.init;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final io.github.cdklabs.projen.GitpodOpenIn getOpenIn() {
            return this.openIn;
        }

        @Override
        public final io.github.cdklabs.projen.GitpodOpenMode getOpenMode() {
            return this.openMode;
        }

        @Override
        public final java.lang.String getPrebuild() {
            return this.prebuild;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("command", om.valueToTree(this.getCommand()));
            if (this.getBefore() != null) {
                data.set("before", om.valueToTree(this.getBefore()));
            }
            if (this.getInit() != null) {
                data.set("init", om.valueToTree(this.getInit()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOpenIn() != null) {
                data.set("openIn", om.valueToTree(this.getOpenIn()));
            }
            if (this.getOpenMode() != null) {
                data.set("openMode", om.valueToTree(this.getOpenMode()));
            }
            if (this.getPrebuild() != null) {
                data.set("prebuild", om.valueToTree(this.getPrebuild()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.GitpodTask"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitpodTask.Jsii$Proxy that = (GitpodTask.Jsii$Proxy) o;

            if (!command.equals(that.command)) return false;
            if (this.before != null ? !this.before.equals(that.before) : that.before != null) return false;
            if (this.init != null ? !this.init.equals(that.init) : that.init != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.openIn != null ? !this.openIn.equals(that.openIn) : that.openIn != null) return false;
            if (this.openMode != null ? !this.openMode.equals(that.openMode) : that.openMode != null) return false;
            return this.prebuild != null ? this.prebuild.equals(that.prebuild) : that.prebuild == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command.hashCode();
            result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
            result = 31 * result + (this.init != null ? this.init.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.openIn != null ? this.openIn.hashCode() : 0);
            result = 31 * result + (this.openMode != null ? this.openMode.hashCode() : 0);
            result = 31 * result + (this.prebuild != null ? this.prebuild.hashCode() : 0);
            return result;
        }
    }
}
