package io.github.cdklabs.projen.build;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:42.950Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.build.BuildWorkflowOptions")
@software.amazon.jsii.Jsii.Proxy(BuildWorkflowOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BuildWorkflowOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A name of a directory that includes build artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getArtifactsDirectory();

    /**
     * (experimental) The task to execute in order to build the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task getBuildTask();

    /**
     * (experimental) The container image to use for builds.
     * <p>
     * Default: - the default workflow container
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerImage() {
        return null;
    }

    /**
     * (experimental) Build environment variables.
     * <p>
     * Default: {}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * (experimental) Git identity to use for the workflow.
     * <p>
     * Default: - default identity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.GitIdentity getGitIdentity() {
        return null;
    }

    /**
     * (experimental) Automatically update files modified during builds to pull-request branches.
     * <p>
     * This means that any files synthesized by projen or e.g. test snapshots will
     * always be up-to-date before a PR is merged.
     * <p>
     * Implies that PR builds do not have anti-tamper checks.
     * <p>
     * This is enabled by default only if <code>githubTokenSecret</code> is set. Otherwise it
     * is disabled, which implies that file changes that happen during build will
     * not be pushed back to the branch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutableBuild() {
        return null;
    }

    /**
     * (experimental) Name of the buildfile (e.g. "build" becomes "build.yml").
     * <p>
     * Default: "build"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) Permissions granted to the build job To limit job permissions for <code>contents</code>, the desired permissions have to be explicitly set, e.g.: <code>{ contents: JobPermission.NONE }</code>.
     * <p>
     * Default: `{ contents: JobPermission.WRITE }`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.JobPermissions getPermissions() {
        return null;
    }

    /**
     * (experimental) Steps to execute after build.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPostBuildSteps() {
        return null;
    }

    /**
     * (experimental) Steps to execute before the build.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPreBuildSteps() {
        return null;
    }

    /**
     * (experimental) Github Runner selection labels.
     * <p>
     * Default: ["ubuntu-latest"]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRunsOn() {
        return null;
    }

    /**
     * (experimental) Github Runner Group selection options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.GroupRunnerOptions getRunsOnGroup() {
        return null;
    }

    /**
     * (experimental) Build workflow triggers.
     * <p>
     * Default: "{ pullRequest: {}, workflowDispatch: {} }"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.workflows.Triggers getWorkflowTriggers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BuildWorkflowOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BuildWorkflowOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BuildWorkflowOptions> {
        java.lang.String artifactsDirectory;
        io.github.cdklabs.projen.Task buildTask;
        java.lang.String containerImage;
        java.util.Map<java.lang.String, java.lang.String> env;
        io.github.cdklabs.projen.github.GitIdentity gitIdentity;
        java.lang.Boolean mutableBuild;
        java.lang.String name;
        io.github.cdklabs.projen.github.workflows.JobPermissions permissions;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> preBuildSteps;
        java.util.List<java.lang.String> runsOn;
        io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup;
        io.github.cdklabs.projen.github.workflows.Triggers workflowTriggers;

        /**
         * Sets the value of {@link BuildWorkflowOptions#getArtifactsDirectory}
         * @param artifactsDirectory A name of a directory that includes build artifacts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactsDirectory(java.lang.String artifactsDirectory) {
            this.artifactsDirectory = artifactsDirectory;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getBuildTask}
         * @param buildTask The task to execute in order to build the project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildTask(io.github.cdklabs.projen.Task buildTask) {
            this.buildTask = buildTask;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getContainerImage}
         * @param containerImage The container image to use for builds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerImage(java.lang.String containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getEnv}
         * @param env Build environment variables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getGitIdentity}
         * @param gitIdentity Git identity to use for the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitIdentity(io.github.cdklabs.projen.github.GitIdentity gitIdentity) {
            this.gitIdentity = gitIdentity;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getMutableBuild}
         * @param mutableBuild Automatically update files modified during builds to pull-request branches.
         *                     This means that any files synthesized by projen or e.g. test snapshots will
         *                     always be up-to-date before a PR is merged.
         *                     <p>
         *                     Implies that PR builds do not have anti-tamper checks.
         *                     <p>
         *                     This is enabled by default only if <code>githubTokenSecret</code> is set. Otherwise it
         *                     is disabled, which implies that file changes that happen during build will
         *                     not be pushed back to the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutableBuild(java.lang.Boolean mutableBuild) {
            this.mutableBuild = mutableBuild;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getName}
         * @param name Name of the buildfile (e.g. "build" becomes "build.yml").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getPermissions}
         * @param permissions Permissions granted to the build job To limit job permissions for <code>contents</code>, the desired permissions have to be explicitly set, e.g.: <code>{ contents: JobPermission.NONE }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder permissions(io.github.cdklabs.projen.github.workflows.JobPermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getPostBuildSteps}
         * @param postBuildSteps Steps to execute after build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder postBuildSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.postBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)postBuildSteps;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getPreBuildSteps}
         * @param preBuildSteps Steps to execute before the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder preBuildSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> preBuildSteps) {
            this.preBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)preBuildSteps;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getRunsOn}
         * @param runsOn Github Runner selection labels.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOn(java.util.List<java.lang.String> runsOn) {
            this.runsOn = runsOn;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getRunsOnGroup}
         * @param runsOnGroup Github Runner Group selection options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runsOnGroup(io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup) {
            this.runsOnGroup = runsOnGroup;
            return this;
        }

        /**
         * Sets the value of {@link BuildWorkflowOptions#getWorkflowTriggers}
         * @param workflowTriggers Build workflow triggers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowTriggers(io.github.cdklabs.projen.github.workflows.Triggers workflowTriggers) {
            this.workflowTriggers = workflowTriggers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildWorkflowOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BuildWorkflowOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BuildWorkflowOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildWorkflowOptions {
        private final java.lang.String artifactsDirectory;
        private final io.github.cdklabs.projen.Task buildTask;
        private final java.lang.String containerImage;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final io.github.cdklabs.projen.github.GitIdentity gitIdentity;
        private final java.lang.Boolean mutableBuild;
        private final java.lang.String name;
        private final io.github.cdklabs.projen.github.workflows.JobPermissions permissions;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> preBuildSteps;
        private final java.util.List<java.lang.String> runsOn;
        private final io.github.cdklabs.projen.GroupRunnerOptions runsOnGroup;
        private final io.github.cdklabs.projen.github.workflows.Triggers workflowTriggers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactsDirectory = software.amazon.jsii.Kernel.get(this, "artifactsDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildTask = software.amazon.jsii.Kernel.get(this, "buildTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class));
            this.containerImage = software.amazon.jsii.Kernel.get(this, "containerImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gitIdentity = software.amazon.jsii.Kernel.get(this, "gitIdentity", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.GitIdentity.class));
            this.mutableBuild = software.amazon.jsii.Kernel.get(this, "mutableBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobPermissions.class));
            this.postBuildSteps = software.amazon.jsii.Kernel.get(this, "postBuildSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.preBuildSteps = software.amazon.jsii.Kernel.get(this, "preBuildSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.runsOn = software.amazon.jsii.Kernel.get(this, "runsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.runsOnGroup = software.amazon.jsii.Kernel.get(this, "runsOnGroup", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.GroupRunnerOptions.class));
            this.workflowTriggers = software.amazon.jsii.Kernel.get(this, "workflowTriggers", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.Triggers.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactsDirectory = java.util.Objects.requireNonNull(builder.artifactsDirectory, "artifactsDirectory is required");
            this.buildTask = java.util.Objects.requireNonNull(builder.buildTask, "buildTask is required");
            this.containerImage = builder.containerImage;
            this.env = builder.env;
            this.gitIdentity = builder.gitIdentity;
            this.mutableBuild = builder.mutableBuild;
            this.name = builder.name;
            this.permissions = builder.permissions;
            this.postBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.postBuildSteps;
            this.preBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.preBuildSteps;
            this.runsOn = builder.runsOn;
            this.runsOnGroup = builder.runsOnGroup;
            this.workflowTriggers = builder.workflowTriggers;
        }

        @Override
        public final java.lang.String getArtifactsDirectory() {
            return this.artifactsDirectory;
        }

        @Override
        public final io.github.cdklabs.projen.Task getBuildTask() {
            return this.buildTask;
        }

        @Override
        public final java.lang.String getContainerImage() {
            return this.containerImage;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final io.github.cdklabs.projen.github.GitIdentity getGitIdentity() {
            return this.gitIdentity;
        }

        @Override
        public final java.lang.Boolean getMutableBuild() {
            return this.mutableBuild;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.JobPermissions getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPostBuildSteps() {
            return this.postBuildSteps;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPreBuildSteps() {
            return this.preBuildSteps;
        }

        @Override
        public final java.util.List<java.lang.String> getRunsOn() {
            return this.runsOn;
        }

        @Override
        public final io.github.cdklabs.projen.GroupRunnerOptions getRunsOnGroup() {
            return this.runsOnGroup;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.Triggers getWorkflowTriggers() {
            return this.workflowTriggers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactsDirectory", om.valueToTree(this.getArtifactsDirectory()));
            data.set("buildTask", om.valueToTree(this.getBuildTask()));
            if (this.getContainerImage() != null) {
                data.set("containerImage", om.valueToTree(this.getContainerImage()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getGitIdentity() != null) {
                data.set("gitIdentity", om.valueToTree(this.getGitIdentity()));
            }
            if (this.getMutableBuild() != null) {
                data.set("mutableBuild", om.valueToTree(this.getMutableBuild()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getPostBuildSteps() != null) {
                data.set("postBuildSteps", om.valueToTree(this.getPostBuildSteps()));
            }
            if (this.getPreBuildSteps() != null) {
                data.set("preBuildSteps", om.valueToTree(this.getPreBuildSteps()));
            }
            if (this.getRunsOn() != null) {
                data.set("runsOn", om.valueToTree(this.getRunsOn()));
            }
            if (this.getRunsOnGroup() != null) {
                data.set("runsOnGroup", om.valueToTree(this.getRunsOnGroup()));
            }
            if (this.getWorkflowTriggers() != null) {
                data.set("workflowTriggers", om.valueToTree(this.getWorkflowTriggers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.build.BuildWorkflowOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BuildWorkflowOptions.Jsii$Proxy that = (BuildWorkflowOptions.Jsii$Proxy) o;

            if (!artifactsDirectory.equals(that.artifactsDirectory)) return false;
            if (!buildTask.equals(that.buildTask)) return false;
            if (this.containerImage != null ? !this.containerImage.equals(that.containerImage) : that.containerImage != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.gitIdentity != null ? !this.gitIdentity.equals(that.gitIdentity) : that.gitIdentity != null) return false;
            if (this.mutableBuild != null ? !this.mutableBuild.equals(that.mutableBuild) : that.mutableBuild != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.postBuildSteps != null ? !this.postBuildSteps.equals(that.postBuildSteps) : that.postBuildSteps != null) return false;
            if (this.preBuildSteps != null ? !this.preBuildSteps.equals(that.preBuildSteps) : that.preBuildSteps != null) return false;
            if (this.runsOn != null ? !this.runsOn.equals(that.runsOn) : that.runsOn != null) return false;
            if (this.runsOnGroup != null ? !this.runsOnGroup.equals(that.runsOnGroup) : that.runsOnGroup != null) return false;
            return this.workflowTriggers != null ? this.workflowTriggers.equals(that.workflowTriggers) : that.workflowTriggers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactsDirectory.hashCode();
            result = 31 * result + (this.buildTask.hashCode());
            result = 31 * result + (this.containerImage != null ? this.containerImage.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.gitIdentity != null ? this.gitIdentity.hashCode() : 0);
            result = 31 * result + (this.mutableBuild != null ? this.mutableBuild.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.postBuildSteps != null ? this.postBuildSteps.hashCode() : 0);
            result = 31 * result + (this.preBuildSteps != null ? this.preBuildSteps.hashCode() : 0);
            result = 31 * result + (this.runsOn != null ? this.runsOn.hashCode() : 0);
            result = 31 * result + (this.runsOnGroup != null ? this.runsOnGroup.hashCode() : 0);
            result = 31 * result + (this.workflowTriggers != null ? this.workflowTriggers.hashCode() : 0);
            return result;
        }
    }
}
