package io.github.cdklabs.projen.circleci;

/**
 * (experimental) Circleci Class to manage <code>.circleci/config.yml</code>. Check projen's docs for more information.
 * <p>
 * @see <a href="https://circleci.com/docs/2.0/configuration-reference/">https://circleci.com/docs/2.0/configuration-reference/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:43.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.circleci.Circleci")
public class Circleci extends io.github.cdklabs.projen.Component {

    protected Circleci(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Circleci(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Circleci(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.circleci.CircleCiProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), options });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Circleci(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Add a Circleci Orb to pipeline.
     * <p>
     * Will throw error if the orb already exists
     * <p>
     * @param name This parameter is required.
     * @param orb This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addOrb(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String orb) {
        software.amazon.jsii.Kernel.call(this, "addOrb", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(orb, "orb is required") });
    }

    /**
     * (experimental) add new workflow to existing pipeline.
     * <p>
     * @param workflow This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addWorkflow(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.circleci.Workflow workflow) {
        software.amazon.jsii.Kernel.call(this, "addWorkflow", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(workflow, "workflow is required") });
    }

    /**
     * (experimental) The yaml file for the Circleci pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.YamlFile getFile() {
        return software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.YamlFile.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.circleci.Circleci}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.circleci.Circleci> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private io.github.cdklabs.projen.circleci.CircleCiProps.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
        }

        /**
         * (experimental) List of Jobs to create unique steps per pipeline, e.g. <code>json jobs: [{  identifier: "compile",  docker: { image: "golang:alpine" }  steps: ["checkout", run: {command: "go build ."}] }] </code>.
         * <p>
         * @return {@code this}
         * @see <a href="https://circleci.com/docs/2.0/configuration-reference/#jobs">https://circleci.com/docs/2.0/configuration-reference/#jobs</a>
         * @param jobs List of Jobs to create unique steps per pipeline, e.g. <code>json jobs: [{  identifier: "compile",  docker: { image: "golang:alpine" }  steps: ["checkout", run: {command: "go build ."}] }] </code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobs(final java.util.List<? extends io.github.cdklabs.projen.circleci.Job> jobs) {
            this.options().jobs(jobs);
            return this;
        }

        /**
         * (experimental) Contains a map of CirclCi Orbs <code>json orbs: {  node: "circleci/node&#64;5.0.1"  slack: "circleci/slack&#64;4.8.3" } </code>.
         * <p>
         * @return {@code this}
         * @param orbs Contains a map of CirclCi Orbs <code>json orbs: {  node: "circleci/node&#64;5.0.1"  slack: "circleci/slack&#64;4.8.3" } </code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder orbs(final java.util.Map<java.lang.String, java.lang.String> orbs) {
            this.options().orbs(orbs);
            return this;
        }

        /**
         * (experimental) The setup field enables you to conditionally trigger configurations from outside the primary .circleci parent directory, update pipeline parameters, or generate customized configurations.
         * <p>
         * @return {@code this}
         * @see <a href="https://circleci.com/docs/2.0/configuration-reference/#setup">https://circleci.com/docs/2.0/configuration-reference/#setup</a>
         * @param setup The setup field enables you to conditionally trigger configurations from outside the primary .circleci parent directory, update pipeline parameters, or generate customized configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder setup(final java.lang.Boolean setup) {
            this.options().setup(setup);
            return this;
        }

        /**
         * (experimental) pipeline version.
         * <p>
         * Default: 2.1
         * <p>
         * @return {@code this}
         * @see <a href="https://circleci.com/docs/2.0/configuration-reference/#version">https://circleci.com/docs/2.0/configuration-reference/#version</a>
         * @param version pipeline version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(final java.lang.Number version) {
            this.options().version(version);
            return this;
        }

        /**
         * (experimental) List of Workflows of pipeline, e.g. <code>json workflows: {   {     identifier: "build",       jobs: [{          identifier: "node/install",          context: ["npm"],       }]   } } </code>.
         * <p>
         * @return {@code this}
         * @see <a href="https://circleci.com/docs/2.0/configuration-reference/#workflows">https://circleci.com/docs/2.0/configuration-reference/#workflows</a>
         * @param workflows List of Workflows of pipeline, e.g. <code>json workflows: {   {     identifier: "build",       jobs: [{          identifier: "node/install",          context: ["npm"],       }]   } } </code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflows(final java.util.List<? extends io.github.cdklabs.projen.circleci.Workflow> workflows) {
            this.options().workflows(workflows);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.circleci.Circleci}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.circleci.Circleci build() {
            return new io.github.cdklabs.projen.circleci.Circleci(
                this.project,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.circleci.CircleCiProps.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.circleci.CircleCiProps.Builder();
            }
            return this.options;
        }
    }
}
