package io.github.cdklabs.projen.java;

/**
 * (experimental) Options for <code>Pom</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:43.146Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.java.PomOptions")
@software.amazon.jsii.Jsii.Proxy(PomOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PomOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The artifactId is generally the name that the project is known by.
     * <p>
     * Although
     * the groupId is important, people within the group will rarely mention the
     * groupId in discussion (they are often all be the same ID, such as the
     * MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
     * creates a key that separates this project from every other project in the
     * world (at least, it should :) ). Along with the groupId, the artifactId
     * fully defines the artifact's living quarters within the repository. In the
     * case of the above project, my-project lives in
     * $M2_REPO/org/codehaus/mojo/my-project.
     * <p>
     * Default: "my-app"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getArtifactId();

    /**
     * (experimental) This is generally unique amongst an organization or a project.
     * <p>
     * For example,
     * all core Maven artifacts do (well, should) live under the groupId
     * org.apache.maven. Group ID's do not necessarily use the dot notation, for
     * example, the junit project. Note that the dot-notated groupId does not have
     * to correspond to the package structure that the project contains. It is,
     * however, a good practice to follow. When stored within a repository, the
     * group acts much like the Java packaging structure does in an operating
     * system. The dots are replaced by OS specific directory separators (such as
     * '/' in Unix) which becomes a relative directory structure from the base
     * repository. In the example given, the org.codehaus.mojo group lives within
     * the directory $M2_REPO/org/codehaus/mojo.
     * <p>
     * Default: "org.acme"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

    /**
     * (experimental) This is the last piece of the naming puzzle.
     * <p>
     * groupId:artifactId denotes a
     * single project but they cannot delineate which incarnation of that project
     * we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
     * of 2007 (version 3.8.2)? In short: code changes, those changes should be
     * versioned, and this element keeps those versions in line. It is also used
     * within an artifact's repository to separate versions from each other.
     * my-project version 1.0 files live in the directory structure
     * $M2_REPO/org/codehaus/mojo/my-project/1.0.
     * <p>
     * Default: "0.1.0"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * (experimental) Description of a project is always good.
     * <p>
     * Although this should not replace
     * formal documentation, a quick comment to any readers of the POM is always
     * helpful.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Project packaging format.
     * <p>
     * Default: "jar"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPackaging() {
        return null;
    }

    /**
     * (experimental) A Parent Pom can be used to have a child project inherit properties/plugins/ect in order to reduce duplication and keep standards across a large amount of repos.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.java.ParentPom getParentPom() {
        return null;
    }

    /**
     * (experimental) The URL, like the name, is not required.
     * <p>
     * This is a nice gesture for
     * projects users, however, so that they know where the project lives.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PomOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PomOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PomOptions> {
        java.lang.String artifactId;
        java.lang.String groupId;
        java.lang.String version;
        java.lang.String description;
        java.lang.String packaging;
        io.github.cdklabs.projen.java.ParentPom parentPom;
        java.lang.String url;

        /**
         * Sets the value of {@link PomOptions#getArtifactId}
         * @param artifactId The artifactId is generally the name that the project is known by. This parameter is required.
         *                   Although
         *                   the groupId is important, people within the group will rarely mention the
         *                   groupId in discussion (they are often all be the same ID, such as the
         *                   MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
         *                   creates a key that separates this project from every other project in the
         *                   world (at least, it should :) ). Along with the groupId, the artifactId
         *                   fully defines the artifact's living quarters within the repository. In the
         *                   case of the above project, my-project lives in
         *                   $M2_REPO/org/codehaus/mojo/my-project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactId(java.lang.String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getGroupId}
         * @param groupId This is generally unique amongst an organization or a project. This parameter is required.
         *                For example,
         *                all core Maven artifacts do (well, should) live under the groupId
         *                org.apache.maven. Group ID's do not necessarily use the dot notation, for
         *                example, the junit project. Note that the dot-notated groupId does not have
         *                to correspond to the package structure that the project contains. It is,
         *                however, a good practice to follow. When stored within a repository, the
         *                group acts much like the Java packaging structure does in an operating
         *                system. The dots are replaced by OS specific directory separators (such as
         *                '/' in Unix) which becomes a relative directory structure from the base
         *                repository. In the example given, the org.codehaus.mojo group lives within
         *                the directory $M2_REPO/org/codehaus/mojo.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getVersion}
         * @param version This is the last piece of the naming puzzle. This parameter is required.
         *                groupId:artifactId denotes a
         *                single project but they cannot delineate which incarnation of that project
         *                we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
         *                of 2007 (version 3.8.2)? In short: code changes, those changes should be
         *                versioned, and this element keeps those versions in line. It is also used
         *                within an artifact's repository to separate versions from each other.
         *                my-project version 1.0 files live in the directory structure
         *                $M2_REPO/org/codehaus/mojo/my-project/1.0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getDescription}
         * @param description Description of a project is always good.
         *                    Although this should not replace
         *                    formal documentation, a quick comment to any readers of the POM is always
         *                    helpful.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getPackaging}
         * @param packaging Project packaging format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder packaging(java.lang.String packaging) {
            this.packaging = packaging;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getParentPom}
         * @param parentPom A Parent Pom can be used to have a child project inherit properties/plugins/ect in order to reduce duplication and keep standards across a large amount of repos.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parentPom(io.github.cdklabs.projen.java.ParentPom parentPom) {
            this.parentPom = parentPom;
            return this;
        }

        /**
         * Sets the value of {@link PomOptions#getUrl}
         * @param url The URL, like the name, is not required.
         *            This is a nice gesture for
         *            projects users, however, so that they know where the project lives.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PomOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PomOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PomOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PomOptions {
        private final java.lang.String artifactId;
        private final java.lang.String groupId;
        private final java.lang.String version;
        private final java.lang.String description;
        private final java.lang.String packaging;
        private final io.github.cdklabs.projen.java.ParentPom parentPom;
        private final java.lang.String url;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactId = software.amazon.jsii.Kernel.get(this, "artifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packaging = software.amazon.jsii.Kernel.get(this, "packaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parentPom = software.amazon.jsii.Kernel.get(this, "parentPom", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.java.ParentPom.class));
            this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactId = java.util.Objects.requireNonNull(builder.artifactId, "artifactId is required");
            this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.description = builder.description;
            this.packaging = builder.packaging;
            this.parentPom = builder.parentPom;
            this.url = builder.url;
        }

        @Override
        public final java.lang.String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPackaging() {
            return this.packaging;
        }

        @Override
        public final io.github.cdklabs.projen.java.ParentPom getParentPom() {
            return this.parentPom;
        }

        @Override
        public final java.lang.String getUrl() {
            return this.url;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactId", om.valueToTree(this.getArtifactId()));
            data.set("groupId", om.valueToTree(this.getGroupId()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPackaging() != null) {
                data.set("packaging", om.valueToTree(this.getPackaging()));
            }
            if (this.getParentPom() != null) {
                data.set("parentPom", om.valueToTree(this.getParentPom()));
            }
            if (this.getUrl() != null) {
                data.set("url", om.valueToTree(this.getUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.java.PomOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PomOptions.Jsii$Proxy that = (PomOptions.Jsii$Proxy) o;

            if (!artifactId.equals(that.artifactId)) return false;
            if (!groupId.equals(that.groupId)) return false;
            if (!version.equals(that.version)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.packaging != null ? !this.packaging.equals(that.packaging) : that.packaging != null) return false;
            if (this.parentPom != null ? !this.parentPom.equals(that.parentPom) : that.parentPom != null) return false;
            return this.url != null ? this.url.equals(that.url) : that.url == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactId.hashCode();
            result = 31 * result + (this.groupId.hashCode());
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
            result = 31 * result + (this.parentPom != null ? this.parentPom.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}
