package io.github.cdklabs.projen.release;

/**
 * (experimental) Project options for release.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-03-28T21:16:43.269Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.ReleaseProjectOptions")
@software.amazon.jsii.Jsii.Proxy(ReleaseProjectOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ReleaseProjectOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Version requirement of <code>publib</code> which is used to publish modules to npm.
     * <p>
     * Default: "latest"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getJsiiReleaseVersion() {
        return null;
    }

    /**
     * (experimental) Major version to release from the default branch.
     * <p>
     * If this is specified, we bump the latest version of this major version line.
     * If not specified, we bump the global latest version.
     * <p>
     * Default: - Major version is not enforced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMajorVersion() {
        return null;
    }

    /**
     * (experimental) Minimal Major version to release.
     * <p>
     * This can be useful to set to 1, as breaking changes before the 1.x major
     * release are not incrementing the major version number.
     * <p>
     * Can not be set together with <code>majorVersion</code>.
     * <p>
     * Default: - No minimum version is being enforced
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinMajorVersion() {
        return null;
    }

    /**
     * (experimental) The npmDistTag to use when publishing from the default branch.
     * <p>
     * To set the npm dist-tag for release branches, set the <code>npmDistTag</code> property
     * for each branch.
     * <p>
     * Default: "latest"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getNpmDistTag() {
        return null;
    }

    /**
     * (experimental) Steps to execute after build as part of the release workflow.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPostBuildSteps() {
        return null;
    }

    /**
     * (experimental) Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
     * <p>
     * Default: - normal semantic versions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrerelease() {
        return null;
    }

    /**
     * (experimental) Instead of actually publishing to package managers, just print the publishing command.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublishDryRun() {
        return null;
    }

    /**
     * (experimental) Define publishing tasks that can be executed manually as well as workflows.
     * <p>
     * Normally, publishing only happens within automated workflows. Enable this
     * in order to create a publishing task for each publishing activity.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublishTasks() {
        return null;
    }

    /**
     * (experimental) Find commits that should be considered releasable Used to decide if a release is required.
     * <p>
     * Default: ReleasableCommits.everyCommit()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.ReleasableCommits getReleasableCommits() {
        return null;
    }

    /**
     * (experimental) Defines additional release branches.
     * <p>
     * A workflow will be created for each
     * release branch which will publish releases from commits in this branch.
     * Each release branch <em>must</em> be assigned a major version number which is used
     * to enforce that versions published from that branch always use that major
     * version. If multiple branches are used, the <code>majorVersion</code> field must also
     * be provided for the default branch.
     * <p>
     * Default: - no additional branches are used for release. you can use
     * `addBranch()` to add additional branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions> getReleaseBranches() {
        return null;
    }

    /**
     * (deprecated) Automatically release new versions every commit to one of branches in <code>releaseBranches</code>.
     * <p>
     * Default: true
     * <p>
     * @deprecated Use <code>releaseTrigger: ReleaseTrigger.continuous()</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReleaseEveryCommit() {
        return null;
    }

    /**
     * (experimental) Create a github issue on every failed publishing task.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReleaseFailureIssue() {
        return null;
    }

    /**
     * (experimental) The label to apply to issues indicating publish failures.
     * <p>
     * Only applies if <code>releaseFailureIssue</code> is true.
     * <p>
     * Default: "failed-release"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseFailureIssueLabel() {
        return null;
    }

    /**
     * (deprecated) CRON schedule to trigger new releases.
     * <p>
     * Default: - no scheduled releases
     * <p>
     * @deprecated Use <code>releaseTrigger: ReleaseTrigger.scheduled()</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseSchedule() {
        return null;
    }

    /**
     * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
     * <p>
     * Note: this prefix is used to detect the latest tagged version
     * when bumping, so if you change this on a project with an existing version
     * history, you may need to manually tag your latest release
     * with the new prefix.
     * <p>
     * Default: "v"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseTagPrefix() {
        return null;
    }

    /**
     * (experimental) The release trigger to use.
     * <p>
     * Default: - Continuous releases (`ReleaseTrigger.continuous()`)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.ReleaseTrigger getReleaseTrigger() {
        return null;
    }

    /**
     * (experimental) The name of the default release workflow.
     * <p>
     * Default: "release"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseWorkflowName() {
        return null;
    }

    /**
     * (experimental) A set of workflow steps to execute in order to setup the workflow container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getReleaseWorkflowSetupSteps() {
        return null;
    }

    /**
     * (experimental) Custom configuration used when creating changelog with standard-version package.
     * <p>
     * Given values either append to default configuration or overwrite values in it.
     * <p>
     * Default: - standard configuration applicable for GitHub repositories
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions() {
        return null;
    }

    /**
     * (experimental) Container image to use for GitHub workflows.
     * <p>
     * Default: - default image
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkflowContainerImage() {
        return null;
    }

    /**
     * (experimental) Github Runner selection labels.
     * <p>
     * Default: ["ubuntu-latest"]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWorkflowRunsOn() {
        return null;
    }

    /**
     * (experimental) Github Runner Group selection options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.GroupRunnerOptions getWorkflowRunsOnGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReleaseProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReleaseProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ReleaseProjectOptions> {
        java.lang.String jsiiReleaseVersion;
        java.lang.Number majorVersion;
        java.lang.Number minMajorVersion;
        java.lang.String npmDistTag;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps;
        java.lang.String prerelease;
        java.lang.Boolean publishDryRun;
        java.lang.Boolean publishTasks;
        io.github.cdklabs.projen.ReleasableCommits releasableCommits;
        java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions> releaseBranches;
        java.lang.Boolean releaseEveryCommit;
        java.lang.Boolean releaseFailureIssue;
        java.lang.String releaseFailureIssueLabel;
        java.lang.String releaseSchedule;
        java.lang.String releaseTagPrefix;
        io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger;
        java.lang.String releaseWorkflowName;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps;
        java.util.Map<java.lang.String, java.lang.Object> versionrcOptions;
        java.lang.String workflowContainerImage;
        java.util.List<java.lang.String> workflowRunsOn;
        io.github.cdklabs.projen.GroupRunnerOptions workflowRunsOnGroup;

        /**
         * Sets the value of {@link ReleaseProjectOptions#getJsiiReleaseVersion}
         * @param jsiiReleaseVersion Version requirement of <code>publib</code> which is used to publish modules to npm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jsiiReleaseVersion(java.lang.String jsiiReleaseVersion) {
            this.jsiiReleaseVersion = jsiiReleaseVersion;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getMajorVersion}
         * @param majorVersion Major version to release from the default branch.
         *                     If this is specified, we bump the latest version of this major version line.
         *                     If not specified, we bump the global latest version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(java.lang.Number majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getMinMajorVersion}
         * @param minMajorVersion Minimal Major version to release.
         *                        This can be useful to set to 1, as breaking changes before the 1.x major
         *                        release are not incrementing the major version number.
         *                        <p>
         *                        Can not be set together with <code>majorVersion</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minMajorVersion(java.lang.Number minMajorVersion) {
            this.minMajorVersion = minMajorVersion;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getNpmDistTag}
         * @param npmDistTag The npmDistTag to use when publishing from the default branch.
         *                   To set the npm dist-tag for release branches, set the <code>npmDistTag</code> property
         *                   for each branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmDistTag(java.lang.String npmDistTag) {
            this.npmDistTag = npmDistTag;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getPostBuildSteps}
         * @param postBuildSteps Steps to execute after build as part of the release workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder postBuildSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.postBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)postBuildSteps;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getPrerelease}
         * @param prerelease Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prerelease(java.lang.String prerelease) {
            this.prerelease = prerelease;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getPublishDryRun}
         * @param publishDryRun Instead of actually publishing to package managers, just print the publishing command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishDryRun(java.lang.Boolean publishDryRun) {
            this.publishDryRun = publishDryRun;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getPublishTasks}
         * @param publishTasks Define publishing tasks that can be executed manually as well as workflows.
         *                     Normally, publishing only happens within automated workflows. Enable this
         *                     in order to create a publishing task for each publishing activity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTasks(java.lang.Boolean publishTasks) {
            this.publishTasks = publishTasks;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleasableCommits}
         * @param releasableCommits Find commits that should be considered releasable Used to decide if a release is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releasableCommits(io.github.cdklabs.projen.ReleasableCommits releasableCommits) {
            this.releasableCommits = releasableCommits;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseBranches}
         * @param releaseBranches Defines additional release branches.
         *                        A workflow will be created for each
         *                        release branch which will publish releases from commits in this branch.
         *                        Each release branch <em>must</em> be assigned a major version number which is used
         *                        to enforce that versions published from that branch always use that major
         *                        version. If multiple branches are used, the <code>majorVersion</code> field must also
         *                        be provided for the default branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder releaseBranches(java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.release.BranchOptions> releaseBranches) {
            this.releaseBranches = (java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>)releaseBranches;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseEveryCommit}
         * @param releaseEveryCommit Automatically release new versions every commit to one of branches in <code>releaseBranches</code>.
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.continuous()` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseEveryCommit(java.lang.Boolean releaseEveryCommit) {
            this.releaseEveryCommit = releaseEveryCommit;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseFailureIssue}
         * @param releaseFailureIssue Create a github issue on every failed publishing task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssue(java.lang.Boolean releaseFailureIssue) {
            this.releaseFailureIssue = releaseFailureIssue;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseFailureIssueLabel}
         * @param releaseFailureIssueLabel The label to apply to issues indicating publish failures.
         *                                 Only applies if <code>releaseFailureIssue</code> is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssueLabel(java.lang.String releaseFailureIssueLabel) {
            this.releaseFailureIssueLabel = releaseFailureIssueLabel;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseSchedule}
         * @param releaseSchedule CRON schedule to trigger new releases.
         * @return {@code this}
         * @deprecated Use `releaseTrigger: ReleaseTrigger.scheduled()` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseSchedule(java.lang.String releaseSchedule) {
            this.releaseSchedule = releaseSchedule;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseTagPrefix}
         * @param releaseTagPrefix Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
         *                         Note: this prefix is used to detect the latest tagged version
         *                         when bumping, so if you change this on a project with an existing version
         *                         history, you may need to manually tag your latest release
         *                         with the new prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagPrefix(java.lang.String releaseTagPrefix) {
            this.releaseTagPrefix = releaseTagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseTrigger}
         * @param releaseTrigger The release trigger to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTrigger(io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger) {
            this.releaseTrigger = releaseTrigger;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseWorkflowName}
         * @param releaseWorkflowName The name of the default release workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowName(java.lang.String releaseWorkflowName) {
            this.releaseWorkflowName = releaseWorkflowName;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getReleaseWorkflowSetupSteps}
         * @param releaseWorkflowSetupSteps A set of workflow steps to execute in order to setup the workflow container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder releaseWorkflowSetupSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps) {
            this.releaseWorkflowSetupSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)releaseWorkflowSetupSteps;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getVersionrcOptions}
         * @param versionrcOptions Custom configuration used when creating changelog with standard-version package.
         *                         Given values either append to default configuration or overwrite values in it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder versionrcOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> versionrcOptions) {
            this.versionrcOptions = (java.util.Map<java.lang.String, java.lang.Object>)versionrcOptions;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getWorkflowContainerImage}
         * @param workflowContainerImage Container image to use for GitHub workflows.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowContainerImage(java.lang.String workflowContainerImage) {
            this.workflowContainerImage = workflowContainerImage;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getWorkflowRunsOn}
         * @param workflowRunsOn Github Runner selection labels.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOn(java.util.List<java.lang.String> workflowRunsOn) {
            this.workflowRunsOn = workflowRunsOn;
            return this;
        }

        /**
         * Sets the value of {@link ReleaseProjectOptions#getWorkflowRunsOnGroup}
         * @param workflowRunsOnGroup Github Runner Group selection options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOnGroup(io.github.cdklabs.projen.GroupRunnerOptions workflowRunsOnGroup) {
            this.workflowRunsOnGroup = workflowRunsOnGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReleaseProjectOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ReleaseProjectOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReleaseProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReleaseProjectOptions {
        private final java.lang.String jsiiReleaseVersion;
        private final java.lang.Number majorVersion;
        private final java.lang.Number minMajorVersion;
        private final java.lang.String npmDistTag;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps;
        private final java.lang.String prerelease;
        private final java.lang.Boolean publishDryRun;
        private final java.lang.Boolean publishTasks;
        private final io.github.cdklabs.projen.ReleasableCommits releasableCommits;
        private final java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions> releaseBranches;
        private final java.lang.Boolean releaseEveryCommit;
        private final java.lang.Boolean releaseFailureIssue;
        private final java.lang.String releaseFailureIssueLabel;
        private final java.lang.String releaseSchedule;
        private final java.lang.String releaseTagPrefix;
        private final io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger;
        private final java.lang.String releaseWorkflowName;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps;
        private final java.util.Map<java.lang.String, java.lang.Object> versionrcOptions;
        private final java.lang.String workflowContainerImage;
        private final java.util.List<java.lang.String> workflowRunsOn;
        private final io.github.cdklabs.projen.GroupRunnerOptions workflowRunsOnGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jsiiReleaseVersion = software.amazon.jsii.Kernel.get(this, "jsiiReleaseVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.majorVersion = software.amazon.jsii.Kernel.get(this, "majorVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minMajorVersion = software.amazon.jsii.Kernel.get(this, "minMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.npmDistTag = software.amazon.jsii.Kernel.get(this, "npmDistTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.postBuildSteps = software.amazon.jsii.Kernel.get(this, "postBuildSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.prerelease = software.amazon.jsii.Kernel.get(this, "prerelease", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishDryRun = software.amazon.jsii.Kernel.get(this, "publishDryRun", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.publishTasks = software.amazon.jsii.Kernel.get(this, "publishTasks", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.releasableCommits = software.amazon.jsii.Kernel.get(this, "releasableCommits", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.ReleasableCommits.class));
            this.releaseBranches = software.amazon.jsii.Kernel.get(this, "releaseBranches", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.release.BranchOptions.class)));
            this.releaseEveryCommit = software.amazon.jsii.Kernel.get(this, "releaseEveryCommit", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.releaseFailureIssue = software.amazon.jsii.Kernel.get(this, "releaseFailureIssue", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.releaseFailureIssueLabel = software.amazon.jsii.Kernel.get(this, "releaseFailureIssueLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseSchedule = software.amazon.jsii.Kernel.get(this, "releaseSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseTagPrefix = software.amazon.jsii.Kernel.get(this, "releaseTagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseTrigger = software.amazon.jsii.Kernel.get(this, "releaseTrigger", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.release.ReleaseTrigger.class));
            this.releaseWorkflowName = software.amazon.jsii.Kernel.get(this, "releaseWorkflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseWorkflowSetupSteps = software.amazon.jsii.Kernel.get(this, "releaseWorkflowSetupSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.versionrcOptions = software.amazon.jsii.Kernel.get(this, "versionrcOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.workflowContainerImage = software.amazon.jsii.Kernel.get(this, "workflowContainerImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workflowRunsOn = software.amazon.jsii.Kernel.get(this, "workflowRunsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workflowRunsOnGroup = software.amazon.jsii.Kernel.get(this, "workflowRunsOnGroup", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.GroupRunnerOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jsiiReleaseVersion = builder.jsiiReleaseVersion;
            this.majorVersion = builder.majorVersion;
            this.minMajorVersion = builder.minMajorVersion;
            this.npmDistTag = builder.npmDistTag;
            this.postBuildSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.postBuildSteps;
            this.prerelease = builder.prerelease;
            this.publishDryRun = builder.publishDryRun;
            this.publishTasks = builder.publishTasks;
            this.releasableCommits = builder.releasableCommits;
            this.releaseBranches = (java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>)builder.releaseBranches;
            this.releaseEveryCommit = builder.releaseEveryCommit;
            this.releaseFailureIssue = builder.releaseFailureIssue;
            this.releaseFailureIssueLabel = builder.releaseFailureIssueLabel;
            this.releaseSchedule = builder.releaseSchedule;
            this.releaseTagPrefix = builder.releaseTagPrefix;
            this.releaseTrigger = builder.releaseTrigger;
            this.releaseWorkflowName = builder.releaseWorkflowName;
            this.releaseWorkflowSetupSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.releaseWorkflowSetupSteps;
            this.versionrcOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.versionrcOptions;
            this.workflowContainerImage = builder.workflowContainerImage;
            this.workflowRunsOn = builder.workflowRunsOn;
            this.workflowRunsOnGroup = builder.workflowRunsOnGroup;
        }

        @Override
        public final java.lang.String getJsiiReleaseVersion() {
            return this.jsiiReleaseVersion;
        }

        @Override
        public final java.lang.Number getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public final java.lang.Number getMinMajorVersion() {
            return this.minMajorVersion;
        }

        @Override
        public final java.lang.String getNpmDistTag() {
            return this.npmDistTag;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPostBuildSteps() {
            return this.postBuildSteps;
        }

        @Override
        public final java.lang.String getPrerelease() {
            return this.prerelease;
        }

        @Override
        public final java.lang.Boolean getPublishDryRun() {
            return this.publishDryRun;
        }

        @Override
        public final java.lang.Boolean getPublishTasks() {
            return this.publishTasks;
        }

        @Override
        public final io.github.cdklabs.projen.ReleasableCommits getReleasableCommits() {
            return this.releasableCommits;
        }

        @Override
        public final java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions> getReleaseBranches() {
            return this.releaseBranches;
        }

        @Override
        public final java.lang.Boolean getReleaseEveryCommit() {
            return this.releaseEveryCommit;
        }

        @Override
        public final java.lang.Boolean getReleaseFailureIssue() {
            return this.releaseFailureIssue;
        }

        @Override
        public final java.lang.String getReleaseFailureIssueLabel() {
            return this.releaseFailureIssueLabel;
        }

        @Override
        public final java.lang.String getReleaseSchedule() {
            return this.releaseSchedule;
        }

        @Override
        public final java.lang.String getReleaseTagPrefix() {
            return this.releaseTagPrefix;
        }

        @Override
        public final io.github.cdklabs.projen.release.ReleaseTrigger getReleaseTrigger() {
            return this.releaseTrigger;
        }

        @Override
        public final java.lang.String getReleaseWorkflowName() {
            return this.releaseWorkflowName;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getReleaseWorkflowSetupSteps() {
            return this.releaseWorkflowSetupSteps;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions() {
            return this.versionrcOptions;
        }

        @Override
        public final java.lang.String getWorkflowContainerImage() {
            return this.workflowContainerImage;
        }

        @Override
        public final java.util.List<java.lang.String> getWorkflowRunsOn() {
            return this.workflowRunsOn;
        }

        @Override
        public final io.github.cdklabs.projen.GroupRunnerOptions getWorkflowRunsOnGroup() {
            return this.workflowRunsOnGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJsiiReleaseVersion() != null) {
                data.set("jsiiReleaseVersion", om.valueToTree(this.getJsiiReleaseVersion()));
            }
            if (this.getMajorVersion() != null) {
                data.set("majorVersion", om.valueToTree(this.getMajorVersion()));
            }
            if (this.getMinMajorVersion() != null) {
                data.set("minMajorVersion", om.valueToTree(this.getMinMajorVersion()));
            }
            if (this.getNpmDistTag() != null) {
                data.set("npmDistTag", om.valueToTree(this.getNpmDistTag()));
            }
            if (this.getPostBuildSteps() != null) {
                data.set("postBuildSteps", om.valueToTree(this.getPostBuildSteps()));
            }
            if (this.getPrerelease() != null) {
                data.set("prerelease", om.valueToTree(this.getPrerelease()));
            }
            if (this.getPublishDryRun() != null) {
                data.set("publishDryRun", om.valueToTree(this.getPublishDryRun()));
            }
            if (this.getPublishTasks() != null) {
                data.set("publishTasks", om.valueToTree(this.getPublishTasks()));
            }
            if (this.getReleasableCommits() != null) {
                data.set("releasableCommits", om.valueToTree(this.getReleasableCommits()));
            }
            if (this.getReleaseBranches() != null) {
                data.set("releaseBranches", om.valueToTree(this.getReleaseBranches()));
            }
            if (this.getReleaseEveryCommit() != null) {
                data.set("releaseEveryCommit", om.valueToTree(this.getReleaseEveryCommit()));
            }
            if (this.getReleaseFailureIssue() != null) {
                data.set("releaseFailureIssue", om.valueToTree(this.getReleaseFailureIssue()));
            }
            if (this.getReleaseFailureIssueLabel() != null) {
                data.set("releaseFailureIssueLabel", om.valueToTree(this.getReleaseFailureIssueLabel()));
            }
            if (this.getReleaseSchedule() != null) {
                data.set("releaseSchedule", om.valueToTree(this.getReleaseSchedule()));
            }
            if (this.getReleaseTagPrefix() != null) {
                data.set("releaseTagPrefix", om.valueToTree(this.getReleaseTagPrefix()));
            }
            if (this.getReleaseTrigger() != null) {
                data.set("releaseTrigger", om.valueToTree(this.getReleaseTrigger()));
            }
            if (this.getReleaseWorkflowName() != null) {
                data.set("releaseWorkflowName", om.valueToTree(this.getReleaseWorkflowName()));
            }
            if (this.getReleaseWorkflowSetupSteps() != null) {
                data.set("releaseWorkflowSetupSteps", om.valueToTree(this.getReleaseWorkflowSetupSteps()));
            }
            if (this.getVersionrcOptions() != null) {
                data.set("versionrcOptions", om.valueToTree(this.getVersionrcOptions()));
            }
            if (this.getWorkflowContainerImage() != null) {
                data.set("workflowContainerImage", om.valueToTree(this.getWorkflowContainerImage()));
            }
            if (this.getWorkflowRunsOn() != null) {
                data.set("workflowRunsOn", om.valueToTree(this.getWorkflowRunsOn()));
            }
            if (this.getWorkflowRunsOnGroup() != null) {
                data.set("workflowRunsOnGroup", om.valueToTree(this.getWorkflowRunsOnGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.release.ReleaseProjectOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReleaseProjectOptions.Jsii$Proxy that = (ReleaseProjectOptions.Jsii$Proxy) o;

            if (this.jsiiReleaseVersion != null ? !this.jsiiReleaseVersion.equals(that.jsiiReleaseVersion) : that.jsiiReleaseVersion != null) return false;
            if (this.majorVersion != null ? !this.majorVersion.equals(that.majorVersion) : that.majorVersion != null) return false;
            if (this.minMajorVersion != null ? !this.minMajorVersion.equals(that.minMajorVersion) : that.minMajorVersion != null) return false;
            if (this.npmDistTag != null ? !this.npmDistTag.equals(that.npmDistTag) : that.npmDistTag != null) return false;
            if (this.postBuildSteps != null ? !this.postBuildSteps.equals(that.postBuildSteps) : that.postBuildSteps != null) return false;
            if (this.prerelease != null ? !this.prerelease.equals(that.prerelease) : that.prerelease != null) return false;
            if (this.publishDryRun != null ? !this.publishDryRun.equals(that.publishDryRun) : that.publishDryRun != null) return false;
            if (this.publishTasks != null ? !this.publishTasks.equals(that.publishTasks) : that.publishTasks != null) return false;
            if (this.releasableCommits != null ? !this.releasableCommits.equals(that.releasableCommits) : that.releasableCommits != null) return false;
            if (this.releaseBranches != null ? !this.releaseBranches.equals(that.releaseBranches) : that.releaseBranches != null) return false;
            if (this.releaseEveryCommit != null ? !this.releaseEveryCommit.equals(that.releaseEveryCommit) : that.releaseEveryCommit != null) return false;
            if (this.releaseFailureIssue != null ? !this.releaseFailureIssue.equals(that.releaseFailureIssue) : that.releaseFailureIssue != null) return false;
            if (this.releaseFailureIssueLabel != null ? !this.releaseFailureIssueLabel.equals(that.releaseFailureIssueLabel) : that.releaseFailureIssueLabel != null) return false;
            if (this.releaseSchedule != null ? !this.releaseSchedule.equals(that.releaseSchedule) : that.releaseSchedule != null) return false;
            if (this.releaseTagPrefix != null ? !this.releaseTagPrefix.equals(that.releaseTagPrefix) : that.releaseTagPrefix != null) return false;
            if (this.releaseTrigger != null ? !this.releaseTrigger.equals(that.releaseTrigger) : that.releaseTrigger != null) return false;
            if (this.releaseWorkflowName != null ? !this.releaseWorkflowName.equals(that.releaseWorkflowName) : that.releaseWorkflowName != null) return false;
            if (this.releaseWorkflowSetupSteps != null ? !this.releaseWorkflowSetupSteps.equals(that.releaseWorkflowSetupSteps) : that.releaseWorkflowSetupSteps != null) return false;
            if (this.versionrcOptions != null ? !this.versionrcOptions.equals(that.versionrcOptions) : that.versionrcOptions != null) return false;
            if (this.workflowContainerImage != null ? !this.workflowContainerImage.equals(that.workflowContainerImage) : that.workflowContainerImage != null) return false;
            if (this.workflowRunsOn != null ? !this.workflowRunsOn.equals(that.workflowRunsOn) : that.workflowRunsOn != null) return false;
            return this.workflowRunsOnGroup != null ? this.workflowRunsOnGroup.equals(that.workflowRunsOnGroup) : that.workflowRunsOnGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jsiiReleaseVersion != null ? this.jsiiReleaseVersion.hashCode() : 0;
            result = 31 * result + (this.majorVersion != null ? this.majorVersion.hashCode() : 0);
            result = 31 * result + (this.minMajorVersion != null ? this.minMajorVersion.hashCode() : 0);
            result = 31 * result + (this.npmDistTag != null ? this.npmDistTag.hashCode() : 0);
            result = 31 * result + (this.postBuildSteps != null ? this.postBuildSteps.hashCode() : 0);
            result = 31 * result + (this.prerelease != null ? this.prerelease.hashCode() : 0);
            result = 31 * result + (this.publishDryRun != null ? this.publishDryRun.hashCode() : 0);
            result = 31 * result + (this.publishTasks != null ? this.publishTasks.hashCode() : 0);
            result = 31 * result + (this.releasableCommits != null ? this.releasableCommits.hashCode() : 0);
            result = 31 * result + (this.releaseBranches != null ? this.releaseBranches.hashCode() : 0);
            result = 31 * result + (this.releaseEveryCommit != null ? this.releaseEveryCommit.hashCode() : 0);
            result = 31 * result + (this.releaseFailureIssue != null ? this.releaseFailureIssue.hashCode() : 0);
            result = 31 * result + (this.releaseFailureIssueLabel != null ? this.releaseFailureIssueLabel.hashCode() : 0);
            result = 31 * result + (this.releaseSchedule != null ? this.releaseSchedule.hashCode() : 0);
            result = 31 * result + (this.releaseTagPrefix != null ? this.releaseTagPrefix.hashCode() : 0);
            result = 31 * result + (this.releaseTrigger != null ? this.releaseTrigger.hashCode() : 0);
            result = 31 * result + (this.releaseWorkflowName != null ? this.releaseWorkflowName.hashCode() : 0);
            result = 31 * result + (this.releaseWorkflowSetupSteps != null ? this.releaseWorkflowSetupSteps.hashCode() : 0);
            result = 31 * result + (this.versionrcOptions != null ? this.versionrcOptions.hashCode() : 0);
            result = 31 * result + (this.workflowContainerImage != null ? this.workflowContainerImage.hashCode() : 0);
            result = 31 * result + (this.workflowRunsOn != null ? this.workflowRunsOn.hashCode() : 0);
            result = 31 * result + (this.workflowRunsOnGroup != null ? this.workflowRunsOnGroup.hashCode() : 0);
            return result;
        }
    }
}
