/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen;

import io.github.cdklabs.projen.;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.DevEnvironmentDockerImage;
import io.github.cdklabs.projen.GitpodOptions;
import io.github.cdklabs.projen.GitpodPrebuilds;
import io.github.cdklabs.projen.GitpodTask;
import io.github.cdklabs.projen.IDevEnvironment;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="projen.Gitpod")
public class Gitpod
extends Component
implements IDevEnvironment {
    protected Gitpod(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Gitpod(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Gitpod(@NotNull Project project, @Nullable GitpodOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public Gitpod(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    public void addCustomTask(@NotNull GitpodTask options) {
        Kernel.call((Object)this, (String)"addCustomTask", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void addDockerImage(@NotNull DevEnvironmentDockerImage image) {
        Kernel.call((Object)this, (String)"addDockerImage", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(image, "image is required")});
    }

    @Override
    public void addPorts(String ... ports) {
        Kernel.call((Object)this, (String)"addPorts", (NativeType)NativeType.VOID, (Object[])Arrays.stream(ports).toArray(Object[]::new));
    }

    public void addPrebuilds(@NotNull GitpodPrebuilds config) {
        Kernel.call((Object)this, (String)"addPrebuilds", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(config, "config is required")});
    }

    @Override
    public void addTasks(Task ... tasks) {
        Kernel.call((Object)this, (String)"addTasks", (NativeType)NativeType.VOID, (Object[])Arrays.stream(tasks).toArray(Object[]::new));
    }

    @Override
    public void addVscodeExtensions(String ... extensions) {
        Kernel.call((Object)this, (String)"addVscodeExtensions", (NativeType)NativeType.VOID, (Object[])Arrays.stream(extensions).toArray(Object[]::new));
    }

    @NotNull
    public Object getConfig() {
        return Kernel.get((Object)this, (String)"config", (NativeType)NativeType.forClass(Object.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Gitpod> {
        private final Project project;
        private GitpodOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder dockerImage(DevEnvironmentDockerImage dockerImage) {
            this.options().dockerImage(dockerImage);
            return this;
        }

        public Builder ports(List<String> ports) {
            this.options().ports(ports);
            return this;
        }

        public Builder tasks(List<? extends Task> tasks) {
            this.options().tasks(tasks);
            return this;
        }

        public Builder vscodeExtensions(List<String> vscodeExtensions) {
            this.options().vscodeExtensions(vscodeExtensions);
            return this;
        }

        public Builder prebuilds(GitpodPrebuilds prebuilds) {
            this.options().prebuilds(prebuilds);
            return this;
        }

        public Gitpod build() {
            return new Gitpod(this.project, this.options != null ? this.options.build() : null);
        }

        private GitpodOptions.Builder options() {
            if (this.options == null) {
                this.options = new GitpodOptions.Builder();
            }
            return this.options;
        }
    }
}

