/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.FileBase;
import io.github.cdklabs.projen.IResolver;
import io.github.cdklabs.projen.MakefileOptions;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Rule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.Makefile")
public class Makefile
extends FileBase {
    protected Makefile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Makefile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Makefile(@NotNull Project project, @NotNull String filePath, @Nullable MakefileOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(filePath, "filePath is required"), options});
    }

    public Makefile(@NotNull Project project, @NotNull String filePath) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(filePath, "filePath is required")});
    }

    @NotNull
    public Makefile addAll(@NotNull String target) {
        return (Makefile)((Object)Kernel.call((Object)((Object)this), (String)"addAll", (NativeType)NativeType.forClass(Makefile.class), (Object[])new Object[]{Objects.requireNonNull(target, "target is required")}));
    }

    @NotNull
    public Makefile addAlls(String ... targets) {
        return (Makefile)((Object)Kernel.call((Object)((Object)this), (String)"addAlls", (NativeType)NativeType.forClass(Makefile.class), (Object[])Arrays.stream(targets).toArray(Object[]::new)));
    }

    @NotNull
    public Makefile addRule(@NotNull Rule rule) {
        return (Makefile)((Object)Kernel.call((Object)((Object)this), (String)"addRule", (NativeType)NativeType.forClass(Makefile.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")}));
    }

    @NotNull
    public Makefile addRules(Rule ... rules) {
        return (Makefile)((Object)Kernel.call((Object)((Object)this), (String)"addRules", (NativeType)NativeType.forClass(Makefile.class), (Object[])Arrays.stream(rules).toArray(Object[]::new)));
    }

    @Override
    @Nullable
    protected String synthesizeContent(@NotNull IResolver resolver) {
        return (String)Kernel.call((Object)((Object)this), (String)"synthesizeContent", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(resolver, "resolver is required")});
    }

    @NotNull
    public List<Rule> getRules() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"rules", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Rule.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Makefile> {
        private final Project project;
        private final String filePath;
        private MakefileOptions.Builder options;

        public static Builder create(Project project, String filePath) {
            return new Builder(project, filePath);
        }

        private Builder(Project project, String filePath) {
            this.project = project;
            this.filePath = filePath;
        }

        public Builder committed(Boolean committed) {
            this.options().committed(committed);
            return this;
        }

        public Builder editGitignore(Boolean editGitignore) {
            this.options().editGitignore(editGitignore);
            return this;
        }

        public Builder executable(Boolean executable) {
            this.options().executable(executable);
            return this;
        }

        public Builder marker(Boolean marker) {
            this.options().marker(marker);
            return this;
        }

        public Builder readonly(Boolean readonly) {
            this.options().readonly(readonly);
            return this;
        }

        public Builder all(List<String> all) {
            this.options().all(all);
            return this;
        }

        public Builder rules(List<? extends Rule> rules) {
            this.options().rules(rules);
            return this;
        }

        public Makefile build() {
            return new Makefile(this.project, this.filePath, this.options != null ? this.options.build() : null);
        }

        private MakefileOptions.Builder options() {
            if (this.options == null) {
                this.options = new MakefileOptions.Builder();
            }
            return this.options;
        }
    }
}

