/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.TaskOptions;
import io.github.cdklabs.projen.TaskStep;
import io.github.cdklabs.projen.TaskStepOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.Task")
public class Task
extends JsiiObject {
    protected Task(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Task(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Task(@NotNull String name, @Nullable TaskOptions props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(name, "name is required"), props});
    }

    public Task(@NotNull String name) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    public void addCondition(String ... condition) {
        Kernel.call((Object)((Object)this), (String)"addCondition", (NativeType)NativeType.VOID, (Object[])Arrays.stream(condition).toArray(Object[]::new));
    }

    public void builtin(@NotNull String name) {
        Kernel.call((Object)((Object)this), (String)"builtin", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    public void env(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)((Object)this), (String)"env", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void exec(@NotNull String command, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"exec", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(command, "command is required"), options});
    }

    public void exec(@NotNull String command) {
        Kernel.call((Object)((Object)this), (String)"exec", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(command, "command is required")});
    }

    public void lock() {
        Kernel.call((Object)((Object)this), (String)"lock", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Deprecated
    public void prepend(@NotNull String shell, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"prepend", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(shell, "shell is required"), options});
    }

    @Deprecated
    public void prepend(@NotNull String shell) {
        Kernel.call((Object)((Object)this), (String)"prepend", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(shell, "shell is required")});
    }

    public void prependExec(@NotNull String shell, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"prependExec", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(shell, "shell is required"), options});
    }

    public void prependExec(@NotNull String shell) {
        Kernel.call((Object)((Object)this), (String)"prependExec", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(shell, "shell is required")});
    }

    public void prependSay(@NotNull String message, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"prependSay", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(message, "message is required"), options});
    }

    public void prependSay(@NotNull String message) {
        Kernel.call((Object)((Object)this), (String)"prependSay", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void prependSpawn(@NotNull Task subtask, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"prependSpawn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(subtask, "subtask is required"), options});
    }

    public void prependSpawn(@NotNull Task subtask) {
        Kernel.call((Object)((Object)this), (String)"prependSpawn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(subtask, "subtask is required")});
    }

    public void removeStep(@NotNull Number index) {
        Kernel.call((Object)((Object)this), (String)"removeStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(index, "index is required")});
    }

    public void reset(@Nullable String command, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"reset", (NativeType)NativeType.VOID, (Object[])new Object[]{command, options});
    }

    public void reset(@Nullable String command) {
        Kernel.call((Object)((Object)this), (String)"reset", (NativeType)NativeType.VOID, (Object[])new Object[]{command});
    }

    public void reset() {
        Kernel.call((Object)((Object)this), (String)"reset", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void say(@NotNull String message, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"say", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(message, "message is required"), options});
    }

    public void say(@NotNull String message) {
        Kernel.call((Object)((Object)this), (String)"say", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void spawn(@NotNull Task subtask, @Nullable TaskStepOptions options) {
        Kernel.call((Object)((Object)this), (String)"spawn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(subtask, "subtask is required"), options});
    }

    public void spawn(@NotNull Task subtask) {
        Kernel.call((Object)((Object)this), (String)"spawn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(subtask, "subtask is required")});
    }

    public void updateStep(@NotNull Number index, @NotNull TaskStep step) {
        Kernel.call((Object)((Object)this), (String)"updateStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(step, "step is required")});
    }

    @NotNull
    public Map<String, String> getEnvVars() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"envVars", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<TaskStep> getSteps() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"steps", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(TaskStep.class))));
    }

    @Nullable
    public String getCondition() {
        return (String)Kernel.get((Object)((Object)this), (String)"condition", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getCwd() {
        return (String)Kernel.get((Object)((Object)this), (String)"cwd", (NativeType)NativeType.forClass(String.class));
    }

    public void setCwd(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"cwd", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Task> {
        private final String name;
        private TaskOptions.Builder props;

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            this.name = name;
        }

        public Builder condition(String condition) {
            this.props().condition(condition);
            return this;
        }

        public Builder cwd(String cwd) {
            this.props().cwd(cwd);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.props().env(env);
            return this;
        }

        public Builder requiredEnv(List<String> requiredEnv) {
            this.props().requiredEnv(requiredEnv);
            return this;
        }

        public Builder args(List<String> args) {
            this.props().args(args);
            return this;
        }

        public Builder exec(String exec) {
            this.props().exec(exec);
            return this;
        }

        public Builder receiveArgs(Boolean receiveArgs) {
            this.props().receiveArgs(receiveArgs);
            return this;
        }

        public Builder steps(List<? extends TaskStep> steps) {
            this.props().steps(steps);
            return this;
        }

        public Task build() {
            return new Task(this.name, this.props != null ? this.props.build() : null);
        }

        private TaskOptions.Builder props() {
            if (this.props == null) {
                this.props = new TaskOptions.Builder();
            }
            return this.props;
        }
    }
}

