/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.build;

import io.github.cdklabs.projen.;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.GroupRunnerOptions;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.build.AddPostBuildJobCommandsOptions;
import io.github.cdklabs.projen.build.AddPostBuildJobTaskOptions;
import io.github.cdklabs.projen.build.BuildWorkflowOptions;
import io.github.cdklabs.projen.github.GitIdentity;
import io.github.cdklabs.projen.github.workflows.Job;
import io.github.cdklabs.projen.github.workflows.JobPermissions;
import io.github.cdklabs.projen.github.workflows.JobStep;
import io.github.cdklabs.projen.github.workflows.Triggers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="projen.build.BuildWorkflow")
public class BuildWorkflow
extends Component {
    protected BuildWorkflow(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BuildWorkflow(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BuildWorkflow(@NotNull Project project, @NotNull BuildWorkflowOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addPostBuildJob(@NotNull String id, @NotNull Job job) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildJob", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(job, "job is required")});
    }

    public void addPostBuildJobCommands(@NotNull String id, @NotNull List<String> commands, @Nullable AddPostBuildJobCommandsOptions options) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildJobCommands", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(commands, "commands is required"), options});
    }

    public void addPostBuildJobCommands(@NotNull String id, @NotNull List<String> commands) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildJobCommands", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(commands, "commands is required")});
    }

    public void addPostBuildJobTask(@NotNull Task task, @Nullable AddPostBuildJobTaskOptions options) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildJobTask", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(task, "task is required"), options});
    }

    public void addPostBuildJobTask(@NotNull Task task) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildJobTask", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(task, "task is required")});
    }

    public void addPostBuildSteps(JobStep ... steps) {
        Kernel.call((Object)((Object)this), (String)"addPostBuildSteps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(steps).toArray(Object[]::new));
    }

    @NotNull
    public List<String> getBuildJobIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"buildJobIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BuildWorkflow> {
        private final Project project;
        private final BuildWorkflowOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
            this.options = new BuildWorkflowOptions.Builder();
        }

        public Builder artifactsDirectory(String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        public Builder buildTask(Task buildTask) {
            this.options.buildTask(buildTask);
            return this;
        }

        public Builder containerImage(String containerImage) {
            this.options.containerImage(containerImage);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.options.env(env);
            return this;
        }

        public Builder gitIdentity(GitIdentity gitIdentity) {
            this.options.gitIdentity(gitIdentity);
            return this;
        }

        public Builder mutableBuild(Boolean mutableBuild) {
            this.options.mutableBuild(mutableBuild);
            return this;
        }

        public Builder name(String name) {
            this.options.name(name);
            return this;
        }

        public Builder permissions(JobPermissions permissions) {
            this.options.permissions(permissions);
            return this;
        }

        public Builder postBuildSteps(List<? extends JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        public Builder preBuildSteps(List<? extends JobStep> preBuildSteps) {
            this.options.preBuildSteps(preBuildSteps);
            return this;
        }

        public Builder runsOn(List<String> runsOn) {
            this.options.runsOn(runsOn);
            return this;
        }

        public Builder runsOnGroup(GroupRunnerOptions runsOnGroup) {
            this.options.runsOnGroup(runsOnGroup);
            return this;
        }

        public Builder workflowTriggers(Triggers workflowTriggers) {
            this.options.workflowTriggers(workflowTriggers);
            return this;
        }

        public BuildWorkflow build() {
            return new BuildWorkflow(this.project, this.options.build());
        }
    }
}

