/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.circleci;

import io.github.cdklabs.projen.;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.YamlFile;
import io.github.cdklabs.projen.circleci.CircleCiProps;
import io.github.cdklabs.projen.circleci.Job;
import io.github.cdklabs.projen.circleci.Workflow;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="projen.circleci.Circleci")
public class Circleci
extends Component {
    protected Circleci(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Circleci(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Circleci(@NotNull Project project, @Nullable CircleCiProps options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public Circleci(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    public void addOrb(@NotNull String name, @NotNull String orb) {
        Kernel.call((Object)((Object)this), (String)"addOrb", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(orb, "orb is required")});
    }

    public void addWorkflow(@NotNull Workflow workflow) {
        Kernel.call((Object)((Object)this), (String)"addWorkflow", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(workflow, "workflow is required")});
    }

    @NotNull
    public YamlFile getFile() {
        return (YamlFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(YamlFile.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Circleci> {
        private final Project project;
        private CircleCiProps.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder jobs(List<? extends Job> jobs) {
            this.options().jobs(jobs);
            return this;
        }

        public Builder orbs(Map<String, String> orbs) {
            this.options().orbs(orbs);
            return this;
        }

        public Builder setup(Boolean setup) {
            this.options().setup(setup);
            return this;
        }

        public Builder version(Number version) {
            this.options().version(version);
            return this;
        }

        public Builder workflows(List<? extends Workflow> workflows) {
            this.options().workflows(workflows);
            return this;
        }

        public Circleci build() {
            return new Circleci(this.project, this.options != null ? this.options.build() : null);
        }

        private CircleCiProps.Builder options() {
            if (this.options == null) {
                this.options = new CircleCiProps.Builder();
            }
            return this.options;
        }
    }
}

