/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.github;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.YamlFile;
import io.github.cdklabs.projen.github.GitHub;
import io.github.cdklabs.projen.github.GithubCredentials;
import io.github.cdklabs.projen.github.GithubWorkflowOptions;
import io.github.cdklabs.projen.github.workflows.Job;
import io.github.cdklabs.projen.github.workflows.JobCallingReusableWorkflow;
import io.github.cdklabs.projen.github.workflows.Triggers;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.github.GithubWorkflow")
public class GithubWorkflow
extends Component {
    protected GithubWorkflow(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GithubWorkflow(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GithubWorkflow(@NotNull GitHub github, @NotNull String name, @Nullable GithubWorkflowOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(github, "github is required"), Objects.requireNonNull(name, "name is required"), options});
    }

    public GithubWorkflow(@NotNull GitHub github, @NotNull String name) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(github, "github is required"), Objects.requireNonNull(name, "name is required")});
    }

    public void addJob(@NotNull String id, @NotNull Object job) {
        if (Configuration.getRuntimeTypeChecking() && !(job instanceof JobCallingReusableWorkflow) && !(job instanceof Job) && !job.getClass().equals(JsiiObject.class)) {
            throw new IllegalArgumentException("Expected " + "job" + " to be one of: io.github.cdklabs.projen.github.workflows.JobCallingReusableWorkflow, io.github.cdklabs.projen.github.workflows.Job; received " + job.getClass());
        }
        Kernel.call((Object)((Object)this), (String)"addJob", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(job, "job is required")});
    }

    public void addJobs(@NotNull Map<String, Object> jobs) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(jobs.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "jobs" + ".keySet()" + " to contain class String; received " + jobs.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_c3e4e7 : jobs.entrySet()) {
                Object __val_c3e4e7 = __item_c3e4e7.getValue();
                if (__val_c3e4e7 instanceof JobCallingReusableWorkflow || __val_c3e4e7 instanceof Job || __val_c3e4e7.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "jobs" + ".get(\"" + __item_c3e4e7.getKey() + "\")" + " to be one of: io.github.cdklabs.projen.github.workflows.JobCallingReusableWorkflow, io.github.cdklabs.projen.github.workflows.Job; received " + __val_c3e4e7.getClass());
            }
        }
        Kernel.call((Object)((Object)this), (String)"addJobs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(jobs, "jobs is required")});
    }

    @NotNull
    public Object getJob(@NotNull String id) {
        return Kernel.call((Object)((Object)this), (String)"getJob", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public void on(@NotNull Triggers events) {
        Kernel.call((Object)((Object)this), (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(events, "events is required")});
    }

    public void removeJob(@NotNull String id) {
        Kernel.call((Object)((Object)this), (String)"removeJob", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public void updateJob(@NotNull String id, @NotNull Object job) {
        if (Configuration.getRuntimeTypeChecking() && !(job instanceof JobCallingReusableWorkflow) && !(job instanceof Job) && !job.getClass().equals(JsiiObject.class)) {
            throw new IllegalArgumentException("Expected " + "job" + " to be one of: io.github.cdklabs.projen.github.workflows.JobCallingReusableWorkflow, io.github.cdklabs.projen.github.workflows.Job; received " + job.getClass());
        }
        Kernel.call((Object)((Object)this), (String)"updateJob", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(job, "job is required")});
    }

    public void updateJobs(@NotNull Map<String, Object> jobs) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(jobs.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "jobs" + ".keySet()" + " to contain class String; received " + jobs.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_c3e4e7 : jobs.entrySet()) {
                Object __val_c3e4e7 = __item_c3e4e7.getValue();
                if (__val_c3e4e7 instanceof JobCallingReusableWorkflow || __val_c3e4e7 instanceof Job || __val_c3e4e7.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "jobs" + ".get(\"" + __item_c3e4e7.getKey() + "\")" + " to be one of: io.github.cdklabs.projen.github.workflows.JobCallingReusableWorkflow, io.github.cdklabs.projen.github.workflows.Job; received " + __val_c3e4e7.getClass());
            }
        }
        Kernel.call((Object)((Object)this), (String)"updateJobs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(jobs, "jobs is required")});
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public GithubCredentials getProjenCredentials() {
        return (GithubCredentials)((Object)Kernel.get((Object)((Object)this), (String)"projenCredentials", (NativeType)NativeType.forClass(GithubCredentials.class)));
    }

    @Nullable
    public String getConcurrency() {
        return (String)Kernel.get((Object)((Object)this), (String)"concurrency", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public YamlFile getFile() {
        return (YamlFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(YamlFile.class)));
    }

    @Nullable
    public String getRunName() {
        return (String)Kernel.get((Object)((Object)this), (String)"runName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRunName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"runName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GithubWorkflow> {
        private final GitHub github;
        private final String name;
        private GithubWorkflowOptions.Builder options;

        public static Builder create(GitHub github, String name) {
            return new Builder(github, name);
        }

        private Builder(GitHub github, String name) {
            this.github = github;
            this.name = name;
        }

        public Builder concurrency(String concurrency) {
            this.options().concurrency(concurrency);
            return this;
        }

        public Builder force(Boolean force) {
            this.options().force(force);
            return this;
        }

        public GithubWorkflow build() {
            return new GithubWorkflow(this.github, this.name, this.options != null ? this.options.build() : null);
        }

        private GithubWorkflowOptions.Builder options() {
            if (this.options == null) {
                this.options = new GithubWorkflowOptions.Builder();
            }
            return this.options;
        }
    }
}

