/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.javascript;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.IgnoreFile;
import io.github.cdklabs.projen.IgnoreFileOptions;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.javascript.NodeProject;
import io.github.cdklabs.projen.javascript.PrettierOptions;
import io.github.cdklabs.projen.javascript.PrettierOverride;
import io.github.cdklabs.projen.javascript.PrettierSettings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.javascript.Prettier")
public class Prettier
extends Component {
    protected Prettier(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Prettier(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Prettier(@NotNull NodeProject project, @NotNull PrettierOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Nullable
    public static Prettier of(@NotNull Project project) {
        return (Prettier)((Object)JsiiObject.jsiiStaticCall(Prettier.class, (String)"of", (NativeType)NativeType.forClass(Prettier.class), (Object[])new Object[]{Objects.requireNonNull(project, "project is required")}));
    }

    public void addIgnorePattern(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addIgnorePattern", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addOverride(@NotNull PrettierOverride override) {
        Kernel.call((Object)((Object)this), (String)"addOverride", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(override, "override is required")});
    }

    @Override
    public void preSynthesize() {
        Kernel.call((Object)((Object)this), (String)"preSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public List<PrettierOverride> getOverrides() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"overrides", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PrettierOverride.class))));
    }

    @NotNull
    public PrettierSettings getSettings() {
        return (PrettierSettings)Kernel.get((Object)((Object)this), (String)"settings", (NativeType)NativeType.forClass(PrettierSettings.class));
    }

    @Nullable
    public IgnoreFile getIgnoreFile() {
        return (IgnoreFile)((Object)Kernel.get((Object)((Object)this), (String)"ignoreFile", (NativeType)NativeType.forClass(IgnoreFile.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Prettier> {
        private final NodeProject project;
        private final PrettierOptions.Builder options;

        public static Builder create(NodeProject project) {
            return new Builder(project);
        }

        private Builder(NodeProject project) {
            this.project = project;
            this.options = new PrettierOptions.Builder();
        }

        public Builder ignoreFile(Boolean ignoreFile) {
            this.options.ignoreFile(ignoreFile);
            return this;
        }

        public Builder ignoreFileOptions(IgnoreFileOptions ignoreFileOptions) {
            this.options.ignoreFileOptions(ignoreFileOptions);
            return this;
        }

        public Builder overrides(List<? extends PrettierOverride> overrides) {
            this.options.overrides(overrides);
            return this;
        }

        public Builder settings(PrettierSettings settings) {
            this.options.settings(settings);
            return this;
        }

        public Builder yaml(Boolean yaml) {
            this.options.yaml(yaml);
            return this;
        }

        public Prettier build() {
            return new Prettier(this.project, this.options.build());
        }
    }
}

