/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.release;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.GroupRunnerOptions;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.github.workflows.JobStep;
import io.github.cdklabs.projen.release.GitHubReleasesPublishOptions;
import io.github.cdklabs.projen.release.GitPublishOptions;
import io.github.cdklabs.projen.release.GoPublishOptions;
import io.github.cdklabs.projen.release.MavenPublishOptions;
import io.github.cdklabs.projen.release.NpmPublishOptions;
import io.github.cdklabs.projen.release.NugetPublishOptions;
import io.github.cdklabs.projen.release.PublisherOptions;
import io.github.cdklabs.projen.release.PyPiPublishOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.release.Publisher")
public class Publisher
extends Component {
    public static final String PUBLISH_GIT_TASK_NAME = (String)JsiiObject.jsiiStaticGet(Publisher.class, (String)"PUBLISH_GIT_TASK_NAME", (NativeType)NativeType.forClass(String.class));

    protected Publisher(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Publisher(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Publisher(@NotNull Project project, @NotNull PublisherOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addGitHubPostPublishingSteps(JobStep ... steps) {
        Kernel.call((Object)((Object)this), (String)"addGitHubPostPublishingSteps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(steps).toArray(Object[]::new));
    }

    public void addGitHubPrePublishingSteps(JobStep ... steps) {
        Kernel.call((Object)((Object)this), (String)"addGitHubPrePublishingSteps", (NativeType)NativeType.VOID, (Object[])Arrays.stream(steps).toArray(Object[]::new));
    }

    @NotNull
    public Task publishToGit(@NotNull GitPublishOptions options) {
        return (Task)((Object)Kernel.call((Object)((Object)this), (String)"publishToGit", (NativeType)NativeType.forClass(Task.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")}));
    }

    public void publishToGitHubReleases(@NotNull GitHubReleasesPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToGitHubReleases", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    public void publishToGo(@Nullable GoPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToGo", (NativeType)NativeType.VOID, (Object[])new Object[]{options});
    }

    public void publishToGo() {
        Kernel.call((Object)((Object)this), (String)"publishToGo", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void publishToMaven(@Nullable MavenPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToMaven", (NativeType)NativeType.VOID, (Object[])new Object[]{options});
    }

    public void publishToMaven() {
        Kernel.call((Object)((Object)this), (String)"publishToMaven", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void publishToNpm(@Nullable NpmPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToNpm", (NativeType)NativeType.VOID, (Object[])new Object[]{options});
    }

    public void publishToNpm() {
        Kernel.call((Object)((Object)this), (String)"publishToNpm", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void publishToNuget(@Nullable NugetPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToNuget", (NativeType)NativeType.VOID, (Object[])new Object[]{options});
    }

    public void publishToNuget() {
        Kernel.call((Object)((Object)this), (String)"publishToNuget", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void publishToPyPi(@Nullable PyPiPublishOptions options) {
        Kernel.call((Object)((Object)this), (String)"publishToPyPi", (NativeType)NativeType.VOID, (Object[])new Object[]{options});
    }

    public void publishToPyPi() {
        Kernel.call((Object)((Object)this), (String)"publishToPyPi", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public String getArtifactName() {
        return (String)Kernel.get((Object)((Object)this), (String)"artifactName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getBuildJobId() {
        return (String)Kernel.get((Object)((Object)this), (String)"buildJobId", (NativeType)NativeType.forClass(String.class));
    }

    @Deprecated
    @NotNull
    public String getJsiiReleaseVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"jsiiReleaseVersion", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getPublibVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"publibVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getCondition() {
        return (String)Kernel.get((Object)((Object)this), (String)"condition", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Publisher> {
        private final Project project;
        private final PublisherOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
            this.options = new PublisherOptions.Builder();
        }

        public Builder artifactName(String artifactName) {
            this.options.artifactName(artifactName);
            return this;
        }

        public Builder buildJobId(String buildJobId) {
            this.options.buildJobId(buildJobId);
            return this;
        }

        public Builder condition(String condition) {
            this.options.condition(condition);
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.options.dryRun(dryRun);
            return this;
        }

        public Builder failureIssue(Boolean failureIssue) {
            this.options.failureIssue(failureIssue);
            return this;
        }

        public Builder failureIssueLabel(String failureIssueLabel) {
            this.options.failureIssueLabel(failureIssueLabel);
            return this;
        }

        @Deprecated
        public Builder jsiiReleaseVersion(String jsiiReleaseVersion) {
            this.options.jsiiReleaseVersion(jsiiReleaseVersion);
            return this;
        }

        public Builder publibVersion(String publibVersion) {
            this.options.publibVersion(publibVersion);
            return this;
        }

        public Builder publishTasks(Boolean publishTasks) {
            this.options.publishTasks(publishTasks);
            return this;
        }

        public Builder workflowContainerImage(String workflowContainerImage) {
            this.options.workflowContainerImage(workflowContainerImage);
            return this;
        }

        public Builder workflowNodeVersion(String workflowNodeVersion) {
            this.options.workflowNodeVersion(workflowNodeVersion);
            return this;
        }

        public Builder workflowRunsOn(List<String> workflowRunsOn) {
            this.options.workflowRunsOn(workflowRunsOn);
            return this;
        }

        public Builder workflowRunsOnGroup(GroupRunnerOptions workflowRunsOnGroup) {
            this.options.workflowRunsOnGroup(workflowRunsOnGroup);
            return this;
        }

        public Publisher build() {
            return new Publisher(this.project, this.options.build());
        }
    }
}

