package io.github.cdklabs.projen;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:28.858Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.CreateProjectOptions")
@software.amazon.jsii.Jsii.Proxy(CreateProjectOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CreateProjectOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Directory that the project will be generated in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDir();

    /**
     * (experimental) Fully-qualified name of the project type (usually formatted as <code>projen.module.ProjectType</code>).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * `projen.typescript.TypescriptProject`
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectFqn();

    /**
     * (experimental) Project options.
     * <p>
     * Only JSON-like values can be passed in (strings,
     * booleans, numbers, enums, arrays, and objects that are not
     * derived from classes).
     * <p>
     * Consult the API reference of the project type you are generating for
     * information about what fields and types are available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getProjectOptions();

    /**
     * (experimental) Should we render commented-out default options in the projenrc file?
     * <p>
     * Does not apply to projenrc.json files.
     * <p>
     * Default: InitProjectOptionHints.FEATURED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.InitProjectOptionHints getOptionHints() {
        return null;
    }

    /**
     * (experimental) Should we execute post synthesis hooks?
     * <p>
     * (usually package manager install).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPost() {
        return null;
    }

    /**
     * (experimental) Should we call <code>project.synth()</code> or instantiate the project (could still have side-effects) and render the .projenrc file.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSynth() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CreateProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CreateProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CreateProjectOptions> {
        java.lang.String dir;
        java.lang.String projectFqn;
        java.util.Map<java.lang.String, java.lang.Object> projectOptions;
        io.github.cdklabs.projen.InitProjectOptionHints optionHints;
        java.lang.Boolean post;
        java.lang.Boolean synth;

        /**
         * Sets the value of {@link CreateProjectOptions#getDir}
         * @param dir Directory that the project will be generated in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dir(java.lang.String dir) {
            this.dir = dir;
            return this;
        }

        /**
         * Sets the value of {@link CreateProjectOptions#getProjectFqn}
         * @param projectFqn Fully-qualified name of the project type (usually formatted as <code>projen.module.ProjectType</code>). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectFqn(java.lang.String projectFqn) {
            this.projectFqn = projectFqn;
            return this;
        }

        /**
         * Sets the value of {@link CreateProjectOptions#getProjectOptions}
         * @param projectOptions Project options. This parameter is required.
         *                       Only JSON-like values can be passed in (strings,
         *                       booleans, numbers, enums, arrays, and objects that are not
         *                       derived from classes).
         *                       <p>
         *                       Consult the API reference of the project type you are generating for
         *                       information about what fields and types are available.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder projectOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> projectOptions) {
            this.projectOptions = (java.util.Map<java.lang.String, java.lang.Object>)projectOptions;
            return this;
        }

        /**
         * Sets the value of {@link CreateProjectOptions#getOptionHints}
         * @param optionHints Should we render commented-out default options in the projenrc file?.
         *                    Does not apply to projenrc.json files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder optionHints(io.github.cdklabs.projen.InitProjectOptionHints optionHints) {
            this.optionHints = optionHints;
            return this;
        }

        /**
         * Sets the value of {@link CreateProjectOptions#getPost}
         * @param post Should we execute post synthesis hooks?.
         *             (usually package manager install).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder post(java.lang.Boolean post) {
            this.post = post;
            return this;
        }

        /**
         * Sets the value of {@link CreateProjectOptions#getSynth}
         * @param synth Should we call <code>project.synth()</code> or instantiate the project (could still have side-effects) and render the .projenrc file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder synth(java.lang.Boolean synth) {
            this.synth = synth;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CreateProjectOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CreateProjectOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CreateProjectOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateProjectOptions {
        private final java.lang.String dir;
        private final java.lang.String projectFqn;
        private final java.util.Map<java.lang.String, java.lang.Object> projectOptions;
        private final io.github.cdklabs.projen.InitProjectOptionHints optionHints;
        private final java.lang.Boolean post;
        private final java.lang.Boolean synth;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dir = software.amazon.jsii.Kernel.get(this, "dir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectFqn = software.amazon.jsii.Kernel.get(this, "projectFqn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectOptions = software.amazon.jsii.Kernel.get(this, "projectOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.optionHints = software.amazon.jsii.Kernel.get(this, "optionHints", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.InitProjectOptionHints.class));
            this.post = software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.synth = software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dir = java.util.Objects.requireNonNull(builder.dir, "dir is required");
            this.projectFqn = java.util.Objects.requireNonNull(builder.projectFqn, "projectFqn is required");
            this.projectOptions = (java.util.Map<java.lang.String, java.lang.Object>)java.util.Objects.requireNonNull(builder.projectOptions, "projectOptions is required");
            this.optionHints = builder.optionHints;
            this.post = builder.post;
            this.synth = builder.synth;
        }

        @Override
        public final java.lang.String getDir() {
            return this.dir;
        }

        @Override
        public final java.lang.String getProjectFqn() {
            return this.projectFqn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getProjectOptions() {
            return this.projectOptions;
        }

        @Override
        public final io.github.cdklabs.projen.InitProjectOptionHints getOptionHints() {
            return this.optionHints;
        }

        @Override
        public final java.lang.Boolean getPost() {
            return this.post;
        }

        @Override
        public final java.lang.Boolean getSynth() {
            return this.synth;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dir", om.valueToTree(this.getDir()));
            data.set("projectFqn", om.valueToTree(this.getProjectFqn()));
            data.set("projectOptions", om.valueToTree(this.getProjectOptions()));
            if (this.getOptionHints() != null) {
                data.set("optionHints", om.valueToTree(this.getOptionHints()));
            }
            if (this.getPost() != null) {
                data.set("post", om.valueToTree(this.getPost()));
            }
            if (this.getSynth() != null) {
                data.set("synth", om.valueToTree(this.getSynth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.CreateProjectOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CreateProjectOptions.Jsii$Proxy that = (CreateProjectOptions.Jsii$Proxy) o;

            if (!dir.equals(that.dir)) return false;
            if (!projectFqn.equals(that.projectFqn)) return false;
            if (!projectOptions.equals(that.projectOptions)) return false;
            if (this.optionHints != null ? !this.optionHints.equals(that.optionHints) : that.optionHints != null) return false;
            if (this.post != null ? !this.post.equals(that.post) : that.post != null) return false;
            return this.synth != null ? this.synth.equals(that.synth) : that.synth == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dir.hashCode();
            result = 31 * result + (this.projectFqn.hashCode());
            result = 31 * result + (this.projectOptions.hashCode());
            result = 31 * result + (this.optionHints != null ? this.optionHints.hashCode() : 0);
            result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
            result = 31 * result + (this.synth != null ? this.synth.hashCode() : 0);
            return result;
        }
    }
}
