package io.github.cdklabs.projen;

/**
 * (experimental) Utility for applying RFC-6902 JSON-Patch to a document.
 * <p>
 * Use the the <code>JsonPatch.apply(doc, ...ops)</code> function to apply a set of
 * operations to a JSON document and return the result.
 * <p>
 * Operations can be created using the factory methods <code>JsonPatch.add()</code>,
 * <code>JsonPatch.remove()</code>, etc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * const output = JsonPatch.apply(input,
 *  JsonPatch.replace('/world/hi/there', 'goodbye'),
 *  JsonPatch.add('/world/foo/', 'boom'),
 *  JsonPatch.remove('/hello'));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:28.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.JsonPatch")
public class JsonPatch extends software.amazon.jsii.JsiiObject {

    protected JsonPatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonPatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Adds a value to an object or inserts it into an array.
     * <p>
     * In the case of an
     * array, the value is inserted before the given index. The - character can be
     * used instead of an index to insert at the end of an array.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.add('/biscuits/1', { "name": "Ginger Nut" })
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch add(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "add", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value });
    }

    /**
     * (experimental) Applies a set of JSON-Patch (RFC-6902) operations to <code>document</code> and returns the result.
     * <p>
     * @return The result document
     * @param document The document to patch. This parameter is required.
     * @param ops The operations to apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.Object apply(final @org.jetbrains.annotations.NotNull java.lang.Object document, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch... ops) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "apply", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { document }), java.util.Arrays.<Object>stream(ops)).toArray(Object[]::new));
    }

    /**
     * (experimental) Copies a value from one location to another within the JSON document.
     * <p>
     * Both
     * from and path are JSON Pointers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.copy('/biscuits/0', '/best_biscuit')
     * </pre></blockquote>
     * <p>
     * @param from This parameter is required.
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch copy(final @org.jetbrains.annotations.NotNull java.lang.String from, final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "copy", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(from, "from is required"), java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Escapes a json pointer path.
     * <p>
     * @return the Escaped path
     * @param path The raw pointer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.String escapePath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "escapePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Moves a value from one location to the other.
     * <p>
     * Both from and path are JSON Pointers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.move('/biscuits', '/cookies')
     * </pre></blockquote>
     * <p>
     * @param from This parameter is required.
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch move(final @org.jetbrains.annotations.NotNull java.lang.String from, final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "move", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(from, "from is required"), java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Removes a value from an object or array.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.remove('/biscuits/0')
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch remove(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "remove", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Replaces a value.
     * <p>
     * Equivalent to a “remove” followed by an “add”.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.replace('/biscuits/0/name', 'Chocolate Digestive')
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch replace(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "replace", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value });
    }

    /**
     * (experimental) Tests that the specified value is set in the document.
     * <p>
     * If the test fails,
     * then the patch as a whole should not apply.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.test('/best_biscuit/name', 'Choco Leibniz')
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     * @param value This parameter is required.
     * @param failureBehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch test(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.TestFailureBehavior failureBehavior) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "test", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value, failureBehavior });
    }

    /**
     * (experimental) Tests that the specified value is set in the document.
     * <p>
     * If the test fails,
     * then the patch as a whole should not apply.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * JsonPatch.test('/best_biscuit/name', 'Choco Leibniz')
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.JsonPatch test(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.JsonPatch.class, "test", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.JsonPatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value });
    }
}
