package io.github.cdklabs.projen.awscdk;

/**
 * (experimental) Generates a pre-bundled AWS Lambda function construct from handler code.
 * <p>
 * To use this, create an AWS Lambda handler file under your source tree with
 * the <code>.lambda.ts</code> extension and add a <code>LambdaFunction</code> component to your
 * typescript project pointing to this entrypoint.
 * <p>
 * This will add a task to your "compile" step which will use <code>esbuild</code> to
 * bundle the handler code into the build directory. It will also generate a
 * file <code>src/foo-function.ts</code> with a custom AWS construct called <code>FooFunction</code>
 * which extends <code>&#64;aws-cdk/aws-lambda.Function</code> which is bound to the bundled
 * handle through an asset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * new LambdaFunction(myProject, {
 *   srcdir: myProject.srcdir,
 *   entrypoint: 'src/foo.lambda.ts',
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.082Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.awscdk.LambdaFunction")
public class LambdaFunction extends io.github.cdklabs.projen.Component {

    protected LambdaFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Defines a pre-bundled AWS Lambda function construct from handler code.
     * <p>
     * @param project The project to use. This parameter is required.
     * @param options Options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LambdaFunction(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.awscdk.LambdaFunctionOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.awscdk.LambdaFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.awscdk.LambdaFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project The project to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private final io.github.cdklabs.projen.awscdk.LambdaFunctionOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
            this.options = new io.github.cdklabs.projen.awscdk.LambdaFunctionOptions.Builder();
        }

        /**
         * (experimental) Whether to automatically reuse TCP connections when working with the AWS SDK for JavaScript.
         * <p>
         * This sets the <code>AWS_NODEJS_CONNECTION_REUSE_ENABLED</code> environment variable
         * to <code>1</code>.
         * <p>
         * Not applicable when <code>edgeLambda</code> is set to <code>true</code> because environment
         * variables are not supported in Lambda&#64;Edge.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html">https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html</a>
         * @param awsSdkConnectionReuse Whether to automatically reuse TCP connections when working with the AWS SDK for JavaScript. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder awsSdkConnectionReuse(final java.lang.Boolean awsSdkConnectionReuse) {
            this.options.awsSdkConnectionReuse(awsSdkConnectionReuse);
            return this;
        }

        /**
         * (experimental) Bundling options for this AWS Lambda function.
         * <p>
         * If not specified the default bundling options specified for the project
         * <code>Bundler</code> instance will be used.
         * <p>
         * Default: - defaults
         * <p>
         * @return {@code this}
         * @param bundlingOptions Bundling options for this AWS Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundlingOptions(final io.github.cdklabs.projen.javascript.BundlingOptions bundlingOptions) {
            this.options.bundlingOptions(bundlingOptions);
            return this;
        }

        /**
         * (experimental) Whether to create a <code>cloudfront.experimental.EdgeFunction</code> instead of a <code>lambda.Function</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param edgeLambda Whether to create a <code>cloudfront.experimental.EdgeFunction</code> instead of a <code>lambda.Function</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder edgeLambda(final java.lang.Boolean edgeLambda) {
            this.options.edgeLambda(edgeLambda);
            return this;
        }

        /**
         * (experimental) The node.js version to target.
         * <p>
         * Default: Runtime.NODEJS_18_X
         * <p>
         * @return {@code this}
         * @param runtime The node.js version to target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(final io.github.cdklabs.projen.awscdk.LambdaRuntime runtime) {
            this.options.runtime(runtime);
            return this;
        }

        /**
         * (experimental) AWS CDK dependency manager.
         * <p>
         * @return {@code this}
         * @param cdkDeps AWS CDK dependency manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkDeps(final io.github.cdklabs.projen.awscdk.AwsCdkDeps cdkDeps) {
            this.options.cdkDeps(cdkDeps);
            return this;
        }

        /**
         * (experimental) A path from the project root directory to a TypeScript file which contains the AWS Lambda handler entrypoint (exports a <code>handler</code> function).
         * <p>
         * This is relative to the root directory of the project.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "src/subdir/foo.lambda.ts"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param entrypoint A path from the project root directory to a TypeScript file which contains the AWS Lambda handler entrypoint (exports a <code>handler</code> function). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypoint(final java.lang.String entrypoint) {
            this.options.entrypoint(entrypoint);
            return this;
        }

        /**
         * (experimental) The name of the generated TypeScript source file.
         * <p>
         * This file should also be
         * under the source tree.
         * <p>
         * Default: - The name of the entrypoint file, with the `-function.ts` suffix
         * instead of `.lambda.ts`.
         * <p>
         * @return {@code this}
         * @param constructFile The name of the generated TypeScript source file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder constructFile(final java.lang.String constructFile) {
            this.options.constructFile(constructFile);
            return this;
        }

        /**
         * (experimental) The name of the generated <code>lambda.Function</code> subclass.
         * <p>
         * Default: - A pascal cased version of the name of the entrypoint file, with
         * the extension `Function` (e.g. `ResizeImageFunction`).
         * <p>
         * @return {@code this}
         * @param constructName The name of the generated <code>lambda.Function</code> subclass. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder constructName(final java.lang.String constructName) {
            this.options.constructName(constructName);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.awscdk.LambdaFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.awscdk.LambdaFunction build() {
            return new io.github.cdklabs.projen.awscdk.LambdaFunction(
                this.project,
                this.options.build()
            );
        }
    }
}
